/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.objects;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.gui.objects.PagedResultQuery;

public class DisplayedResultQuery
extends PagedResultQuery {
    private static final String ASCENDING = "ascending";
    private static final String UNSORTED = "unsorted";
    private static final String RANDOM = "random";
    private static final String DESCENDING = "descending";
    private static final long serialVersionUID = 6985425160111122181L;
    private Set<Long> selectedMatches = new TreeSet<Long>();
    private String baseText;

    public DisplayedResultQuery() {
    }

    public DisplayedResultQuery(DisplayedResultQuery orig) {
        super(orig);
        this.selectedMatches = orig.getSelectedMatches();
        this.baseText = orig.getBaseText();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DisplayedResultQuery other = (DisplayedResultQuery)obj;
        return Objects.equals(this.getQuery(), other.getQuery()) && Objects.equals(this.getCorpora(), other.getCorpora()) && Objects.equals(this.getLeftContext(), other.getLeftContext()) && Objects.equals(this.getRightContext(), other.getRightContext()) && Objects.equals(this.getSegmentation(), other.getSegmentation()) && Objects.equals(this.getLimit(), other.getLimit()) && Objects.equals(this.getOffset(), other.getOffset()) && Objects.equals((Object)this.getOrder(), (Object)other.getOrder()) && Objects.equals(this.getBaseText(), other.getBaseText()) && Objects.equals(this.getSelectedMatches(), other.getSelectedMatches());
    }

    public String getBaseText() {
        return this.baseText;
    }

    @Override
    public Map<String, String> getCitationFragmentArguments() {
        Map<String, String> result = super.getCitationFragmentArguments();
        if (!Objects.equals(this.getBaseText(), this.getSegmentation())) {
            result.put("_bt", this.getBaseText() == null ? "" : this.getBaseText());
        }
        if (this.getOrder() != FindQuery.OrderEnum.NORMAL && this.getOrder() != null) {
            if (this.getOrder() == FindQuery.OrderEnum.INVERTED) {
                result.put("o", DESCENDING);
            } else if (this.getOrder() == FindQuery.OrderEnum.RANDOMIZED) {
                result.put("o", RANDOM);
            } else if (this.getOrder() == FindQuery.OrderEnum.NOTSORTED) {
                result.put("o", UNSORTED);
            }
        }
        if (this.getSelectedMatches() != null && !this.getSelectedMatches().isEmpty()) {
            result.put("m", Joiner.on((char)',').join(this.getSelectedMatches()));
        }
        return result;
    }

    public static FindQuery.OrderEnum parseOrderFromCitationFragment(String value) {
        if (value != null) {
            switch (value.toLowerCase()) {
                case "ascending": {
                    return FindQuery.OrderEnum.NORMAL;
                }
                case "descending": {
                    return FindQuery.OrderEnum.INVERTED;
                }
                case "random": {
                    return FindQuery.OrderEnum.RANDOMIZED;
                }
                case "unsorted": {
                    return FindQuery.OrderEnum.NOTSORTED;
                }
            }
        }
        return FindQuery.OrderEnum.NORMAL;
    }

    public Set<Long> getSelectedMatches() {
        return this.selectedMatches;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getCorpora(), this.getQuery(), this.getLeftContext(), this.getRightContext(), this.getSegmentation(), this.getLimit(), this.getOffset(), this.getOrder(), this.getBaseText(), this.getSelectedMatches()});
    }

    public void setBaseText(String baseText) {
        this.baseText = baseText;
    }

    public void setSelectedMatches(Set<Long> selectedMatches) {
        Preconditions.checkNotNull(selectedMatches, (Object)"The selected matches set of a paged result query must never be null (but can be empty)");
        this.selectedMatches = selectedMatches;
    }
}

