/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.objects;

import com.vaadin.v7.data.util.BeanContainer;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.data.util.ObjectProperty;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import okhttp3.Call;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.gui.exporter.CSVExporter;
import org.corpus_tools.annis.gui.exporter.ExporterPlugin;
import org.corpus_tools.annis.gui.frequency.UserGeneratedFrequencyEntry;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.objects.QueryLanguage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUIState
implements Serializable {
    private static final long serialVersionUID = -883486391491336806L;
    private static final Logger log = LoggerFactory.getLogger(QueryUIState.class);
    private final ObjectProperty<String> aql = new ObjectProperty((Object)"");
    private Set<String> selectedCorpora = new LinkedHashSet<String>();
    private int leftContext = 5;
    private int rightContext = 5;
    private int limit = 10;
    private final ObjectProperty<Long> offset = new ObjectProperty((Object)0L);
    private final ObjectProperty<String> visibleBaseText = new ObjectProperty(null, String.class);
    private String contextSegmentation = null;
    private FindQuery.OrderEnum order = FindQuery.OrderEnum.NORMAL;
    private org.corpus_tools.annis.api.model.QueryLanguage queryLanguage = org.corpus_tools.annis.api.model.QueryLanguage.AQL;
    private final ObjectProperty<Set<Long>> selectedMatches = new ObjectProperty(new TreeSet());
    private final ObjectProperty<Class<? extends ExporterPlugin>> exporter = new ObjectProperty(CSVExporter.class);
    private final ObjectProperty<List<String>> exportAnnotationKeys = new ObjectProperty(new ArrayList());
    private final ObjectProperty<String> exportParameters = new ObjectProperty((Object)"");
    private final ObjectProperty<Boolean> alignmc = new ObjectProperty((Object)false);
    private transient Map<QueryType, Future<?>> executedTasks;
    private transient Map<QueryType, Call> executedCalls;
    private final BeanContainer<Integer, UserGeneratedFrequencyEntry> frequencyTableDefinition = new BeanContainer(UserGeneratedFrequencyEntry.class);
    private final BeanItemContainer<Query> history = new BeanItemContainer(Query.class);

    public QueryUIState() {
        this.initTransients();
    }

    public ObjectProperty<Boolean> getAlignmc() {
        return this.alignmc;
    }

    public ObjectProperty<String> getAql() {
        return this.aql;
    }

    public String getContextSegmentation() {
        return this.contextSegmentation;
    }

    public void setContextSegmentation(String contextSegmentation) {
        this.contextSegmentation = contextSegmentation;
    }

    public Map<QueryType, Future<?>> getExecutedTasks() {
        return this.executedTasks;
    }

    public Map<QueryType, Call> getExecutedCalls() {
        return this.executedCalls;
    }

    public ObjectProperty<List<String>> getExportAnnotationKeys() {
        return this.exportAnnotationKeys;
    }

    public ObjectProperty<Class<? extends ExporterPlugin>> getExporter() {
        return this.exporter;
    }

    public ObjectProperty<String> getExportParameters() {
        return this.exportParameters;
    }

    public BeanContainer<Integer, UserGeneratedFrequencyEntry> getFrequencyTableDefinition() {
        return this.frequencyTableDefinition;
    }

    public BeanItemContainer<Query> getHistory() {
        return this.history;
    }

    public int getLeftContext() {
        return this.leftContext;
    }

    public void setLeftContext(int leftContext) {
        this.leftContext = leftContext;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public ObjectProperty<Long> getOffset() {
        return this.offset;
    }

    public FindQuery.OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(FindQuery.OrderEnum order) {
        this.order = order;
    }

    public org.corpus_tools.annis.api.model.QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    public QueryLanguage getQueryLanguageLegacy() {
        if (this.queryLanguage == org.corpus_tools.annis.api.model.QueryLanguage.AQLQUIRKSV3) {
            return QueryLanguage.AQL_QUIRKS_V3;
        }
        return QueryLanguage.AQL;
    }

    public void setQueryLanguage(org.corpus_tools.annis.api.model.QueryLanguage queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    public void setQueryLanguageLegacy(QueryLanguage queryLanguage) {
        this.queryLanguage = queryLanguage == QueryLanguage.AQL_QUIRKS_V3 ? org.corpus_tools.annis.api.model.QueryLanguage.AQLQUIRKSV3 : org.corpus_tools.annis.api.model.QueryLanguage.AQL;
    }

    public int getRightContext() {
        return this.rightContext;
    }

    public void setRightContext(int rightContext) {
        this.rightContext = rightContext;
    }

    public Set<String> getSelectedCorpora() {
        return this.selectedCorpora;
    }

    public void setSelectedCorpora(Set<String> selectedCorpora) {
        this.selectedCorpora = selectedCorpora;
    }

    public ObjectProperty<Set<Long>> getSelectedMatches() {
        return this.selectedMatches;
    }

    public ObjectProperty<String> getVisibleBaseText() {
        return this.visibleBaseText;
    }

    private void initTransients() {
        this.executedTasks = new EnumMap(QueryType.class);
        this.executedCalls = new EnumMap<QueryType, Call>(QueryType.class);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    public static enum QueryType {
        COUNT,
        FIND,
        FREQUENCY,
        EXPORT;

    }
}

