/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.objects;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.corpus_tools.annis.api.model.VisualizerRule;

@XmlRootElement
public class Visualizer
implements Serializable {
    private static final long serialVersionUID = 6429465444658974246L;
    private String type;
    private String displayName;
    private String mappings;
    private String namespace;

    public Visualizer() {
    }

    public Visualizer(VisualizerRule rule) {
        this.setDisplayName(rule.getDisplayName());
        this.setMappings(Visualizer.fromMappings(rule.getMappings()));
        this.setNamespace(rule.getLayer());
        this.setType(rule.getVisType());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMappings() {
        return this.mappings;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return this.type;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setMappings(String mappings) {
        this.mappings = mappings;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setType(String type) {
        this.type = type;
    }

    public VisualizerRule toVisualizerRule() {
        VisualizerRule newVis = new VisualizerRule();
        newVis.setDisplayName(this.getDisplayName());
        newVis.setLayer(this.getNamespace());
        newVis.setMappings(Visualizer.parseMappings(this.getMappings()));
        newVis.setVisibility(VisualizerRule.VisibilityEnum.HIDDEN);
        newVis.setVisType(this.getType());
        return newVis;
    }

    private static Map<String, String> parseMappings(String mappings) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (mappings != null) {
            String[] entries;
            for (String e : entries = mappings.split(";")) {
                String[] keyvalue = e.split(":", 2);
                if (keyvalue.length != 2) continue;
                result.put(keyvalue[0].trim(), keyvalue[1].trim());
            }
        }
        return result;
    }

    private static String fromMappings(Map<String, String> mappings) {
        if (mappings == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = mappings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            sb.append(e.getKey());
            sb.append(":");
            sb.append(e.getValue());
            if (!it.hasNext()) continue;
            sb.append(";");
        }
        return sb.toString();
    }
}

