/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.paging;

import com.vaadin.event.Action;
import com.vaadin.event.ShortcutAction;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.validator.AbstractStringValidator;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextField;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringEscapeUtils;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.paging.PagingCallback;
import org.corpus_tools.annis.gui.query_references.ShareQueryReferenceWindow;
import org.corpus_tools.annis.gui.util.ANNISFontIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagingComponent
extends Panel
implements Button.ClickListener {
    private static final long serialVersionUID = -1223055982053787434L;
    private static final Logger log = LoggerFactory.getLogger(PagingComponent.class);
    public static final Resource LEFT_ARROW = ANNISFontIcon.LEFT_ARROW;
    public static final Resource RIGHT_ARROW = ANNISFontIcon.RIGHT_ARROW;
    public static final Resource FIRST = ANNISFontIcon.FIRST;
    public static final Resource LAST = ANNISFontIcon.LAST;
    private HorizontalLayout layout;
    private Button btFirst;
    private Button btLast;
    private Button btNext;
    private Button btPrevious;
    private TextField txtPage;
    private Label lblMaxPages;
    private Label lblStatus;
    private Set<PagingCallback> callbacks;
    private AtomicLong count;
    private int pageSize;
    private long currentPage;
    private Label lblInfo;
    private final Button btShareQuery;

    public PagingComponent() {
        this(0, 0);
    }

    public PagingComponent(int count, int pageSize) {
        if (pageSize <= 0) {
            pageSize = 1;
        }
        if (count < 0) {
            count = 0;
        }
        this.currentPage = 1L;
        this.count = new AtomicLong(pageSize);
        this.pageSize = pageSize;
        this.setWidth("100%");
        this.setHeight("-1px");
        this.addStyleName("toolbar");
        this.callbacks = new HashSet<PagingCallback>();
        this.layout = new HorizontalLayout();
        this.layout.setSpacing(true);
        this.layout.setMargin(new MarginInfo(false, true, false, true));
        this.setContent((Component)this.layout);
        this.addStyleName("light");
        this.lblInfo = new Label();
        this.lblInfo.setContentMode(ContentMode.HTML);
        this.lblInfo.addStyleName("right-aligned-text");
        this.btShareQuery = new Button((Resource)VaadinIcons.CONNECT);
        this.btShareQuery.setDescription("Share query reference link");
        this.btShareQuery.addStyleName("borderless");
        this.layout.setWidth("100%");
        this.layout.setHeight("-1px");
        this.btFirst = new Button();
        this.btFirst.setIcon(FIRST);
        this.btFirst.setDescription("jump to first page");
        this.btFirst.addClickListener((Button.ClickListener)this);
        this.btFirst.addStyleName("icon-only");
        this.btFirst.addStyleName("small");
        this.btFirst.setDisableOnClick(true);
        this.btLast = new Button();
        this.btLast.setIcon(LAST);
        this.btLast.setDescription("jump to last page");
        this.btLast.addClickListener((Button.ClickListener)this);
        this.btLast.addStyleName("icon-only");
        this.btLast.addStyleName("small");
        this.btLast.setDisableOnClick(true);
        this.btNext = new Button();
        this.btNext.setIcon(RIGHT_ARROW);
        this.btNext.setDescription("jump to next page");
        this.btNext.addClickListener((Button.ClickListener)this);
        this.btNext.addStyleName("icon-only");
        this.btNext.addStyleName("small");
        this.btNext.setDisableOnClick(true);
        this.btPrevious = new Button();
        this.btPrevious.setIcon(LEFT_ARROW);
        this.btPrevious.setDescription("jump to previous page");
        this.btPrevious.addClickListener((Button.ClickListener)this);
        this.btPrevious.addStyleName("icon-only");
        this.btPrevious.addStyleName("small");
        this.btPrevious.setDisableOnClick(true);
        this.txtPage = new TextField();
        this.txtPage.setDescription("current page");
        this.txtPage.setHeight("-1px");
        this.txtPage.setWidth(5.0f, Sizeable.Unit.EM);
        PageValidator pageValidator = new PageValidator("must be an integer greater than zero");
        this.txtPage.addValidator((Validator)pageValidator);
        this.addActionHandler(new EnterHandler(this.txtPage));
        this.lblMaxPages = new Label();
        this.lblMaxPages.setDescription("maximal pages");
        this.lblMaxPages.setSizeUndefined();
        this.lblStatus = new Label();
        this.lblStatus.setSizeUndefined();
        this.layout.addComponent((Component)this.btFirst);
        this.layout.addComponent((Component)this.btPrevious);
        this.layout.addComponent((Component)this.txtPage);
        this.layout.addComponent((Component)this.lblMaxPages);
        this.layout.addComponent((Component)this.btNext);
        this.layout.addComponent((Component)this.btLast);
        this.layout.addComponent((Component)this.lblStatus);
        this.layout.addComponent((Component)this.lblInfo);
        this.layout.addComponent((Component)this.btShareQuery);
        this.layout.setComponentAlignment((Component)this.btFirst, Alignment.MIDDLE_LEFT);
        this.layout.setComponentAlignment((Component)this.btPrevious, Alignment.MIDDLE_LEFT);
        this.layout.setComponentAlignment((Component)this.lblStatus, Alignment.MIDDLE_LEFT);
        this.layout.setComponentAlignment((Component)this.lblMaxPages, Alignment.MIDDLE_CENTER);
        this.layout.setComponentAlignment((Component)this.txtPage, Alignment.MIDDLE_RIGHT);
        this.layout.setComponentAlignment((Component)this.btNext, Alignment.MIDDLE_RIGHT);
        this.layout.setComponentAlignment((Component)this.btLast, Alignment.MIDDLE_RIGHT);
        this.layout.setExpandRatio((Component)this.lblStatus, 1.0f);
        this.layout.setComponentAlignment((Component)this.lblInfo, Alignment.MIDDLE_RIGHT);
        this.layout.setExpandRatio((Component)this.lblInfo, 10.0f);
        this.update(false);
    }

    public void addCallback(PagingCallback callback) {
        this.callbacks.add(callback);
    }

    public void attach() {
        super.attach();
        if (this.getUI() instanceof AnnisUI) {
            this.btShareQuery.addClickListener((Button.ClickListener)new QueryReferenceLinkHandler((AnnisUI)this.getUI()));
        } else {
            this.btShareQuery.setVisible(false);
        }
    }

    public void buttonClick(Button.ClickEvent event) {
        this.btFirst.setEnabled(true);
        this.btLast.setEnabled(true);
        this.btNext.setEnabled(true);
        this.btPrevious.setEnabled(true);
        if (event.getButton() == this.btFirst) {
            this.currentPage = 1L;
        } else if (event.getButton() == this.btLast) {
            this.currentPage = this.getMaxPage();
        } else if (event.getButton() == this.btNext) {
            ++this.currentPage;
        } else if (event.getButton() == this.btPrevious) {
            --this.currentPage;
        }
        this.currentPage = this.sanitizePage(this.currentPage);
        this.update(true);
    }

    public long getCount() {
        return this.count.get();
    }

    public long getMaxPage() {
        long mycount = Math.max(0L, this.count.get() - 1L);
        return 1L + mycount / (long)this.pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getStartNumber() {
        return (this.currentPage - 1L) * (long)this.pageSize;
    }

    private long sanitizePage(long page) {
        long val = Math.max(1L, page);
        val = Math.min(1L + this.count.get() / (long)this.pageSize, val);
        return val;
    }

    public void setCount(long count, boolean update) {
        if (count < 0L) {
            count = 0L;
        }
        this.count.set(count);
        this.update(update);
    }

    public void setInfo(String text) {
        if (text != null && text.length() > 0) {
            String prefix = "Result for: <span class=\"corpus-font-force\">";
            this.lblInfo.setDescription(prefix + text.replaceAll("\n", " ") + "</span>");
            this.lblInfo.setValue(text.length() < 50 ? prefix + StringEscapeUtils.escapeHtml4((String)text) : prefix + StringEscapeUtils.escapeHtml4((String)text.substring(0, 50)) + " ... </span>");
        }
    }

    public void setPageSize(int pageSize, boolean informCallback) {
        if (pageSize <= 0) {
            pageSize = 1;
        }
        this.pageSize = pageSize;
        this.update(informCallback);
    }

    public void setStartNumber(long startNumber) {
        this.currentPage = startNumber / (long)this.pageSize + 1L;
        this.update(false);
    }

    private void update(boolean informCallbacks) {
        long myCount = this.count.get();
        this.txtPage.setValue("" + this.currentPage);
        this.lblMaxPages.setValue("/ " + this.getMaxPage());
        this.lblStatus.setValue("Displaying Results " + (this.getStartNumber() + 1L) + " - " + Math.min(this.getStartNumber() + (long)this.pageSize, myCount) + " of " + myCount);
        this.btFirst.setEnabled(this.currentPage > 1L);
        this.btPrevious.setEnabled(this.currentPage > 1L);
        this.btLast.setEnabled(this.currentPage < this.getMaxPage());
        this.btNext.setEnabled(this.currentPage < this.getMaxPage());
        if (informCallbacks) {
            for (PagingCallback c : this.callbacks) {
                c.switchPage(this.getStartNumber(), this.pageSize);
            }
        }
    }

    private class QueryReferenceLinkHandler
    implements Button.ClickListener {
        private static final long serialVersionUID = 6453378232614759301L;
        private final AnnisUI ui;

        public QueryReferenceLinkHandler(AnnisUI ui) {
            this.ui = ui;
        }

        public void buttonClick(Button.ClickEvent event) {
            ShareQueryReferenceWindow w = new ShareQueryReferenceWindow(this.ui.getQueryController().getSearchQuery(), this.ui.getConfig().isShortenReferenceLinks() && !this.ui.isDesktopMode());
            PagingComponent.this.getUI().addWindow((Window)w);
            w.center();
        }
    }

    private static class PageValidator
    extends AbstractStringValidator {
        private static final long serialVersionUID = -5555305640028288933L;

        public PageValidator(String errorMessage) {
            super(errorMessage);
        }

        protected boolean isValidValue(String value) {
            try {
                int v = Integer.parseInt(value);
                return v > 0;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    private class EnterHandler
    implements Action.Handler {
        private static final long serialVersionUID = -823785799057108550L;
        private final Action enterKeyShortcutAction = new ShortcutAction(null, 13, null);
        private final Object registeredTarget;

        public EnterHandler(Object registeredTarget) {
            this.registeredTarget = registeredTarget;
        }

        public Action[] getActions(Object target, Object sender) {
            return new Action[]{this.enterKeyShortcutAction};
        }

        public void handleAction(Action action, Object sender, Object target) {
            if (action == this.enterKeyShortcutAction && target == this.registeredTarget) {
                try {
                    int newPage = Integer.parseInt((String)PagingComponent.this.txtPage.getValue());
                    PagingComponent.this.currentPage = PagingComponent.this.sanitizePage(newPage);
                    PagingComponent.this.update(true);
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
        }
    }
}

