/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.query_references;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextArea;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.objects.DisplayedResultQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareQueryReferenceWindow
extends Window
implements Button.ClickListener {
    private static final long serialVersionUID = 8839761991143179718L;
    private static final Logger log = LoggerFactory.getLogger(ShareQueryReferenceWindow.class);
    private final DisplayedResultQuery query;
    private final boolean shorten;
    private TextArea txtCitation;

    public ShareQueryReferenceWindow(DisplayedResultQuery query, boolean shorten) {
        super("Query reference link");
        this.query = query;
        this.shorten = shorten;
        VerticalLayout wLayout = new VerticalLayout();
        this.setContent((Component)wLayout);
        wLayout.setSizeFull();
        wLayout.setMargin(true);
        Label lblInfo = new Label("<p style=\"font-size: 18px\" ><strong>Share your query:</strong>&nbsp;1.&nbsp;Copy the generated link 2.&nbsp;Share this link with your peers. </p>", ContentMode.HTML);
        wLayout.addComponent((Component)lblInfo);
        wLayout.setExpandRatio((Component)lblInfo, 0.0f);
        this.txtCitation = new TextArea();
        this.txtCitation.setWidth("100%");
        this.txtCitation.setHeight("100%");
        this.txtCitation.addStyleName("large");
        this.txtCitation.addStyleName("shared-text");
        this.txtCitation.setWordwrap(true);
        this.txtCitation.setReadOnly(true);
        wLayout.addComponent((Component)this.txtCitation);
        Button btClose = new Button("Close");
        btClose.addClickListener((Button.ClickListener)this);
        btClose.setSizeUndefined();
        wLayout.addComponent((Component)btClose);
        wLayout.setExpandRatio((Component)this.txtCitation, 1.0f);
        wLayout.setComponentAlignment((Component)btClose, Alignment.BOTTOM_CENTER);
        this.setWidth("400px");
        this.setHeight("300px");
    }

    public void attach() {
        super.attach();
        String shortURL = "ERROR";
        UI ui = UI.getCurrent();
        if (this.query != null && ui instanceof AnnisUI) {
            AnnisUI annisUI = (AnnisUI)ui;
            URI appURI = UI.getCurrent().getPage().getLocation();
            try {
                String fragment = StringUtils.join((Object[])new String[]{this.query.toCitationFragment(), "&"});
                URI url = new URI(appURI.getScheme(), null, appURI.getHost(), appURI.getPort(), appURI.getPath(), null, fragment);
                shortURL = this.shorten ? annisUI.getUrlShortener().shortenURL(url, annisUI) : url.toASCIIString();
            }
            catch (URISyntaxException e) {
                log.error("Could not generate query share link", (Throwable)e);
                ExceptionDialog.show(e, "Could not generate query share link", UI.getCurrent());
            }
        }
        this.txtCitation.setReadOnly(false);
        this.txtCitation.setValue(shortURL);
        this.txtCitation.setReadOnly(true);
    }

    public void buttonClick(Button.ClickEvent event) {
        UI.getCurrent().removeWindow((Window)this);
    }
}

