/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.query_references;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.transaction.Transactional;
import org.corpus_tools.annis.gui.CommonUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.query_references.UrlShortenerEntry;
import org.corpus_tools.annis.gui.query_references.UrlShortenerRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class UrlShortener {
    @Autowired
    private UrlShortenerRepository repo;

    @Transactional
    public String shortenURL(URI original, CommonUI ui) {
        UUID shortID;
        URI localURL;
        List<UrlShortenerEntry> existingEntry;
        String appContext = ui.getServletContext().getContextPath();
        String path = original.getRawPath();
        if (path.startsWith(appContext)) {
            path = path.substring(appContext.length());
        }
        String localURLRaw = path;
        if (original.getRawQuery() != null) {
            localURLRaw = localURLRaw + "?" + original.getRawQuery();
        }
        if (original.getRawFragment() != null) {
            localURLRaw = localURLRaw + "#" + original.getRawFragment();
        }
        if ((existingEntry = this.repo.findByUrl(localURL = URI.create(localURLRaw))).isEmpty()) {
            UrlShortenerEntry entry = new UrlShortenerEntry();
            entry.setId(UUID.randomUUID());
            entry.setUrl(localURL);
            Optional<OidcUser> user = Helper.getUser(ui);
            if (user.isPresent()) {
                entry.setOwner(Helper.getDisplayName(user.get()));
            } else {
                entry.setOwner("anonymous");
            }
            entry.setCreated(new Date());
            UrlShortenerEntry savedEntry = (UrlShortenerEntry)this.repo.save(entry);
            shortID = savedEntry.getId();
        } else {
            shortID = existingEntry.get(0).getId();
        }
        return UriComponentsBuilder.fromUri((URI)original).replacePath(appContext + "/").replaceQuery("").queryParam("id", new Object[]{shortID.toString()}).build().toUriString();
    }

    @Transactional
    public void migrate(URI url, URI temporary, String userName, UUID uuid, Date creationTime) {
        Optional existing = this.repo.findById(uuid);
        Preconditions.checkState((!existing.isPresent() ? 1 : 0) != 0, (String)"Attempted to migrate UUID {} which already exists in the database.", (Object)uuid);
        UrlShortenerEntry entry = new UrlShortenerEntry();
        entry.setId(uuid);
        entry.setOwner(userName);
        entry.setCreated(creationTime);
        entry.setUrl(url);
        entry.setTemporaryUrl(temporary);
        this.repo.save(entry);
    }

    public Optional<URI> unshorten(UUID id) {
        return this.repo.findById(id).map(e -> {
            if (e.getTemporaryUrl() == null) {
                return e.getUrl();
            }
            return e.getTemporaryUrl();
        });
    }

    public UrlShortenerRepository getRepo() {
        return this.repo;
    }
}

