/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.querybuilder;

import com.vaadin.event.LayoutEvents;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.TextField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.corpus_tools.annis.gui.querybuilder.TigerQueryBuilderCanvas;

public class NodeWindow
extends Panel
implements Button.ClickListener {
    private static final long serialVersionUID = 3343814240482043643L;
    public static final int HEIGHT = 100;
    public static final int WIDTH = 275;
    private static final String[] NODE_OPERATORS = new String[]{"=", "~", "!=", "!~"};
    private final Set<String> annoNames;
    private final TigerQueryBuilderCanvas parent;
    private final Button btEdge;
    private final Button btAdd;
    private final Button btClear;
    private final Button btClose;
    private final Button btMove;
    private final HorizontalLayout toolbar;
    private final List<ConstraintLayout> constraints;
    private boolean prepareEdgeDock;
    private final int id;
    private final VerticalLayout vLayout;

    public NodeWindow(int id, TigerQueryBuilderCanvas parent) {
        this.parent = parent;
        this.id = id;
        this.annoNames = new TreeSet<String>();
        for (String a : parent.getAvailableAnnotationNames()) {
            this.annoNames.add(a.replaceFirst("^[^:]*:", ""));
        }
        this.constraints = new ArrayList<ConstraintLayout>();
        this.setSizeFull();
        this.addStyleName("well");
        this.prepareEdgeDock = false;
        this.vLayout = new VerticalLayout();
        this.setContent((Component)this.vLayout);
        this.vLayout.setWidth("100%");
        this.vLayout.setHeight("-1px");
        this.vLayout.setMargin(false);
        this.vLayout.setSpacing(true);
        this.toolbar = new HorizontalLayout();
        this.toolbar.addStyleName("toolbar");
        this.toolbar.setWidth("100%");
        this.toolbar.setHeight("-1px");
        this.toolbar.setMargin(false);
        this.toolbar.setSpacing(false);
        this.vLayout.addComponent((Component)this.toolbar);
        this.btMove = new Button();
        this.btMove.setWidth("100%");
        this.btMove.setIcon((Resource)FontAwesome.ARROWS);
        this.btMove.setDescription("<strong>Move node</strong><br />Click, hold and move mouse to move the node.");
        this.btMove.addStyleName("small");
        this.btMove.addStyleName("drag-source-enabled");
        this.toolbar.addComponent((Component)this.btMove);
        this.btEdge = new Button("Edge");
        this.btEdge.setIcon((Resource)FontAwesome.EXTERNAL_LINK);
        this.btEdge.addClickListener((Button.ClickListener)this);
        this.btEdge.addStyleName("small");
        this.btEdge.setDescription("<strong>Add Edge</strong><br />To create a new edge between two nodes click this button first. Then define a destination node by clicking its \"Dock\" button.<br>You can cancel the action by clicking this button (\"Cancel\") again.");
        this.toolbar.addComponent((Component)this.btEdge);
        this.btAdd = new Button("Add");
        this.btAdd.setIcon((Resource)FontAwesome.PLUS);
        this.btAdd.addStyleName("small");
        this.btAdd.addClickListener((Button.ClickListener)this);
        this.btAdd.setDescription("<strong>Add Node Condition</strong><br />Every condition will constraint the node described by this window. Most conditions limit the node by defining which annotations and which values of the annotation a node needs to have.");
        this.toolbar.addComponent((Component)this.btAdd);
        this.btClear = new Button("Clear");
        this.btClear.setIcon((Resource)FontAwesome.TRASH_O);
        this.btClear.addStyleName("small");
        this.btClear.addClickListener((Button.ClickListener)this);
        this.btClear.setDescription("<strong>Clear All Node Conditions</strong>");
        this.toolbar.addComponent((Component)this.btClear);
        this.btClose = new Button();
        this.btClose.setIcon((Resource)FontAwesome.TIMES_CIRCLE);
        this.btClose.setDescription("<strong>Close</strong><br />Close this node description window");
        this.btClose.addStyleName("small");
        this.btClose.addClickListener((Button.ClickListener)this);
        this.toolbar.addComponent((Component)this.btClose);
        this.toolbar.setComponentAlignment((Component)this.btMove, Alignment.TOP_LEFT);
        this.toolbar.setExpandRatio((Component)this.btMove, 1.0f);
        this.toolbar.setComponentAlignment((Component)this.btEdge, Alignment.TOP_CENTER);
        this.toolbar.setComponentAlignment((Component)this.btAdd, Alignment.TOP_CENTER);
        this.toolbar.setComponentAlignment((Component)this.btClear, Alignment.TOP_CENTER);
        this.toolbar.setComponentAlignment((Component)this.btClose, Alignment.TOP_RIGHT);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.btEdge) {
            if (this.prepareEdgeDock) {
                this.setPrepareEdgeDock(false);
                this.parent.addEdge(this);
            } else {
                this.parent.prepareAddingEdge(this);
                this.setPrepareEdgeDock(true);
                this.btEdge.setIcon((Resource)new ThemeResource("images/pixel.png"));
                this.btEdge.setCaption("Cancel");
            }
        } else if (event.getButton() == this.btClose) {
            this.parent.deleteNode(this);
        } else if (event.getButton() == this.btAdd) {
            ConstraintLayout c = new ConstraintLayout(this.parent, this.annoNames);
            c.setWidth("100%");
            c.setHeight("-1px");
            this.constraints.add(c);
            this.vLayout.addComponent((Component)c);
            if (this.parent != null) {
                this.parent.updateQuery();
            }
        } else if (event.getButton() == this.btClear) {
            for (ConstraintLayout c : this.constraints) {
                this.vLayout.removeComponent((Component)c);
            }
            this.constraints.clear();
            if (this.parent != null) {
                this.parent.updateQuery();
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NodeWindow other = (NodeWindow)((Object)obj);
        return other.getID() == this.getID();
    }

    public Button getBtMove() {
        return this.btMove;
    }

    public List<ConstraintLayout> getConstraints() {
        return this.constraints;
    }

    public int getID() {
        return this.id;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + this.id;
        return hash;
    }

    public void setPrepareEdgeDock(boolean prepare) {
        this.prepareEdgeDock = prepare;
        this.btClear.setVisible(!prepare);
        this.btClose.setVisible(!prepare);
        this.btAdd.setVisible(!prepare);
        this.btMove.setVisible(!prepare);
        if (prepare) {
            this.btEdge.setCaption("Dock");
            this.btEdge.setIcon((Resource)new ThemeResource("images/pixel.png"));
        } else {
            this.btEdge.setIcon((Resource)FontAwesome.EXTERNAL_LINK);
            this.btEdge.setCaption("Edge");
        }
    }

    public static class SimpleNewItemHandler
    implements AbstractSelect.NewItemHandler {
        private static final long serialVersionUID = 3779354553679599585L;
        private ComboBox comboBox;

        public SimpleNewItemHandler(ComboBox comboBox) {
            this.comboBox = comboBox;
        }

        public void addNewItem(String newItemCaption) {
            if (this.comboBox != null) {
                this.comboBox.addItem((Object)newItemCaption);
                this.comboBox.setValue((Object)newItemCaption);
            }
        }
    }

    public class ConstraintLayout
    extends HorizontalLayout
    implements LayoutEvents.LayoutClickListener,
    Property.ValueChangeListener {
        private static final long serialVersionUID = 7188297587108882576L;
        private final TigerQueryBuilderCanvas parent;
        private final ComboBox cbName;
        private final ComboBox cbOperator;
        private final TextField txtValue;
        private final Button btDelete;

        public ConstraintLayout(TigerQueryBuilderCanvas parent, Set<String> annoNames) {
            this.parent = parent;
            this.setWidth("100%");
            this.cbName = new ComboBox();
            this.cbName.setNewItemsAllowed(true);
            this.cbName.setNewItemHandler((AbstractSelect.NewItemHandler)new SimpleNewItemHandler(this.cbName));
            this.cbName.setImmediate(true);
            this.cbName.setNullSelectionAllowed(true);
            this.cbName.setNullSelectionItemId((Object)"tok");
            this.cbName.addItem((Object)"tok");
            for (String n : annoNames) {
                this.cbName.addItem((Object)n);
            }
            this.cbName.setValue((Object)"tok");
            this.cbName.addValueChangeListener((Property.ValueChangeListener)this);
            this.cbOperator = new ComboBox();
            this.cbOperator.setNewItemsAllowed(false);
            this.cbOperator.setNullSelectionAllowed(false);
            this.cbOperator.setImmediate(true);
            for (String o : NODE_OPERATORS) {
                this.cbOperator.addItem((Object)o);
            }
            this.cbOperator.setValue((Object)NODE_OPERATORS[0]);
            this.cbOperator.addValueChangeListener((Property.ValueChangeListener)this);
            this.txtValue = new TextField();
            this.txtValue.addValueChangeListener((Property.ValueChangeListener)this);
            this.cbOperator.setWidth("4em");
            this.cbName.setWidth("100%");
            this.txtValue.setWidth("100%");
            this.btDelete = new Button("X");
            this.btDelete.addStyleName("link");
            this.btDelete.setDescription("Remove node condition");
            this.btDelete.addClickListener((Button.ClickListener & Serializable)event -> {
                NodeWindow.this.vLayout.removeComponent((Component)this);
                NodeWindow.this.constraints.remove((Object)this);
            });
            this.addComponent((Component)this.cbName);
            this.addComponent((Component)this.cbOperator);
            this.addComponent((Component)this.txtValue);
            this.addComponent((Component)this.btDelete);
            this.setExpandRatio((Component)this.cbName, 0.8f);
            this.setExpandRatio((Component)this.txtValue, 1.0f);
            this.setExpandRatio((Component)this.btDelete, 0.0f);
            this.setComponentAlignment((Component)this.btDelete, Alignment.MIDDLE_RIGHT);
            this.addLayoutClickListener(this);
        }

        public String getName() {
            if (this.cbName.getValue() == null) {
                return "tok";
            }
            return (String)this.cbName.getValue();
        }

        public String getOperator() {
            if (this.cbOperator.getValue() == null) {
                return "";
            }
            return (String)this.cbOperator.getValue();
        }

        public String getValue() {
            if (this.txtValue.getValue() == null) {
                return "";
            }
            return (String)this.txtValue.getValue();
        }

        public void layoutClick(LayoutEvents.LayoutClickEvent event) {
            Component c = event.getClickedComponent();
            if (c != null && c instanceof AbstractField) {
                AbstractField f = (AbstractField)c;
                f.focus();
                if (event.isDoubleClick() && f instanceof AbstractTextField) {
                    ((AbstractTextField)f).selectAll();
                }
            }
        }

        public void valueChange(Property.ValueChangeEvent event) {
            if (this.parent != null) {
                this.parent.updateQuery();
            }
        }
    }
}

