/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.querybuilder;

import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.ComboBox;
import java.util.HashMap;
import java.util.Map;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.querybuilder.QueryBuilderPlugin;

public class QueryBuilderChooser
extends Panel
implements Property.ValueChangeListener {
    private static final long serialVersionUID = 3757379562038691611L;
    private final QueryController controller;
    private final ComboBox cbChooseBuilder;
    private final Map<String, String> short2caption;
    private final Map<String, QueryBuilderPlugin> pluginRegistry;
    private Component lastComponent;
    private final VerticalLayout layout;
    private Component component;

    public QueryBuilderChooser(AnnisUI ui) {
        this.controller = ui.getQueryController();
        this.pluginRegistry = new HashMap<String, QueryBuilderPlugin>();
        this.short2caption = new HashMap<String, String>();
        this.setStyleName("borderless");
        this.layout = new VerticalLayout();
        this.setContent((Component)this.layout);
        this.layout.setSizeFull();
        this.layout.setSpacing(true);
        this.setSizeFull();
        this.cbChooseBuilder = new ComboBox();
        this.cbChooseBuilder.setNewItemsAllowed(false);
        this.cbChooseBuilder.setNullSelectionAllowed(false);
        this.cbChooseBuilder.setInputPrompt("Choose a query builder");
        this.cbChooseBuilder.setWidth("200px");
        for (QueryBuilderPlugin<Component> b : ui.getQueryBuilderPlugins()) {
            this.short2caption.put(b.getShortName(), b.getCaption());
            this.pluginRegistry.put(b.getCaption(), b);
            this.cbChooseBuilder.addItem((Object)b.getCaption());
        }
        this.cbChooseBuilder.addValueChangeListener((Property.ValueChangeListener)this);
        this.layout.addComponent((Component)this.cbChooseBuilder);
        this.layout.setExpandRatio((Component)this.cbChooseBuilder, 0.0f);
        if (ui.getInstanceConfig().getDefaultQueryBuilder() != null) {
            this.cbChooseBuilder.setValue((Object)this.short2caption.get(ui.getInstanceConfig().getDefaultQueryBuilder()));
        }
    }

    public void attach() {
        super.attach();
        IDGenerator.assignIDForFields((HasComponents)this, new Component[]{this.cbChooseBuilder});
    }

    public Component getQueryBuilder() {
        return this.component;
    }

    public void valueChange(Property.ValueChangeEvent event) {
        QueryBuilderPlugin plugin = this.pluginRegistry.get(event.getProperty().getValue());
        if (plugin == null) {
            Notification.show((String)"Invalid selection (plugin not found)", (Notification.Type)Notification.Type.WARNING_MESSAGE);
        } else {
            this.component = plugin.createComponent(this.controller);
            if (this.lastComponent != null) {
                this.layout.removeComponent(this.lastComponent);
            }
            this.layout.addComponent(this.component);
            this.layout.setExpandRatio(this.component, 1.0f);
            this.lastComponent = this.component;
        }
    }
}

