/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.querybuilder;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.querybuilder.QueryBuilderPlugin;
import org.corpus_tools.annis.gui.querybuilder.TigerQueryBuilderCanvas;
import org.springframework.stereotype.Component;

@Component
public class TigerQueryBuilderPlugin
implements QueryBuilderPlugin<com.vaadin.ui.Component> {
    private static final long serialVersionUID = 4425904918754192695L;

    @Override
    public TigerQueryBuilder createComponent(QueryController controller) {
        return new TigerQueryBuilder(controller);
    }

    @Override
    public String getCaption() {
        return "General (TigerSearch like)";
    }

    @Override
    public String getShortName() {
        return "tigersearch";
    }

    public static class TigerQueryBuilder
    extends Panel
    implements Button.ClickListener {
        private static final long serialVersionUID = 2006446978509167314L;
        private Button btAddNode;
        private Button btClearAll;
        private TigerQueryBuilderCanvas queryBuilder;

        public TigerQueryBuilder(QueryController controller) {
            this.setStyleName("borderless");
            VerticalLayout layout = new VerticalLayout();
            this.setContent((com.vaadin.ui.Component)layout);
            layout.setSizeFull();
            this.setSizeFull();
            layout.setMargin(false);
            HorizontalLayout toolbar = new HorizontalLayout();
            this.btAddNode = new Button("Add node", (Button.ClickListener)this);
            this.btAddNode.setStyleName("small");
            this.btAddNode.setDescription("<strong>Create Node</strong><br />Click here to add a new node specification window.<br />To move the node, click and hold left mouse button, then move the mouse.");
            toolbar.addComponent((com.vaadin.ui.Component)this.btAddNode);
            this.btClearAll = new Button("Clear all", (Button.ClickListener)this);
            this.btClearAll.setStyleName("small");
            this.btClearAll.setDescription("<strong>Clear all</strong><br />Click here to delete all node specification windows and reset the query builder.");
            toolbar.addComponent((com.vaadin.ui.Component)this.btClearAll);
            Button btHelp = new Button();
            btHelp.setIcon((Resource)FontAwesome.QUESTION);
            btHelp.addStyleName("borderless");
            btHelp.addStyleName("helpbutton");
            btHelp.addClickListener((Button.ClickListener)new HelpClickListener());
            toolbar.addComponent((com.vaadin.ui.Component)btHelp);
            toolbar.setWidth("-1px");
            toolbar.setHeight("-1px");
            layout.addComponent((com.vaadin.ui.Component)toolbar);
            this.queryBuilder = new TigerQueryBuilderCanvas(controller);
            layout.addComponent((com.vaadin.ui.Component)this.queryBuilder);
            layout.setExpandRatio((com.vaadin.ui.Component)this.queryBuilder, 1.0f);
        }

        public void buttonClick(Button.ClickEvent event) {
            if (event.getButton() == this.btAddNode) {
                this.queryBuilder.addNode();
            } else if (event.getButton() == this.btClearAll) {
                this.queryBuilder.clearAll();
            }
        }

        private static class HelpClickListener
        implements Button.ClickListener {
            private static final long serialVersionUID = 8577824029505072112L;

            public void buttonClick(Button.ClickEvent event) {
                String message = "Click \u201cAdd node\u201d to add a search term. You can move nodes freely by dragging\nthem for your convenience. Click \u201cadd\u201d to insert some annotation criteria for the\nsearch term. The field on the left of the node annotation will show annotation\nnames from the selected corpora. The operator in the middle can be set to equals\n\u2018=\u2019, does not equal \u2018!=\u2019 and similarly for pattern searches to \u2018~\u2019 (regular\nexpression match) and \u2018!~\u2019 (does not equal regular expression). The field on the\nright gives annotation values or regular expressions.<br />Adding multiple nodes makes it possible to use the \u2018Edge\u2019 button. Click on \u2018Edge\u2019\nin one node and then on \u2018Dock\u2019 in another to connect search terms. Choose an\noperator from the list on the line connecting the edges to determine e.g. if one\nnode should occur before the other, etc. For details on the meaning and usage of\neach operator, see the tutorial tab above.";
                Notification notify = new Notification("Help for query builder<br/><br/>(Click here to close)", Notification.Type.HUMANIZED_MESSAGE);
                notify.setHtmlContentAllowed(true);
                notify.setDescription(message);
                notify.setDelayMsec(-1);
                notify.show(UI.getCurrent().getPage());
            }
        }
    }
}

