/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.resultfetch;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.JSON;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.SearchApi;
import org.corpus_tools.annis.api.model.BadRequestError;
import org.corpus_tools.annis.api.model.BadRequestErrorAQLSyntaxError;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.api.model.SubgraphWithContext;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.components.codemirror.AqlCodeEditorState;
import org.corpus_tools.annis.gui.graphml.DocumentGraphMapper;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.annis.gui.objects.MatchGroup;
import org.corpus_tools.annis.gui.objects.PagedResultQuery;
import org.corpus_tools.annis.gui.paging.PagingComponent;
import org.corpus_tools.annis.gui.resultview.ResultViewPanel;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFetchJob
implements Runnable {
    protected static final Logger log = LoggerFactory.getLogger(ResultFetchJob.class);
    protected ResultViewPanel resultPanel;
    protected PagedResultQuery query;
    protected AnnisUI ui;

    public ResultFetchJob(PagedResultQuery query, ResultViewPanel resultPanel, AnnisUI ui) {
        this.resultPanel = resultPanel;
        this.query = query;
        this.ui = ui;
    }

    @Override
    public void run() {
        SearchApi search = new SearchApi(Helper.getClient(this.ui));
        CorporaApi corpora = new CorporaApi(Helper.getClient(this.ui));
        MatchGroup result = new MatchGroup();
        try {
            if (Thread.interrupted()) {
                return;
            }
            this.ui.access(() -> this.resultPanel.showMatchSearchInProgress(this.query.getSegmentation()));
            FindQuery q = new FindQuery();
            q.setCorpora(new LinkedList<String>(this.query.getCorpora()));
            q.setQuery(this.query.getQuery());
            q.setOffset((int)this.query.getOffset());
            q.setLimit(this.query.getLimit());
            q.setQueryLanguage(this.query.getApiQueryLanguage());
            File findResult = search.find(q);
            try (Stream<String> findResultLines = Files.lines(findResult.toPath(), StandardCharsets.UTF_8);){
                findResultLines.forEachOrdered(line -> {
                    Match m = Match.parseFromString(line);
                    result.getMatches().add(m);
                });
            }
            if (result.getMatches().isEmpty()) {
                if (Thread.interrupted()) {
                    return;
                }
                this.ui.access(() -> this.resultPanel.showNoResult());
            } else {
                if (Thread.interrupted()) {
                    return;
                }
                this.ui.access(() -> this.resultPanel.showSubgraphSearchInProgress(this.query, 0.0f));
                ArrayBlockingQueue<SaltProject> queue = new ArrayBlockingQueue<SaltProject>(result.getMatches().size());
                int current = 0;
                ArrayList<Match> matchList = new ArrayList<Match>(result.getMatches());
                for (Match m : matchList) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    SubgraphWithContext arg = new SubgraphWithContext();
                    arg.setLeft(this.query.getLeftContext());
                    arg.setRight(this.query.getRightContext());
                    arg.setSegmentation(this.query.getSegmentation());
                    arg.setNodeIds(m.getSaltIDs().stream().collect(Collectors.toList()));
                    this.createSaltFromMatch(m, arg, current, corpora, queue);
                    if (current == 0) {
                        this.ui.access(() -> this.resultPanel.setQueryResultQueue(queue, this.query, matchList));
                    }
                    if (Thread.interrupted()) {
                        return;
                    }
                    ++current;
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ApiException ex) {
            this.ui.access(() -> {
                if (this.resultPanel != null && this.resultPanel.getPaging() != null) {
                    PagingComponent paging = this.resultPanel.getPaging();
                    if (ex.getCode() == 400) {
                        JSON json = new JSON();
                        BadRequestError error = (BadRequestError)json.deserialize(ex.getResponseBody(), (Type)((Object)BadRequestError.class));
                        String errMsg = "";
                        if (error.getAqLSyntaxError() != null) {
                            errMsg = new AqlCodeEditorState.ParseError((BadRequestErrorAQLSyntaxError)error.getAqLSyntaxError()).message;
                        }
                        if (error.getAqLSemanticError() != null) {
                            errMsg = new AqlCodeEditorState.ParseError((BadRequestErrorAQLSyntaxError)error.getAqLSemanticError()).message;
                        }
                        paging.setInfo("parsing error: " + errMsg);
                    } else if (ex.getCode() == 504) {
                        paging.setInfo("Timeout: query execution took too long");
                    } else if (ex.getCode() == 403) {
                        paging.setInfo("Not authorized to query this corpus.");
                    } else {
                        ExceptionDialog.show(ex, this.ui);
                    }
                    this.resultPanel.showFinishedSubgraphSearch();
                }
            });
        }
        catch (IOException ex) {
            this.ui.access(() -> ExceptionDialog.show(ex, this.ui));
        }
    }

    private void createSaltFromMatch(Match m, SubgraphWithContext arg, int currentMatchNumber, CorporaApi api, BlockingQueue<SaltProject> queue) throws InterruptedException, ApiException {
        List<String> corpusPath = Helper.getCorpusPath(m.getSaltIDs().get(0));
        if (!corpusPath.isEmpty()) {
            File graphML = api.subgraphForNodes(corpusPath.get(0), arg);
            try {
                SaltProject p = SaltFactory.createSaltProject();
                SCorpusGraph cg = p.createCorpusGraph();
                URI docURI = URI.createURI((String)("salt:/" + Joiner.on((char)'/').join(corpusPath)));
                SDocument doc = cg.createDocument(docURI);
                SDocumentGraph docGraph = DocumentGraphMapper.map(graphML);
                queue.put(p);
                doc.setDocumentGraph(docGraph);
                Helper.addMatchToDocumentGraph(m, doc.getDocumentGraph());
                log.debug("added match {} to queue", (Object)(currentMatchNumber + 1));
            }
            catch (IOException | XMLStreamException ex) {
                log.error("Could not map GraphML to Salt", (Throwable)ex);
                this.ui.access(() -> ExceptionDialog.show(ex, "Could not map GraphML to Salt", this.ui));
            }
        }
    }
}

