/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.resultview;

import com.vaadin.server.AbstractClientConnector;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.components.OnLoadCallbackExtension;
import org.corpus_tools.annis.gui.controlpanel.QueryPanel;
import org.corpus_tools.annis.gui.objects.DisplayedResultQuery;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.annis.gui.objects.PagedResultQuery;
import org.corpus_tools.annis.gui.paging.PagingComponent;
import org.corpus_tools.annis.gui.resultview.ResolverProviderImpl;
import org.corpus_tools.annis.gui.resultview.SingleCorpusResultPanel;
import org.corpus_tools.annis.gui.resultview.SingleResolverRequest;
import org.corpus_tools.annis.gui.resultview.SingleResultPanel;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultViewPanel
extends VerticalLayout
implements OnLoadCallbackExtension.Callback {
    private static final long serialVersionUID = -5353763293248666891L;
    private static final Logger log = LoggerFactory.getLogger(ResultViewPanel.class);
    private static final String NULL_SEGMENTATION_VALUE = "tokens (default)";
    private final Map<HashSet<SingleResolverRequest>, LinkedHashSet<VisualizerRule>> cacheResolver;
    private final PagingComponent paging;
    private final MenuBar.MenuItem miTokAnnos;
    private final MenuBar.MenuItem miSegmentation;
    private final TreeMap<String, Boolean> tokenAnnoVisible;
    private final QueryController controller;
    private final Set<String> segmentationLayerSet = Collections.synchronizedSet(new TreeSet());
    private final Set<String> tokenAnnotationLevelSet = Collections.synchronizedSet(new TreeSet());
    private final CssLayout resultLayout;
    private final List<AbstractComponent> resultPanelList;
    private String segmentationName;
    private int currentResults;
    private int numberOfResults;
    private ArrayList<Match> allMatches;
    private transient BlockingQueue<SaltProject> projectQueue;
    private PagedResultQuery currentQuery;
    private final DisplayedResultQuery initialQuery;
    private final AnnisUI sui;

    public ResultViewPanel(AnnisUI ui, DisplayedResultQuery initialQuery) {
        this.sui = ui;
        this.tokenAnnoVisible = new TreeMap();
        this.controller = ui.getQueryController();
        this.initialQuery = initialQuery;
        this.cacheResolver = Collections.synchronizedMap(new HashMap());
        this.resultPanelList = Collections.synchronizedList(new LinkedList());
        this.resultLayout = new CssLayout();
        this.resultLayout.addStyleName("result-view-css");
        Panel resultPanel = new Panel((Component)this.resultLayout);
        resultPanel.setSizeFull();
        resultPanel.addStyleName("borderless");
        resultPanel.addStyleName("result-view-panel");
        this.setSizeFull();
        this.setMargin(false);
        MenuBar mbResult = new MenuBar();
        mbResult.setWidth("100%");
        mbResult.addStyleName("menu-hover");
        this.addComponent((Component)mbResult);
        this.miSegmentation = mbResult.addItem("Base text", null);
        this.miTokAnnos = mbResult.addItem("Token Annotations", null);
        this.addComponent((Component)resultPanel);
        this.setExpandRatio((Component)mbResult, 0.0f);
        this.setExpandRatio((Component)resultPanel, 1.0f);
        this.paging = new PagingComponent();
        this.addComponent((Component)this.paging, 1);
        this.setComponentAlignment((Component)this.paging, Alignment.TOP_CENTER);
        this.setExpandRatio((Component)this.paging, 0.0f);
    }

    private void addQueryResult(PagedResultQuery q, List<SaltProject> subgraphList) {
        if (q == null) {
            return;
        }
        List<Object> newPanels = new LinkedList();
        try {
            if (subgraphList == null || subgraphList.isEmpty()) {
                Notification.show((String)"Could not get subgraphs", (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
            } else {
                for (SaltProject p : subgraphList) {
                    this.updateVariables(p);
                    newPanels = this.createPanels(p, this.currentResults, q.getOffset() + (long)this.currentResults);
                    this.currentResults += newPanels.size();
                    String strResults = this.numberOfResults > 1 ? "results" : "result";
                    this.sui.getSearchView().getControlPanel().getQueryPanel().setStatus(this.sui.getSearchView().getControlPanel().getQueryPanel().getLastPublicStatus(), " (showing " + this.currentResults + "/" + this.numberOfResults + " " + strResults + ")");
                    if (this.currentResults == this.numberOfResults) {
                        this.resetQueryResultQueue();
                    }
                    for (AbstractComponent abstractComponent : newPanels) {
                        this.resultPanelList.add(abstractComponent);
                        this.resultLayout.addComponent((Component)abstractComponent);
                        if (!(abstractComponent instanceof SingleResultPanel)) continue;
                        ((SingleResultPanel)abstractComponent).setSegmentationLayer((String)this.sui.getQueryState().getVisibleBaseText().getValue());
                    }
                }
                if (this.currentResults == this.numberOfResults) {
                    this.showFinishedSubgraphSearch();
                    if (!this.initialQuery.getSelectedMatches().isEmpty()) {
                        JavaScript.eval((String)"$(\".v-panel-content-result-view-panel\").animate({scrollTop: $(\".selected-match\").offset().top - $(\".result-view-panel\").offset().top}, 1000);");
                    }
                }
                if (this.projectQueue != null && !newPanels.isEmpty() && this.currentResults < this.numberOfResults) {
                    log.debug("adding callback for result " + this.currentResults);
                    OnLoadCallbackExtension ext = new OnLoadCallbackExtension(this, 250);
                    ext.extend((AbstractClientConnector)newPanels.get(newPanels.size() - 1));
                }
            }
        }
        catch (Throwable ex) {
            log.error(null, ex);
        }
    }

    public void attach() {
        super.attach();
        IDGenerator.assignIDForFields((HasComponents)this, new Component[]{this.resultLayout});
        IDGenerator.assignIDForEachField((HasComponents)this.paging);
    }

    private List<AbstractComponent> createPanels(SaltProject p, int localMatchIndex, long globalOffset) {
        LinkedList<AbstractComponent> resultPanels = new LinkedList<AbstractComponent>();
        int i = 0;
        for (SCorpusGraph corpusGraph : p.getCorpusGraphs()) {
            CssLayout panel;
            Match m = new Match();
            if (this.allMatches != null && localMatchIndex >= 0 && localMatchIndex < this.allMatches.size()) {
                m = this.allMatches.get(localMatchIndex);
            }
            if (corpusGraph.getDocuments().isEmpty()) {
                LinkedHashSet<SCorpus> matchedCorpora = new LinkedHashSet<SCorpus>();
                for (String id : m.getSaltIDs()) {
                    SNode n = (SNode)corpusGraph.getNode(id);
                    if (!(n instanceof SCorpus)) continue;
                    matchedCorpora.add((SCorpus)n);
                }
                panel = new SingleCorpusResultPanel(matchedCorpora, m, (long)i + globalOffset, this.sui, this.initialQuery);
            } else {
                SDocument doc = (SDocument)corpusGraph.getDocuments().get(0);
                panel = new SingleResultPanel(doc, m, (long)i + globalOffset, new ResolverProviderImpl(this.cacheResolver), this.sui, this.getVisibleTokenAnnos(), this.segmentationName, this.controller, this.initialQuery);
            }
            ++i;
            panel.setWidth("100%");
            panel.setHeight("-1px");
            resultPanels.add((AbstractComponent)panel);
        }
        return resultPanels;
    }

    public PagingComponent getPaging() {
        return this.paging;
    }

    private Set<String> getSegmentationNames(SaltProject p) {
        TreeSet<String> result = new TreeSet<String>();
        for (SCorpusGraph corpusGraphs : p.getCorpusGraphs()) {
            for (SDocument doc : corpusGraphs.getDocuments()) {
                List orderRoots;
                SDocumentGraph g = doc.getDocumentGraph();
                if (g == null || (orderRoots = g.getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SORDER_RELATION})) == null) continue;
                for (SNode n : orderRoots) {
                    for (SRelation rel : n.getOutRelations()) {
                        if (!(rel instanceof SOrderRelation)) continue;
                        result.add(rel.getType());
                    }
                }
            }
        }
        return result;
    }

    public SortedSet<String> getVisibleTokenAnnos() {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<String, Boolean> e : this.tokenAnnoVisible.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            result.add(e.getKey());
        }
        return result;
    }

    @Override
    public boolean onCompononentLoaded(AbstractClientConnector source) {
        if (source != null && this.projectQueue != null && this.currentQuery != null) {
            SaltProject p;
            LinkedList<SaltProject> subgraphs = new LinkedList<SaltProject>();
            while ((p = (SaltProject)this.projectQueue.poll()) != null) {
                log.debug("Polling queue for SaltProject graph");
                subgraphs.add(p);
            }
            if (subgraphs.isEmpty()) {
                log.debug("no SaltProject graph in queue");
                return false;
            }
            log.debug("taken {} SaltProject graph(s) from queue", (Object)subgraphs.size());
            this.addQueryResult(this.currentQuery, subgraphs);
            return true;
        }
        return true;
    }

    private void resetQueryResultQueue() {
        this.projectQueue = null;
        this.currentQuery = null;
        this.currentResults = 0;
        this.numberOfResults = 0;
    }

    public void setCount(long count) {
        this.paging.setCount(count, false);
        this.paging.setStartNumber(this.initialQuery.getOffset());
    }

    public void setQueryResultQueue(BlockingQueue<SaltProject> queue, PagedResultQuery q, ArrayList<Match> allMatches) {
        this.projectQueue = queue;
        this.currentQuery = q;
        this.numberOfResults = allMatches.size();
        this.allMatches = allMatches;
        this.paging.setPageSize(q.getLimit(), false);
        this.paging.setInfo(q.getQuery());
        this.resultLayout.removeAllComponents();
        this.resultPanelList.clear();
        SaltProject first = (SaltProject)queue.poll();
        if (first == null) {
            throw new IllegalStateException("There must be already an element in the queue");
        }
        this.addQueryResult(q, Arrays.asList(first));
    }

    private void setSegmentationLayer(String segmentationLayer) {
        for (Component component : this.resultPanelList) {
            if (!(component instanceof SingleResultPanel)) continue;
            ((SingleResultPanel)component).setSegmentationLayer(segmentationLayer);
        }
    }

    private void setVisibleTokenAnnosVisible(SortedSet<String> annos) {
        for (Component component : this.resultPanelList) {
            if (!(component instanceof SingleResultPanel)) continue;
            ((SingleResultPanel)component).setVisibleTokenAnnosVisible(annos);
        }
    }

    public void showFinishedSubgraphSearch() {
        if (this.sui.getSearchView().getControlPanel().getQueryPanel().getPiCount() != null && this.sui.getSearchView().getControlPanel().getQueryPanel().getPiCount().isVisible()) {
            this.sui.getSearchView().getControlPanel().getQueryPanel().getPiCount().setVisible(false);
            this.sui.getSearchView().getControlPanel().getQueryPanel().getPiCount().setEnabled(false);
        }
        QueryPanel qp = this.sui.getSearchView().getControlPanel().getQueryPanel();
        qp.setStatus(qp.getLastPublicStatus());
    }

    public void showMatchSearchInProgress(String segmentationName) {
        this.resultLayout.removeAllComponents();
        this.segmentationName = segmentationName;
    }

    public void showNoResult() {
        this.resultLayout.removeAllComponents();
        this.currentResults = 0;
        Label lblNoResult = new Label("No matches found.");
        lblNoResult.setWidth("100%");
        lblNoResult.addStyleName("result-view-no-content");
        this.resultLayout.addComponent((Component)lblNoResult);
        this.showFinishedSubgraphSearch();
    }

    public void showSubgraphSearchInProgress(PagedResultQuery q, float percent) {
        if (percent == 0.0f) {
            this.resultLayout.removeAllComponents();
            this.currentResults = 0;
        }
    }

    private void updateSegmentationLayer(Set<String> segLayers) {
        this.miSegmentation.removeChildren();
        segLayers.add("");
        for (String s : segLayers) {
            if (s == null) continue;
            MenuBar.MenuItem miSingleSegLayer = "".equals(s) ? this.miSegmentation.addItem(NULL_SEGMENTATION_VALUE, (MenuBar.Command)new MenuBaseTextCommand()) : this.miSegmentation.addItem(s, (MenuBar.Command)new MenuBaseTextCommand());
            miSingleSegLayer.setCheckable(true);
            String selectedSegmentationLayer = (String)this.sui.getQueryState().getVisibleBaseText().getValue();
            if (selectedSegmentationLayer == null && "".equals(s) || s.equals(selectedSegmentationLayer)) {
                miSingleSegLayer.setChecked(true);
                continue;
            }
            miSingleSegLayer.setChecked(false);
        }
    }

    private void updateVariables(SaltProject p) {
        this.segmentationLayerSet.addAll(this.getSegmentationNames(p));
        this.tokenAnnotationLevelSet.addAll(Helper.getTokenAnnotationLevelSet(p));
        HashSet<String> hiddenTokenAnnos = null;
        Set<String> corpusNames = Helper.getToplevelCorpusNames(p);
        for (String corpusName : corpusNames) {
            CorpusConfiguration corpusConfig = Helper.getCorpusConfig(corpusName, UI.getCurrent());
            if (corpusConfig == null || corpusConfig.getView() == null || corpusConfig.getView().getHiddenAnnos() == null) continue;
            hiddenTokenAnnos = new HashSet<String>(corpusConfig.getView().getHiddenAnnos());
        }
        if (hiddenTokenAnnos != null) {
            for (String tokenLevel : hiddenTokenAnnos) {
                if (!this.tokenAnnotationLevelSet.contains(tokenLevel)) continue;
                this.tokenAnnotationLevelSet.remove(tokenLevel);
            }
        }
        this.updateSegmentationLayer(this.segmentationLayerSet);
        this.updateVisibleToken(this.tokenAnnotationLevelSet);
    }

    public void updateVisibleToken(Set<String> tokenAnnotationLevelSet) {
        if (tokenAnnotationLevelSet == null || tokenAnnotationLevelSet.isEmpty()) {
            this.miTokAnnos.setVisible(false);
        } else {
            this.miTokAnnos.setVisible(true);
        }
        if (tokenAnnotationLevelSet != null) {
            for (String s : tokenAnnotationLevelSet) {
                if (this.tokenAnnoVisible.containsKey(s)) continue;
                this.tokenAnnoVisible.put(s, Boolean.TRUE);
            }
        }
        this.miTokAnnos.removeChildren();
        if (tokenAnnotationLevelSet != null) {
            for (String a : tokenAnnotationLevelSet) {
                MenuBar.MenuItem miSingleTokAnno = this.miTokAnnos.addItem(a.replaceFirst("::", ":"), (MenuBar.Command & Serializable)selectedItem -> {
                    if (selectedItem.isChecked()) {
                        this.tokenAnnoVisible.put(a, Boolean.TRUE);
                    } else {
                        this.tokenAnnoVisible.put(a, Boolean.FALSE);
                    }
                    this.setVisibleTokenAnnosVisible(this.getVisibleTokenAnnos());
                });
                miSingleTokAnno.setCheckable(true);
                miSingleTokAnno.setChecked(this.tokenAnnoVisible.get(a).booleanValue());
            }
        }
    }

    private class MenuBaseTextCommand
    implements MenuBar.Command {
        private static final long serialVersionUID = -2796749478902349646L;

        private MenuBaseTextCommand() {
        }

        public void menuSelected(MenuBar.MenuItem selectedItem) {
            String oldSegmentationLayer = (String)ResultViewPanel.this.sui.getQueryState().getVisibleBaseText().getValue();
            String newSegmentationLayer = selectedItem.getText();
            if (ResultViewPanel.NULL_SEGMENTATION_VALUE.equals(newSegmentationLayer)) {
                newSegmentationLayer = null;
            }
            Iterator iterator = ResultViewPanel.this.miSegmentation.getChildren().iterator();
            while (iterator.hasNext()) {
                MenuBar.MenuItem mi;
                mi.setChecked((mi = (MenuBar.MenuItem)iterator.next()) == selectedItem);
            }
            if (oldSegmentationLayer != null) {
                if (!oldSegmentationLayer.equals(newSegmentationLayer)) {
                    ResultViewPanel.this.setSegmentationLayer(newSegmentationLayer);
                }
            } else if (newSegmentationLayer != null) {
                ResultViewPanel.this.setSegmentationLayer(newSegmentationLayer);
            }
            ResultViewPanel.this.sui.getQueryState().getVisibleBaseText().setValue((Object)newSegmentationLayer);
            ResultViewPanel.this.sui.getSearchView().updateFragment(ResultViewPanel.this.sui.getQueryController().getSearchQuery());
        }
    }
}

