/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.resultview;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.MetaDataPanel;
import org.corpus_tools.annis.gui.objects.DisplayedResultQuery;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.salt.common.SCorpus;

public class SingleCorpusResultPanel
extends CssLayout {
    private static final long serialVersionUID = 2L;
    private static final Resource ICON_RESOURCE = FontAwesome.INFO_CIRCLE;
    private Collection<SCorpus> result;
    private final HorizontalLayout infoBar;

    public SingleCorpusResultPanel(Collection<SCorpus> result, Match match, long resultNumber, AnnisUI ui, DisplayedResultQuery query) {
        this.result = result == null ? new LinkedList() : result;
        this.setWidth("100%");
        this.setHeight("-1px");
        if (query != null && query.getSelectedMatches().contains(resultNumber)) {
            this.addStyleName("selected-match");
        }
        this.infoBar = new HorizontalLayout();
        this.infoBar.addStyleName("info-bar");
        this.infoBar.addStyleName("no-document-info-bar");
        this.infoBar.setWidth("100%");
        this.infoBar.setHeight("-1px");
        Label lblNumber = new Label("" + (resultNumber + 1L));
        this.infoBar.addComponent((Component)lblNumber);
        lblNumber.setSizeUndefined();
        VerticalLayout corpusPaths = new VerticalLayout();
        this.infoBar.addComponent((Component)corpusPaths);
        this.infoBar.setExpandRatio((Component)corpusPaths, 1.0f);
        for (SCorpus c : this.result) {
            List<String> path = Helper.getCorpusPath(c.getPath().toString());
            HorizontalLayout corpusInfoLayout = new HorizontalLayout();
            corpusPaths.addComponent((Component)corpusInfoLayout);
            StringBuilder sb = new StringBuilder("Path: ");
            sb.append(StringUtils.join(path, (String)" > "));
            Button btInfo = new Button();
            btInfo.setStyleName("borderless");
            btInfo.setIcon(ICON_RESOURCE);
            btInfo.setDescription("Show metadata");
            btInfo.addClickListener((Button.ClickListener & Serializable)event -> {
                if (event.getButton() == btInfo && result != null) {
                    Window infoWindow = new Window("Info for " + c.getId());
                    infoWindow.setModal(false);
                    MetaDataPanel meta = new MetaDataPanel((String)path.get(0), Optional.of(path.get(path.size() - 1)));
                    infoWindow.setContent((Component)meta);
                    infoWindow.setWidth("400px");
                    infoWindow.setHeight("400px");
                    UI.getCurrent().addWindow(infoWindow);
                }
            });
            corpusInfoLayout.addComponent((Component)btInfo);
            Label lblPath = new Label(sb.toString());
            lblPath.addStyleName("path-label");
            lblPath.setWidth("100%");
            lblPath.setHeight("-1px");
            corpusInfoLayout.addComponent((Component)lblPath);
        }
        this.infoBar.setSpacing(false);
        this.addComponent((Component)this.infoBar);
        Label lblEmpty = new Label("Result matches only (sub-) corpora and their metadata. You might want to extend your query to include a token search. <br/> An example would be: <br/> <code>tok @* my_meta_attribute=\"somevalue\"</code>");
        lblEmpty.setContentMode(ContentMode.HTML);
        lblEmpty.addStyleName("empty_token_hint");
        this.addComponent((Component)lblEmpty);
    }

    public void attach() {
        super.attach();
        IDGenerator.assignIDForFields((HasComponents)this, new Component[]{this.infoBar});
    }
}

