/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.resultview;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.MetaDataPanel;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.objects.DisplayedResultQuery;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.annis.gui.objects.PagedResultQuery;
import org.corpus_tools.annis.gui.query_references.ShareSingleMatchGenerator;
import org.corpus_tools.annis.gui.resultview.ResolverProvider;
import org.corpus_tools.annis.gui.resultview.VisualizerContextChanger;
import org.corpus_tools.annis.gui.resultview.VisualizerPanel;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleResultPanel
extends CssLayout
implements Button.ClickListener,
VisualizerContextChanger {
    private static final long serialVersionUID = 2L;
    private static final String INITIAL_OPEN = "initial_open";
    private static final Resource ICON_RESOURCE = FontAwesome.INFO_CIRCLE;
    private static final Logger log = LoggerFactory.getLogger(SingleResultPanel.class);
    private SDocument result;
    private Map<String, String> markedExactMap;
    private final AnnisUI ui;
    private List<VisualizerPanel> visualizers;
    private List<VisualizerRule> resolverEntries;
    private final Button btInfo;
    private final Button btLink;
    private final List<String> path;
    private String segmentationName;
    private final HorizontalLayout infoBar;
    private final QueryController queryController;
    private final long resultNumber;
    private final ResolverProvider resolverProvider;
    private final Set<String> visibleTokenAnnos;
    private ProgressBar reloadVisualizer;
    private final ComboBox lftCtxCombo;
    private final ComboBox rghtCtxCombo;
    private final Map<Integer, Boolean> visualizerState;
    private PagedResultQuery query;
    private final Match match;

    public SingleResultPanel(SDocument result, Match match, long resultNumber, ResolverProvider resolverProvider, AnnisUI ui, Set<String> visibleTokenAnnos, String segmentationName, QueryController controller, DisplayedResultQuery query) {
        this.ui = ui;
        this.result = result;
        this.segmentationName = segmentationName;
        this.queryController = controller;
        this.resultNumber = resultNumber;
        this.resolverProvider = resolverProvider;
        this.visibleTokenAnnos = visibleTokenAnnos;
        this.query = query;
        this.match = match;
        this.calculateHelperVariables();
        this.setWidth("100%");
        this.setHeight("-1px");
        if (query != null && query.getSelectedMatches().contains(resultNumber)) {
            this.addStyleName("selected-match");
        }
        this.infoBar = new HorizontalLayout();
        this.infoBar.addStyleName("info-bar");
        this.infoBar.setWidth("100%");
        this.infoBar.setHeight("-1px");
        Label lblNumber = new Label("" + (resultNumber + 1L));
        this.infoBar.addComponent((Component)lblNumber);
        lblNumber.setSizeUndefined();
        this.btLink = new Button();
        this.btLink.setStyleName("borderless");
        this.btLink.setIcon((Resource)VaadinIcons.CONNECT);
        this.btLink.setDescription("Share match reference");
        this.btLink.setDisableOnClick(true);
        this.btLink.addClickListener((Button.ClickListener & Serializable)event -> this.showShareSingleMatchGenerator());
        this.infoBar.addComponent((Component)this.btLink);
        this.btInfo = new Button();
        this.btInfo.setStyleName("borderless");
        this.btInfo.setIcon(ICON_RESOURCE);
        this.btInfo.setDescription("Show metadata");
        this.btInfo.addClickListener((Button.ClickListener)this);
        this.infoBar.addComponent((Component)this.btInfo);
        this.path = Helper.getCorpusPath(result.getGraph(), result);
        Collections.reverse(this.path);
        StringBuilder sb = new StringBuilder("Path: ");
        sb.append(StringUtils.join(this.path, (String)" > "));
        Label lblPath = new Label(sb.toString());
        lblPath.addStyleName("path-label");
        lblPath.setWidth("100%");
        lblPath.setHeight("-1px");
        this.infoBar.addComponent((Component)lblPath);
        this.infoBar.setExpandRatio((Component)lblPath, 1.0f);
        this.infoBar.setSpacing(false);
        this.visualizerState = new HashMap<Integer, Boolean>();
        this.lftCtxCombo = new ComboBox();
        this.rghtCtxCombo = new ComboBox();
        this.lftCtxCombo.setWidth(50.0f, Sizeable.Unit.PIXELS);
        this.rghtCtxCombo.setWidth(50.0f, Sizeable.Unit.PIXELS);
        this.lftCtxCombo.setNullSelectionAllowed(false);
        this.rghtCtxCombo.setNullSelectionAllowed(false);
        this.lftCtxCombo.addStyleName("small");
        this.rghtCtxCombo.addStyleName("small");
        IndexedContainer lftCtxContainer = new IndexedContainer();
        IndexedContainer rghtCtxContainer = new IndexedContainer();
        lftCtxContainer.addContainerProperty((Object)"number", Integer.class, (Object)0);
        rghtCtxContainer.addContainerProperty((Object)"number", Integer.class, (Object)0);
        for (int i = 0; i < 30; i += 5) {
            lftCtxContainer.addItem((Object)i).getItemProperty((Object)"number").setValue((Object)i);
            rghtCtxContainer.addItem((Object)i).getItemProperty((Object)"number").setValue((Object)i);
        }
        int lftContextIdx = query == null ? 0 : query.getLeftContext();
        lftCtxContainer.addItem((Object)lftContextIdx);
        lftCtxContainer.sort(new Object[]{"number"}, new boolean[]{true});
        int rghtCtxIdx = query == null ? 0 : query.getRightContext();
        rghtCtxContainer.addItem((Object)rghtCtxIdx);
        rghtCtxContainer.sort(new Object[]{"number"}, new boolean[]{true});
        this.lftCtxCombo.setContainerDataSource((Container)lftCtxContainer);
        this.rghtCtxCombo.setContainerDataSource((Container)rghtCtxContainer);
        this.lftCtxCombo.select((Object)lftContextIdx);
        this.rghtCtxCombo.select((Object)rghtCtxIdx);
        this.lftCtxCombo.setNewItemsAllowed(true);
        this.rghtCtxCombo.setNewItemsAllowed(true);
        this.lftCtxCombo.setImmediate(true);
        this.rghtCtxCombo.setImmediate(true);
        this.lftCtxCombo.setNewItemHandler((AbstractSelect.NewItemHandler)new AddNewItemHandler(this.lftCtxCombo));
        this.rghtCtxCombo.setNewItemHandler((AbstractSelect.NewItemHandler)new AddNewItemHandler(this.rghtCtxCombo));
        this.lftCtxCombo.addValueChangeListener((Property.ValueChangeListener)new ContextChangeListener(resultNumber, true));
        this.rghtCtxCombo.addValueChangeListener((Property.ValueChangeListener)new ContextChangeListener(resultNumber, false));
        Label leftCtxLabel = new Label("left context: ");
        Label rightCtxLabel = new Label("right context: ");
        leftCtxLabel.setWidth("-1px");
        rightCtxLabel.setWidth("-1px");
        HorizontalLayout ctxLayout = new HorizontalLayout();
        ctxLayout.setSpacing(true);
        ctxLayout.addComponents(new Component[]{leftCtxLabel, this.lftCtxCombo, rightCtxLabel, this.rghtCtxCombo});
        this.infoBar.addComponent((Component)ctxLayout);
        this.addComponent((Component)this.infoBar);
    }

    public void attach() {
        super.attach();
        this.initVisualizer();
        if (this.ui.getConfig().isShortenReferenceLinks() && !this.ui.isDesktopMode()) {
            this.btLink.setVisible(true);
        } else {
            this.btLink.setVisible(false);
        }
        IDGenerator.assignIDForFields((HasComponents)this, new Component[]{this.infoBar, this.btInfo});
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.btInfo && this.result != null) {
            Window infoWindow = new Window("Info for " + this.result.getId());
            infoWindow.setModal(false);
            MetaDataPanel meta = new MetaDataPanel(this.path.get(0), Optional.of(this.path.get(this.path.size() - 1)));
            infoWindow.setContent((Component)meta);
            infoWindow.setWidth("400px");
            infoWindow.setHeight("400px");
            UI.getCurrent().addWindow(infoWindow);
        }
    }

    private void calculateHelperVariables() {
        this.markedExactMap = new HashMap<String, String>();
    }

    @Override
    public void changeContext(long resultNumber, int context, boolean left) {
        this.queryController.changeContext(this.query, this.match, resultNumber, context, this, left);
    }

    private void initVisualizer() {
        try {
            this.resolverEntries = this.resolverProvider == null ? new LinkedList<VisualizerRule>() : this.resolverProvider.getResolverEntries(this.result, UI.getCurrent());
            this.visualizers = new LinkedList<VisualizerPanel>();
            LinkedList<VisualizerPanel> openVisualizers = new LinkedList<VisualizerPanel>();
            List<SNode> segNodes = Helper.getSortedSegmentationNodes(this.segmentationName, this.result.getDocumentGraph());
            Map<SNode, Long> markedAndCovered = Helper.calculateMarkedAndCovered(this.result, segNodes, this.segmentationName);
            String resultID = "" + new Random().nextInt(Integer.MAX_VALUE);
            int i = 0;
            for (VisualizerRule visRule : this.resolverEntries) {
                String htmlID = "resolver-" + this.resultNumber + "_" + i;
                VisualizerPanel p = new VisualizerPanel(visRule, i, this.result, this.match, this.visibleTokenAnnos, markedAndCovered, htmlID, resultID, this, this.segmentationName, this.ui);
                this.visualizers.add(p);
                if (this.visualizerState.containsKey(i)) {
                    if (this.visualizerState.get(i).booleanValue()) {
                        openVisualizers.add(p);
                    }
                } else if (Boolean.parseBoolean(visRule.getMappings().getOrDefault(INITIAL_OPEN, "false"))) {
                    openVisualizers.add(p);
                }
                ++i;
            }
            for (VisualizerPanel p : this.visualizers) {
                this.addComponent((Component)p);
            }
            for (VisualizerPanel p : openVisualizers) {
                p.toggleVisualizer(true, null);
            }
        }
        catch (RuntimeException ex) {
            log.error("problems with initializing Visualizer Panel", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error("problems with initializing Visualizer Panel", (Throwable)ex);
        }
    }

    @Override
    public void registerVisibilityStatus(int entryId, boolean status) {
        this.visualizerState.put(entryId, status);
    }

    public void setSegmentationLayer(String segmentationName) {
        this.segmentationName = segmentationName;
        if (this.result != null) {
            List<SNode> segNodes = Helper.getSortedSegmentationNodes(segmentationName, this.result.getDocumentGraph());
            Map<SNode, Long> markedAndCovered = Helper.calculateMarkedAndCovered(this.result, segNodes, segmentationName);
            for (VisualizerPanel p : this.visualizers) {
                p.setSegmentationLayer(segmentationName, markedAndCovered);
            }
        }
    }

    public void setVisibleTokenAnnosVisible(SortedSet<String> annos) {
        for (VisualizerPanel p : this.visualizers) {
            p.setVisibleTokenAnnosVisible(annos);
        }
    }

    private void showReloadingProgress() {
        for (VisualizerPanel v : this.visualizers) {
            this.removeComponent((Component)v);
        }
        this.reloadVisualizer = new ProgressBar(1.0f);
        this.reloadVisualizer.setIndeterminate(true);
        this.reloadVisualizer.setSizeFull();
        this.reloadVisualizer.setHeight(150.0f, Sizeable.Unit.PIXELS);
        this.addComponent((Component)this.reloadVisualizer);
    }

    private void showShareSingleMatchGenerator() {
        if (this.ui != null) {
            ((Set)this.ui.getQueryState().getSelectedMatches().getValue()).clear();
            ((Set)this.ui.getQueryState().getSelectedMatches().getValue()).add(this.resultNumber);
            this.ui.getSearchView().updateFragment(this.ui.getQueryController().getSearchQuery());
            ShareSingleMatchGenerator window = new ShareSingleMatchGenerator(this.ui, this.resolverEntries, this.match, this.query, this.segmentationName, this.ui.getVisualizerPlugins());
            window.setWidth(790.0f, Sizeable.Unit.PIXELS);
            window.setHeight(680.0f, Sizeable.Unit.PIXELS);
            window.setResizable(true);
            window.setModal(true);
            window.addCloseListener((Window.CloseListener & Serializable)e -> this.btLink.setEnabled(true));
            window.setCaption("Match reference link");
            this.ui.addWindow(window);
        }
    }

    @Override
    public void updateResult(SaltProject p, PagedResultQuery query) {
        this.query = query;
        if (p != null && p.getCorpusGraphs() != null && !p.getCorpusGraphs().isEmpty() && p.getCorpusGraphs().get(0) != null && ((SCorpusGraph)p.getCorpusGraphs().get(0)).getDocuments() != null && !((SCorpusGraph)p.getCorpusGraphs().get(0)).getDocuments().isEmpty()) {
            this.result = (SDocument)((SCorpusGraph)p.getCorpusGraphs().get(0)).getDocuments().get(0);
        }
        this.removeComponent((Component)this.reloadVisualizer);
        this.initVisualizer();
        this.lftCtxCombo.setEnabled(true);
        this.rghtCtxCombo.setEnabled(true);
    }

    private class ContextChangeListener
    implements Property.ValueChangeListener {
        private static final long serialVersionUID = 2450929501646415981L;
        long resultNumber;
        boolean left;

        public ContextChangeListener(long resultNumber, boolean left) {
            this.resultNumber = resultNumber;
            this.left = left;
        }

        public void valueChange(Property.ValueChangeEvent event) {
            SingleResultPanel.this.showReloadingProgress();
            SingleResultPanel.this.lftCtxCombo.setEnabled(false);
            SingleResultPanel.this.rghtCtxCombo.setEnabled(false);
            int ctx = Integer.parseInt(event.getProperty().getValue().toString());
            SingleResultPanel.this.changeContext(this.resultNumber, ctx, this.left);
        }
    }

    private static class AddNewItemHandler
    implements AbstractSelect.NewItemHandler {
        private static final long serialVersionUID = -8372467324750771745L;
        private final ComboBox combobox;

        public AddNewItemHandler(ComboBox comboBox) {
            this.combobox = comboBox;
        }

        public void addNewItem(String newValue) {
            String ERROR_MESSAGE_HEADER = "Illegal value";
            try {
                int i = Integer.parseInt(newValue);
                if (i < 0) {
                    new Notification(ERROR_MESSAGE_HEADER, "<div><p>context &lt; 0 makes no sense</p></div>", Notification.Type.WARNING_MESSAGE, true).show(Page.getCurrent());
                } else {
                    Item it = this.combobox.getContainerDataSource().addItem((Object)i);
                    if (it != null) {
                        it.getItemProperty((Object)"number").setValue((Object)i);
                        if (this.combobox.getContainerDataSource() instanceof IndexedContainer) {
                            ((IndexedContainer)this.combobox.getContainerDataSource()).sort(new Object[]{"number"}, new boolean[]{true});
                        }
                        this.combobox.select((Object)i);
                    }
                }
            }
            catch (NumberFormatException ex) {
                new Notification(ERROR_MESSAGE_HEADER, "<div><p>Only numbers are allowed.</p></div>", Notification.Type.WARNING_MESSAGE, true).show(Page.getCurrent());
            }
        }
    }
}

