/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.resultview;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.stream.XMLStreamException;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.graphml.DocumentGraphMapper;
import org.corpus_tools.annis.gui.media.MediaController;
import org.corpus_tools.annis.gui.media.MediaPlayer;
import org.corpus_tools.annis.gui.media.PDFViewer;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.annis.gui.objects.RawTextWrapper;
import org.corpus_tools.annis.gui.resultview.VisualizerContextChanger;
import org.corpus_tools.annis.gui.visualizers.FilteringVisualizerPlugin;
import org.corpus_tools.annis.gui.visualizers.LoadableVisualizer;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.VisualizerPlugin;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SNode;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualizerPanel
extends CssLayout
implements Button.ClickListener,
VisualizationToggle {
    public static final long serialVersionUID = 2L;
    public static final Resource ICON_COLLAPSE = VaadinIcons.MINUS_SQUARE_LEFT_O;
    public static final Resource ICON_EXPAND = VaadinIcons.PLUS_SQUARE_LEFT_O;
    private final Logger log = LoggerFactory.getLogger(VisualizerPanel.class);
    private List<String> path;
    private Component vis;
    private SDocument result;
    private VisualizerRule visRule;
    private Map<SNode, Long> markedAndCovered;
    private Button btEntry;
    private String htmlID;
    private String resultID;
    private final int visId;
    private VisualizerPlugin visPlugin = null;
    private Set<String> visibleTokenAnnos;
    private String segmentationName;
    private ProgressBar progress;
    private AnnisUI ui;
    private VisualizerContextChanger visCtxChanger;
    private static final String UNKNOWN = "<unknown>";

    public VisualizerPanel(VisualizerRule visRule, int visId, SDocument result, Match match, Set<String> visibleTokenAnnos, Map<SNode, Long> markedAndCovered, String htmlID, String resultID, VisualizerContextChanger parent, String segmentationName, AnnisUI ui) {
        this.ui = ui;
        this.visRule = visRule;
        this.visId = visId;
        this.visCtxChanger = parent;
        this.result = result;
        this.path = !match.getSaltIDs().isEmpty() ? Helper.getCorpusPath(match.getSaltIDs().get(0)) : new LinkedList<String>();
        this.visibleTokenAnnos = visibleTokenAnnos;
        this.markedAndCovered = markedAndCovered;
        this.segmentationName = segmentationName;
        this.htmlID = htmlID;
        this.resultID = resultID;
        this.progress = new ProgressBar();
        this.progress.setIndeterminate(true);
        this.progress.setVisible(false);
        this.progress.setEnabled(false);
        this.addStyleName("borderless");
        this.setWidth("100%");
    }

    public void attach() {
        super.attach();
        if (this.visRule != null) {
            this.visPlugin = this.ui.getVisualizerPlugins().stream().filter(plugin -> Objects.equal((Object)plugin.getShortName(), (Object)this.visRule.getVisType())).findAny().orElse(null);
            if (this.visPlugin == null) {
                this.visRule.setVisType("grid");
                this.visPlugin = this.ui.getVisualizerPlugins().stream().filter(plugin -> Objects.equal((Object)plugin.getShortName(), (Object)this.visRule.getVisType())).findAny().orElse(null);
            }
            if (this.visRule.getVisibility() == VisualizerRule.VisibilityEnum.HIDDEN) {
                this.btEntry = new Button(this.visRule.getDisplayName());
                this.btEntry.setIcon(ICON_EXPAND);
                this.btEntry.setStyleName("borderless small");
                this.btEntry.addClickListener((Button.ClickListener)this);
                this.btEntry.setDisableOnClick(true);
                this.addComponent((Component)this.btEntry);
                this.addComponent((Component)this.progress);
            } else {
                if (this.visRule.getVisibility() == VisualizerRule.VisibilityEnum.VISIBLE || this.visRule.getVisibility() == VisualizerRule.VisibilityEnum.PRELOADED) {
                    this.btEntry = new Button(this.visRule.getDisplayName());
                    this.btEntry.setIcon(ICON_COLLAPSE);
                    this.btEntry.setStyleName("borderless small");
                    this.btEntry.addClickListener((Button.ClickListener)this);
                    this.addComponent((Component)this.btEntry);
                }
                this.addComponent((Component)this.progress);
                try {
                    this.vis = this.createComponent();
                    if (this.vis != null) {
                        this.vis.setVisible(true);
                        this.addComponent(this.vis);
                    }
                }
                catch (Exception ex) {
                    Notification.show((String)("Could not create visualizer " + this.getVisualizerShortNameDebug()), (String)ex.toString(), (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
                    this.log.error("Could not create visualizer {}", (Object)this.getVisualizerShortNameDebug(), (Object)ex);
                }
                if (this.btEntry != null && this.visRule.getVisibility() == VisualizerRule.VisibilityEnum.PRELOADED) {
                    this.btEntry.setIcon(ICON_EXPAND);
                    if (this.vis != null) {
                        this.vis.setVisible(false);
                    }
                }
            }
        }
    }

    public void buttonClick(Button.ClickEvent event) {
        boolean isVisible = !this.visualizerIsVisible();
        this.visCtxChanger.registerVisibilityStatus(this.visId, isVisible);
        this.toggleVisualizer(isVisible, null);
    }

    private Component createComponent() {
        if (this.visPlugin == null) {
            return null;
        }
        VisualizerInput input = this.createInput();
        Component c = this.visPlugin.createComponent(input, this);
        if (c == null) {
            return c;
        }
        c.setVisible(false);
        c.addStyleName("corpus-font");
        c.addStyleName("vis-content");
        return c;
    }

    private VisualizerInput createInput() {
        VisualizerInput input = new VisualizerInput();
        input.setUI(this.ui);
        input.setContextPath(this.ui.getServletContext().getContextPath());
        input.setId(this.resultID);
        input.setMarkedAndCovered(this.markedAndCovered);
        input.setResult(this.result);
        input.setVisibleTokenAnnos(this.visibleTokenAnnos);
        input.setSegmentationName(this.segmentationName);
        if (this.ui.getInstanceConfig() != null && this.ui.getInstanceConfig().getFont() != null) {
            input.setFont(this.ui.getInstanceConfig().getFont());
        }
        if (this.visRule != null) {
            input.setMappings(this.visRule.getMappings());
            input.setNamespace(this.visRule.getLayer());
            String template = this.ui.getServletContext().getContextPath() + "/Resource/" + this.visRule.getVisType() + "/%s";
            input.setResourcePathTemplate(template);
        }
        if (this.visPlugin != null && this.visPlugin.isUsingText() && this.result != null && !this.result.getDocumentGraph().getNodes().isEmpty()) {
            SaltProject p;
            List<String> nodeAnnoFilter = null;
            if (this.visPlugin instanceof FilteringVisualizerPlugin) {
                nodeAnnoFilter = ((FilteringVisualizerPlugin)((Object)this.visPlugin)).getFilteredNodeAnnotationNames(this.path.get(0), Joiner.on((char)'/').join(this.path), input.getMappings(), this.ui);
            }
            if ((p = this.getDocument(this.path, nodeAnnoFilter, this.visPlugin.isUsingRawText(), this.ui)) != null && p.getCorpusGraphs() != null && !p.getCorpusGraphs().isEmpty() && ((SCorpusGraph)p.getCorpusGraphs().get(0)).getDocuments() != null && !((SCorpusGraph)p.getCorpusGraphs().get(0)).getDocuments().isEmpty()) {
                SDocument wholeDocument = (SDocument)((SCorpusGraph)p.getCorpusGraphs().get(0)).getDocuments().get(0);
                input.setDocument(wholeDocument);
                input.setRawText(new RawTextWrapper(wholeDocument.getDocumentGraph()));
            }
        } else {
            input.setDocument(this.result);
        }
        return input;
    }

    private SaltProject getDocument(List<String> docPath, List<String> nodeAnnoFilter, boolean useRawText, UI ui) {
        try {
            CorporaApi api = new CorporaApi(Helper.getClient(ui));
            String aql = Helper.buildDocumentQuery(docPath, nodeAnnoFilter, useRawText);
            File graphML = api.subgraphForQuery(this.path.get(0), aql, QueryLanguage.AQL, null);
            try {
                SaltProject p = SaltFactory.createSaltProject();
                SCorpusGraph cg = p.createCorpusGraph();
                URI docURI = URI.createURI((String)("salt:/" + Joiner.on((char)'/').join(this.path)));
                SDocument doc = cg.createDocument(docURI);
                SDocumentGraph docGraph = DocumentGraphMapper.map(graphML);
                doc.setDocumentGraph(docGraph);
                return p;
            }
            catch (IOException | XMLStreamException ex) {
                this.log.error("Could not map GraphML to Salt", (Throwable)ex);
                ui.access(() -> ExceptionDialog.show(ex, "Could not map GraphML to Salt", ui));
            }
        }
        catch (ApiException e) {
            this.log.error("General remote service exception", (Throwable)e);
        }
        return null;
    }

    public String getHtmlID() {
        return this.htmlID;
    }

    public String getVisualizerShortName() {
        return this.visPlugin == null ? null : this.visPlugin.getShortName();
    }

    private String getVisualizerShortNameDebug() {
        return this.visPlugin == null ? UNKNOWN : this.visPlugin.getShortName();
    }

    private void loadVisualizer(LoadableVisualizer.Callback callback) {
        if (this.visPlugin != null) {
            this.btEntry.setIcon(ICON_COLLAPSE);
            this.progress.setIndeterminate(true);
            this.progress.setVisible(true);
            this.progress.setEnabled(true);
            this.progress.setDescription("Loading visualizer" + this.visPlugin.getShortName());
            ExecutorService execService = Executors.newSingleThreadExecutor();
            Future<Component> future = execService.submit(() -> {
                if (this.vis == null) {
                    return this.createComponent();
                }
                return this.vis;
            });
            Background.run(new BackgroundJob(future, callback));
        }
    }

    public void setSegmentationLayer(String segmentationName, Map<SNode, Long> markedAndCovered) {
        this.segmentationName = segmentationName;
        this.markedAndCovered = markedAndCovered;
        if (this.visPlugin != null && this.vis != null) {
            this.visPlugin.setSegmentationLayer(this.vis, segmentationName, markedAndCovered);
        }
    }

    public void setVisibleTokenAnnosVisible(SortedSet<String> annos) {
        this.visibleTokenAnnos = annos;
        if (this.visPlugin != null && this.vis != null) {
            this.visPlugin.setVisibleTokenAnnosVisible(this.vis, annos);
        }
    }

    @Override
    public void toggleVisualizer(boolean visible, LoadableVisualizer.Callback callback) {
        if (visible) {
            this.loadVisualizer(callback);
        } else {
            this.btEntry.setEnabled(true);
            if (this.vis != null) {
                this.vis.setVisible(false);
                if (this.vis instanceof MediaPlayer) {
                    this.removeComponent(this.vis);
                }
            }
            this.btEntry.setIcon(ICON_EXPAND);
        }
    }

    @Override
    public boolean visualizerIsVisible() {
        return this.vis != null && this.vis.isVisible();
    }

    private class BackgroundJob
    implements Runnable {
        private final Future<Component> future;
        private final LoadableVisualizer.Callback callback;

        public BackgroundJob(Future<Component> future, LoadableVisualizer.Callback callback) {
            this.future = future;
            this.callback = callback;
        }

        @Override
        public void run() {
            Exception exception = null;
            try {
                Component createdComponent = this.future.get(60L, TimeUnit.SECONDS);
                VisualizerPanel.this.ui.access(() -> {
                    VisualizerPanel.this.vis = createdComponent;
                    this.updateGUIAfterLoadingVisualizer(this.callback);
                });
            }
            catch (InterruptedException ex) {
                VisualizerPanel.this.log.error(null, (Throwable)ex);
                exception = ex;
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                VisualizerPanel.this.log.error(null, (Throwable)ex);
                exception = ex;
            }
            catch (TimeoutException ex) {
                this.future.cancel(true);
                VisualizerPanel.this.log.error("Could create visualizer {} in 60 seconds: Timeout", (Object)(VisualizerPanel.this.visPlugin == null ? VisualizerPanel.UNKNOWN : VisualizerPanel.this.visPlugin.getShortName()), (Object)ex);
                exception = ex;
            }
            if (exception != null) {
                Exception finalException = exception;
                VisualizerPanel.this.ui.access(() -> Notification.show((String)("Error when creating visualizer " + (VisualizerPanel.this.visPlugin == null ? VisualizerPanel.UNKNOWN : VisualizerPanel.this.visPlugin.getShortName())), (String)finalException.toString(), (Notification.Type)Notification.Type.WARNING_MESSAGE));
            }
        }

        private void updateGUIAfterLoadingVisualizer(LoadableVisualizer.Callback callback) {
            if (callback != null && VisualizerPanel.this.vis instanceof LoadableVisualizer) {
                LoadableVisualizer loadableVis = (LoadableVisualizer)VisualizerPanel.this.vis;
                if (loadableVis.isLoaded()) {
                    callback.visualizerLoaded(loadableVis);
                } else {
                    loadableVis.clearCallbacks();
                    loadableVis.addOnLoadCallBack(callback);
                }
            }
            VisualizerPanel.this.progress.setEnabled(false);
            VisualizerPanel.this.progress.setVisible(false);
            if (VisualizerPanel.this.vis != null) {
                VisualizerPanel.this.btEntry.setEnabled(true);
                VisualizerPanel.this.vis.setVisible(true);
                if (VisualizerPanel.this.vis instanceof PDFViewer) {
                    ((PDFViewer)VisualizerPanel.this.vis).openPDFPage("-1");
                }
                if (VisualizerPanel.this.vis instanceof MediaPlayer) {
                    MediaController mediaController = (MediaController)VaadinSession.getCurrent().getAttribute(MediaController.class);
                    mediaController.closeOtherPlayers((MediaPlayer)VisualizerPanel.this.vis);
                }
                if (VisualizerPanel.this.getComponentIndex(VisualizerPanel.this.vis) < 0) {
                    VisualizerPanel.this.addComponent(VisualizerPanel.this.vis);
                }
            }
        }
    }
}

