/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.security;

import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.autoconfigure.security.oauth2.client.ClientsConfiguredCondition;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

@Configuration
public class SecurityConfiguration {
    private static final String LOGOUT_URL = "/logout";
    private static final String LOGOUT_SUCCESS_URL = "/";
    public static final String ROLES_CLAIM = "https://corpus-tools.org/annis/roles";
    public static final String FRAGMENT_TO_RESTORE = "ANNIS_FRAGENT_TO_RESTORE";

    private static void ignoreVaadinWebSecurity(WebSecurity web) {
        web.ignoring().antMatchers(new String[]{"/VAADIN/**", "/favicon.ico", "/manifest.webmanifest", "/sw.js", "/offline-page.html", "/icons/**", "/images/**"});
    }

    private static void configureHttpVaadinSecurity(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/PUSH/**"})).permitAll().antMatchers(new String[]{"/UIDL/**"})).permitAll().antMatchers(new String[]{"/HEARTBEAT/**"})).permitAll().antMatchers(new String[]{"/**"})).permitAll().and()).authorizeRequests().anyRequest()).authenticated().and()).csrf().disable();
        http.headers().frameOptions().sameOrigin();
    }

    @EnableWebSecurity
    @Conditional(value={NoClientsConfiguredCondition.class})
    public static class NoLoginSecurityConfig
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            SecurityConfiguration.configureHttpVaadinSecurity(http);
        }

        public void configure(WebSecurity web) {
            SecurityConfiguration.ignoreVaadinWebSecurity(web);
        }
    }

    @EnableWebSecurity
    @Conditional(value={ClientsConfiguredCondition.class})
    public static class OAuth2LoginSecurityConfig
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            SecurityConfiguration.configureHttpVaadinSecurity(http);
            ((HttpSecurity)http.logout().logoutUrl(SecurityConfiguration.LOGOUT_URL).logoutSuccessUrl(SecurityConfiguration.LOGOUT_SUCCESS_URL).and()).oauth2Login();
        }

        public void configure(WebSecurity web) {
            SecurityConfiguration.ignoreVaadinWebSecurity(web);
        }
    }

    private static class NoClientsConfiguredCondition
    extends NoneNestedConditions {
        NoClientsConfiguredCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @Conditional(value={ClientsConfiguredCondition.class})
        static class ClientsConfigured {
            ClientsConfigured() {
            }
        }
    }
}

