/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.servlets;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@WebServlet(urlPatterns={"/Cite/*"})
@Component
public class CitationRedirectionServlet
extends HttpServlet {
    private static final long serialVersionUID = 5264592666872908858L;
    private static final Logger log = LoggerFactory.getLogger(CitationRedirectionServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            URI uri = new URI(req.getRequestURI());
            req.getSession().setAttribute("citation", (Object)uri.getPath());
            resp.sendRedirect(req.getContextPath() + "/");
        }
        catch (IOException | URISyntaxException ex) {
            log.error(null, (Throwable)ex);
            try {
                resp.sendError(400, ex.getMessage());
            }
            catch (IOException sendEx) {
                log.error("Could not send error to client", (Throwable)sendEx);
            }
        }
    }
}

