/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.servlets;

import com.google.common.base.Objects;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.visualizers.ResourcePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@WebServlet(urlPatterns={"/Resource/*"})
@Component
public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = -8182635617256833563L;
    private static final Logger log = LoggerFactory.getLogger(ResourceServlet.class);
    @Autowired
    private List<ResourcePlugin> plugins;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletOutputStream outStream = response.getOutputStream();
        String completePath = request.getPathInfo();
        if (completePath == null) {
            response.sendError(404, "must provide a valid and existing path with a vistype");
            return;
        }
        completePath = completePath.substring(1);
        String[] pathComponents = completePath.split("/");
        String vistype = pathComponents[0];
        if (pathComponents.length < 2) {
            response.sendError(404, "must provide a valid and existing path");
            return;
        }
        String path = StringUtils.join((Object[])Arrays.copyOfRange(pathComponents, 1, pathComponents.length), (String)"/");
        Optional<ResourcePlugin> vis = this.plugins.stream().filter(p -> Objects.equal((Object)p.getShortName(), (Object)vistype)).findAny();
        if (!vis.isPresent()) {
            response.sendError(400, "There is no resource with the short name " + vistype);
        } else if (path.endsWith(".class")) {
            response.sendError(403, "illegal class path access");
        } else {
            URL resource = vis.get().getClass().getResource(path);
            if (resource == null) {
                response.sendError(404, path + " not found");
            } else {
                URLConnection resourceConnection = resource.openConnection();
                long resourceLastModified = resourceConnection.getLastModified();
                long requestLastModified = request.getDateHeader("If-Modified-Since");
                if (requestLastModified != -1L && resourceLastModified <= requestLastModified) {
                    response.setStatus(304);
                } else {
                    response.addDateHeader("Last-Modified", resourceLastModified);
                    if ("localhost".equals(request.getServerName())) {
                        response.addDateHeader("Expires", new Date().getTime());
                    } else {
                        response.addDateHeader("Expires", new Date().getTime() + 60000L);
                    }
                    String mimeType = this.getServletContext().getMimeType(path);
                    response.setContentType(mimeType);
                    if (mimeType.startsWith("text/")) {
                        response.setCharacterEncoding("UTF-8");
                    }
                    BufferedOutputStream bufferedOut = new BufferedOutputStream((OutputStream)outStream);
                    try (BufferedInputStream resourceInStream = new BufferedInputStream(resource.openStream());){
                        int v;
                        while ((v = ((InputStream)resourceInStream).read()) != -1) {
                            ((OutputStream)bufferedOut).write(v);
                        }
                    }
                    finally {
                        ((OutputStream)bufferedOut).flush();
                        outStream.flush();
                    }
                }
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.performGet(request, response);
        }
        catch (IOException ex) {
            log.error("Input/output error when serving a resource", (Throwable)ex);
        }
    }
}

