/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component;

import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Embedded;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import org.corpus_tools.annis.gui.ImagePanel;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.visualizers.AbstractVisualizer;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;

public abstract class AbstractImageVisualizer
extends AbstractVisualizer {
    private static final long serialVersionUID = -3055099196694903386L;

    public ImagePanel createComponent(VisualizerInput visInput, VisualizationToggle visToggle) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeOutput(visInput, out);
        String fileName = "vis_" + UUID.randomUUID().toString() + ".png";
        StreamResource resource = new StreamResource((StreamResource.StreamSource & Serializable)() -> new ByteArrayInputStream(out.toByteArray()), fileName);
        Embedded emb = new Embedded("", (Resource)resource);
        emb.setMimeType(this.getContentType());
        emb.setSizeUndefined();
        emb.setStandby("loading image");
        emb.setAlternateText("Visualization of the result");
        return new ImagePanel(emb);
    }

    public abstract String getContentType();

    public abstract void writeOutput(VisualizerInput var1, OutputStream var2);
}

