/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.grid;

import com.google.common.base.Splitter;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.PDFPageHelper;
import org.corpus_tools.annis.gui.media.PDFController;
import org.corpus_tools.annis.gui.media.TimeHelper;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.widgets.grid.GridEvent;
import org.corpus_tools.annis.gui.widgets.grid.Row;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventExtractor {
    private static final Logger log = LoggerFactory.getLogger(EventExtractor.class);

    private static void addAnnotationsForNode(SNode node, SDocumentGraph graph, Map<SToken, Integer> token2index, PDFController pdfController, PDFPageHelper pageNumberHelper, AtomicInteger eventCounter, LinkedHashMap<String, ArrayList<Row>> rowsByAnnotation, boolean addMatch, Set<String> mediaLayer, boolean replaceValueWithMediaIcon) {
        SFeature featMatched;
        List matchedAnnos = new ArrayList();
        SFeature featMatchedAnnos = graph.getFeature("annis", "matchedannos");
        if (featMatchedAnnos != null) {
            matchedAnnos = Splitter.on((char)',').trimResults().splitToList((CharSequence)featMatchedAnnos.getValue_STEXT());
        }
        Long matchRaw = (featMatched = node.getFeature("annis", "matchednode")) == null ? null : featMatched.getValue_SNUMERIC();
        String matchedQualifiedAnnoName = "";
        if (matchRaw != null && matchRaw <= (long)matchedAnnos.size()) {
            matchedQualifiedAnnoName = (String)matchedAnnos.get((int)matchRaw.longValue() - 1);
        }
        Range<Integer> overlappedSpan = Helper.getLeftRightSpan(node, graph, token2index);
        int left = (Integer)overlappedSpan.lowerEndpoint();
        int right = (Integer)overlappedSpan.upperEndpoint();
        for (SAnnotation anno : node.getAnnotations()) {
            String page;
            ArrayList<Row> rows = rowsByAnnotation.get(anno.getQName());
            if (rows == null) {
                rows = rowsByAnnotation.get(anno.getName());
            }
            if (rows == null) continue;
            Row r = new Row();
            String id = "event_" + eventCounter.incrementAndGet();
            GridEvent event = new GridEvent(id, left, right, anno.getValue_STEXT());
            event.setTooltip(Helper.getQualifiedName(anno));
            if (addMatch && matchRaw != null) {
                long match = matchRaw;
                if (matchedQualifiedAnnoName.isEmpty()) {
                    event.setMatch(match);
                } else if (matchedQualifiedAnnoName.equals(anno.getQName())) {
                    event.setMatch(match);
                }
            }
            if (node instanceof SSpan) {
                List outEdges = graph.getOutRelations(node.getId());
                if (outEdges != null) {
                    for (SRelation e : outEdges) {
                        if (!(e instanceof SSpanningRelation)) continue;
                        SSpanningRelation spanRel = (SSpanningRelation)e;
                        SToken tok = (SToken)spanRel.getTarget();
                        event.getCoveredIDs().add(tok.getId());
                        String textID = Helper.getTextualDSForNode((SNode)tok, graph).getId();
                        if (textID == null) continue;
                        event.setTextID(textID);
                    }
                }
            } else if (node instanceof SToken) {
                event.getCoveredIDs().add(node.getId());
                String textID = Helper.getTextualDSForNode(node, graph).getId();
                if (textID != null) {
                    event.setTextID(textID);
                }
            }
            if (mediaLayer == null || mediaLayer.contains(anno.getQName())) {
                double[] startEndTime = TimeHelper.getOverlappedTime(node);
                if (startEndTime.length == 1) {
                    if (replaceValueWithMediaIcon) {
                        event.setValue(" ");
                        event.setTooltip("play excerpt " + event.getStartTime());
                    }
                    event.setStartTime(startEndTime[0]);
                } else if (startEndTime.length == 2) {
                    event.setStartTime(startEndTime[0]);
                    event.setEndTime(startEndTime[1]);
                    if (replaceValueWithMediaIcon) {
                        event.setValue(" ");
                        event.setTooltip("play excerpt " + event.getStartTime() + "-" + event.getEndTime());
                    }
                }
            }
            r.addEvent(event);
            rows.add(r);
            if (pdfController == null || pdfController.sizeOfRegisterdPDFViewer() <= 0 || (page = pageNumberHelper.getPageFromAnnotation(node)) == null) continue;
            event.setPage(page);
        }
    }

    private static long clip(long value, long min, long max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static List<String> computeDisplayAnnotations(VisualizerInput input, Class<? extends SNode> type) {
        String regexFilterRaw;
        if (input == null) {
            return new LinkedList<String>();
        }
        SDocumentGraph graph = input.getDocument().getDocumentGraph();
        Set<String> annoPool = SToken.class.isAssignableFrom(type) ? EventExtractor.getAnnotationLevelSet(graph, null, type) : EventExtractor.getAnnotationLevelSet(graph, input.getNamespace(), type);
        LinkedList<String> annos = new LinkedList<String>(annoPool);
        String annosConfiguration = input.getMappings().get("annos");
        if (annosConfiguration != null && annosConfiguration.trim().length() > 0) {
            String[] split = annosConfiguration.split(",");
            annos.clear();
            for (String s : split) {
                if ((s = s.trim()).startsWith("/") && s.endsWith("/")) {
                    Pattern regex = Pattern.compile(StringUtils.strip((String)s, (String)"/"));
                    LinkedList<String> matchingAnnos = new LinkedList<String>();
                    for (String a : annoPool) {
                        if (!regex.matcher(a).matches()) continue;
                        matchingAnnos.add(a);
                    }
                    annos.addAll(matchingAnnos);
                    annoPool.removeAll(matchingAnnos);
                    continue;
                }
                annos.add(s);
                annoPool.remove(s);
            }
        }
        if ((regexFilterRaw = input.getMappings().get("anno_regex")) != null) {
            try {
                Pattern regexFilter = Pattern.compile(regexFilterRaw);
                ListIterator itAnnos = annos.listIterator();
                while (itAnnos.hasNext()) {
                    String a = (String)itAnnos.next();
                    if (regexFilter.matcher(a).matches()) continue;
                    itAnnos.remove();
                }
            }
            catch (PatternSyntaxException ex) {
                log.warn("invalid regular expression in mapping for grid visualizer", (Throwable)ex);
            }
        }
        return annos;
    }

    public static Set<String> computeDisplayedNamespace(VisualizerInput input, List<Class<? extends SNode>> types) {
        if (input == null) {
            return new HashSet<String>();
        }
        String showNamespaceConfig = input.getMappings().get("show_ns");
        if (showNamespaceConfig != null) {
            SDocumentGraph graph = input.getDocument().getDocumentGraph();
            LinkedHashSet<String> annoPool = new LinkedHashSet<String>();
            for (Class<? extends SNode> t : types) {
                annoPool.addAll(SToken.class.isAssignableFrom(t) ? EventExtractor.getAnnotationLevelSet(graph, null, t) : EventExtractor.getAnnotationLevelSet(graph, input.getNamespace(), t));
            }
            if ("true".equalsIgnoreCase(showNamespaceConfig)) {
                return annoPool;
            }
            if ("false".equalsIgnoreCase(showNamespaceConfig)) {
                return new LinkedHashSet<String>();
            }
            LinkedHashSet<String> annos = new LinkedHashSet<String>();
            List defs = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)showNamespaceConfig);
            for (String s : defs) {
                if (s.startsWith("/") && s.endsWith("/")) {
                    Pattern regex = Pattern.compile(StringUtils.strip((String)s, (String)"/"));
                    LinkedList<String> matchingAnnos = new LinkedList<String>();
                    for (String a : annoPool) {
                        if (!regex.matcher(a).matches()) continue;
                        matchingAnnos.add(a);
                    }
                    annos.addAll(matchingAnnos);
                    annoPool.removeAll(matchingAnnos);
                    continue;
                }
                annos.add(s);
                annoPool.remove(s);
            }
            return annos;
        }
        return new LinkedHashSet<String>();
    }

    private static Set<String> getAnnotationLevelSet(SDocumentGraph graph, String namespace, Class<? extends SNode> type) {
        List nodes;
        TreeSet<String> result = new TreeSet<String>();
        if (graph != null && (nodes = SSpan.class == type ? graph.getSpans() : (SToken.class == type ? graph.getTokens() : graph.getNodes())) != null) {
            block0: for (SNode n : nodes) {
                if (!type.isAssignableFrom(n.getClass())) continue;
                for (SLayer layer : n.getLayers()) {
                    if (namespace != null && !namespace.equals(layer.getName())) continue;
                    for (SAnnotation anno : n.getAnnotations()) {
                        result.add(anno.getQName());
                    }
                    continue block0;
                }
            }
        }
        return result;
    }

    private static void mergeAllRowsIfPossible(ArrayList<Row> rows) {
        Random rand = new Random(5711L);
        int tries = 0;
        int maxTries = rows.size() * 2;
        while (rows.size() > 1 && tries < maxTries) {
            Row second;
            int secondIdx;
            int oneIdx = rand.nextInt(rows.size());
            if (oneIdx == (secondIdx = rand.nextInt(rows.size()))) continue;
            Row one = rows.get(oneIdx);
            if (one.merge(second = rows.get(secondIdx))) {
                rows.remove(secondIdx);
                tries = 0;
                continue;
            }
            ++tries;
        }
    }

    public static LinkedHashMap<String, ArrayList<Row>> parseSalt(VisualizerInput input, boolean showSpanAnnos, boolean showTokenAnnos, List<String> annotationNames, Set<String> mediaLayer, boolean replaceValueWithMediaIcon, Map<SToken, Integer> token2index, PDFController pdfController, STextualDS text) {
        SDocumentGraph graph = input.getDocument().getDocumentGraph();
        LinkedHashMap<String, ArrayList<Row>> rowsByAnnotation = new LinkedHashMap<String, ArrayList<Row>>();
        for (String anno : annotationNames) {
            rowsByAnnotation.put(anno, new ArrayList());
        }
        AtomicInteger eventCounter = new AtomicInteger();
        PDFPageHelper pageNumberHelper = new PDFPageHelper(input);
        if (showSpanAnnos) {
            for (SSpan sSpan : graph.getSpans()) {
                if (text != null && text != Helper.getTextualDSForNode((SNode)sSpan, graph)) continue;
                EventExtractor.addAnnotationsForNode((SNode)sSpan, graph, token2index, pdfController, pageNumberHelper, eventCounter, rowsByAnnotation, true, mediaLayer, replaceValueWithMediaIcon);
            }
        }
        if (showTokenAnnos) {
            for (SToken sToken : graph.getTokens()) {
                if (text != null && text != Helper.getTextualDSForNode((SNode)sToken, graph)) continue;
                EventExtractor.addAnnotationsForNode((SNode)sToken, graph, token2index, pdfController, pageNumberHelper, eventCounter, rowsByAnnotation, false, mediaLayer, replaceValueWithMediaIcon);
            }
        }
        for (Map.Entry entry : rowsByAnnotation.entrySet()) {
            EventExtractor.mergeAllRowsIfPossible((ArrayList)entry.getValue());
        }
        for (Map.Entry entry : rowsByAnnotation.entrySet()) {
            for (Row r : (ArrayList)entry.getValue()) {
                EventExtractor.sortEventsByTokenIndex(r);
            }
        }
        for (Map.Entry entry : rowsByAnnotation.entrySet()) {
            for (Row r : (ArrayList)entry.getValue()) {
                EventExtractor.splitRowsOnIslands(r, graph, text, token2index);
            }
        }
        for (Map.Entry entry : rowsByAnnotation.entrySet()) {
            for (Row r : (ArrayList)entry.getValue()) {
                EventExtractor.splitRowsOnGaps(r, graph, token2index);
            }
        }
        return rowsByAnnotation;
    }

    public static void removeEmptySpace(LinkedHashMap<String, ArrayList<Row>> rowsByAnnotation, Row tokenRow) {
        int gapStart;
        int gapEnd;
        LinkedList<Range> gaps = new LinkedList<Range>();
        BitSet totalOccupancyGrid = new BitSet();
        for (Map.Entry<String, ArrayList<Row>> layer : rowsByAnnotation.entrySet()) {
            for (Row r : layer.getValue()) {
                totalOccupancyGrid.or(r.getOccupancyGridCopy());
            }
        }
        if (tokenRow != null) {
            totalOccupancyGrid.or(tokenRow.getOccupancyGridCopy());
        }
        Range gap = Range.closed((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(totalOccupancyGrid.nextSetBit(0)));
        while ((gapEnd = totalOccupancyGrid.nextSetBit(gapStart = totalOccupancyGrid.nextClearBit((Integer)gap.upperEndpoint() + 1))) > 0) {
            gap = Range.closed((Comparable)Integer.valueOf(gapStart), (Comparable)Integer.valueOf(gapEnd - 1));
            gaps.add(gap);
        }
        int gapID = 0;
        int totalOffset = 0;
        for (Range gRaw : gaps) {
            Range g = Range.closed((Comparable)Integer.valueOf((Integer)gRaw.lowerEndpoint() - totalOffset), (Comparable)Integer.valueOf((Integer)gRaw.upperEndpoint() - totalOffset));
            int offset = (Integer)g.upperEndpoint() - (Integer)g.lowerEndpoint();
            totalOffset += offset;
            for (Map.Entry<String, ArrayList<Row>> rowEntry : rowsByAnnotation.entrySet()) {
                ArrayList<Row> rows = rowEntry.getValue();
                for (Row r : rows) {
                    LinkedList<GridEvent> eventsCopy = new LinkedList<GridEvent>(r.getEvents());
                    for (GridEvent e : eventsCopy) {
                        if (e.getLeft() < (Integer)g.upperEndpoint()) continue;
                        r.removeEvent(e);
                        e.setLeft(e.getLeft() - offset);
                        e.setRight(e.getRight() - offset);
                        r.addEvent(e);
                    }
                    String spaceCaption = "";
                    if ("tok".equalsIgnoreCase(rowEntry.getKey())) {
                        spaceCaption = "(...)";
                    }
                    GridEvent spaceEvent = new GridEvent("gap-" + gapID, (Integer)g.lowerEndpoint(), (Integer)g.lowerEndpoint(), spaceCaption);
                    spaceEvent.setSpace(true);
                    r.addEvent(spaceEvent);
                    ++gapID;
                }
            }
        }
    }

    private static void sortEventsByTokenIndex(Row row) {
        Collections.sort(row.getEvents(), (o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return Integer.compare(o1.getLeft(), o2.getLeft());
        });
    }

    private static void splitRowsOnGaps(Row row, SDocumentGraph graph, Map<SToken, Integer> token2index) {
        ListIterator<GridEvent> itEvents = row.getEvents().listIterator();
        while (itEvents.hasNext()) {
            GridEvent event = itEvents.next();
            int lastTokenIndex = -1;
            LinkedList<String> sortedCoveredToken = new LinkedList<String>(event.getCoveredIDs());
            Collections.sort(sortedCoveredToken, (o1, o2) -> {
                SToken node2;
                SToken node1 = (SToken)graph.getNode(o1);
                if (node1 == (node2 = (SToken)graph.getNode(o2))) {
                    return 0;
                }
                if (node1 == null) {
                    return -1;
                }
                if (node2 == null) {
                    return 1;
                }
                long tokenIndex1 = ((Integer)token2index.get(node1)).intValue();
                long tokenIndex2 = ((Integer)token2index.get(node2)).intValue();
                return Long.valueOf(tokenIndex1).compareTo(tokenIndex2);
            });
            LinkedList<GridEvent> gaps = new LinkedList<GridEvent>();
            for (String id : sortedCoveredToken) {
                SToken node = (SToken)graph.getNode(id);
                int tokenIndex = token2index.get(node);
                if (tokenIndex >= event.getLeft() && tokenIndex <= event.getRight()) {
                    int diff = tokenIndex - lastTokenIndex;
                    if (lastTokenIndex >= 0 && diff > 1) {
                        GridEvent gap = new GridEvent(event.getId() + "_gap_" + gaps.size(), lastTokenIndex + 1, tokenIndex - 1, "");
                        gap.setGap(true);
                        gaps.add(gap);
                    }
                    lastTokenIndex = tokenIndex;
                    continue;
                }
                lastTokenIndex = -1;
            }
            ListIterator itGaps = gaps.listIterator();
            int oldRight = event.getRight();
            int gapNr = 0;
            while (itGaps.hasNext()) {
                GridEvent gap = (GridEvent)itGaps.next();
                if (gapNr == 0) {
                    event.setRight(gap.getLeft() - 1);
                }
                itEvents.add(gap);
                int rightBorder = oldRight;
                if (itGaps.hasNext()) {
                    GridEvent nextGap = (GridEvent)itGaps.next();
                    itGaps.previous();
                    rightBorder = nextGap.getLeft() - 1;
                }
                GridEvent after = new GridEvent(event);
                after.setId(event.getId() + "_after_" + gapNr);
                after.setLeft(gap.getRight() + 1);
                after.setRight(rightBorder);
                itEvents.add(after);
                ++gapNr;
            }
        }
    }

    private static void splitRowsOnIslands(Row row, SDocumentGraph graph, STextualDS text, Map<SToken, Integer> token2index) {
        BitSet tokenCoverage = new BitSet();
        List sortedTokenList = graph.getSortedTokenByText();
        ListIterator itToken = sortedTokenList.listIterator();
        while (itToken.hasNext()) {
            SToken t = (SToken)itToken.next();
            if (text != null && text != Helper.getTextualDSForNode((SNode)t, graph)) continue;
            int tokenIndex = token2index.get(t);
            tokenCoverage.set(tokenIndex);
        }
        ListIterator<GridEvent> itEvents = row.getEvents().listIterator();
        while (itEvents.hasNext()) {
            GridEvent event = itEvents.next();
            BitSet eventBitSet = new BitSet();
            eventBitSet.set(event.getLeft(), event.getRight() + 1);
            eventBitSet.and(tokenCoverage);
            if (eventBitSet.nextClearBit(event.getLeft()) > event.getRight()) continue;
            row.removeEvent(itEvents);
            int subElement = 0;
            int offset = eventBitSet.nextSetBit(0);
            while (offset >= 0) {
                int end = eventBitSet.nextClearBit(offset) - 1;
                if (offset < end) {
                    GridEvent newEvent = new GridEvent(event);
                    newEvent.setId(event.getId() + "_islandsplit_" + subElement++);
                    newEvent.setLeft(offset);
                    newEvent.setRight(end);
                    row.addEvent(itEvents, newEvent);
                }
                offset = eventBitSet.nextSetBit(end + 1);
            }
        }
    }
}

