/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.grid;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.media.MediaController;
import org.corpus_tools.annis.gui.media.PDFController;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.grid.EventExtractor;
import org.corpus_tools.annis.gui.visualizers.component.grid.GridComponent;
import org.corpus_tools.annis.gui.widgets.grid.AnnotationGrid;
import org.corpus_tools.annis.gui.widgets.grid.GridEvent;
import org.corpus_tools.annis.gui.widgets.grid.Row;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;

public class SingleGridComponent
extends Panel
implements GridComponent {
    private static final long serialVersionUID = -5105505611908943014L;
    private AnnotationGrid grid;
    private final transient VisualizerInput input;
    private final transient MediaController mediaController;
    private final transient PDFController pdfController;
    private final VerticalLayout layout;
    private Set<String> manuallySelectedTokenAnnos;
    private String segmentationName;
    private final transient STextualDS enforcedText;
    private final Label lblEmptyToken;
    private final boolean forceToken;

    private static String extractTextForToken(SNode t, String segmentation) {
        if (t instanceof SToken) {
            return Helper.getSpannedText((SToken)t);
        }
        if (segmentation != null) {
            for (SAnnotation anno : t.getAnnotations()) {
                if (!anno.getName().equals(segmentation)) continue;
                return anno.getValue_STEXT();
            }
        }
        return "";
    }

    public SingleGridComponent(VisualizerInput input, MediaController mediaController, PDFController pdfController, boolean forceToken, STextualDS enforcedText) {
        this.input = input;
        this.mediaController = mediaController;
        this.pdfController = pdfController;
        this.enforcedText = enforcedText;
        this.forceToken = forceToken;
        this.setWidth("100%");
        this.setHeight("-1");
        this.layout = new VerticalLayout();
        this.setContent((Component)this.layout);
        this.layout.setSizeUndefined();
        this.addStyleName("borderless");
        this.lblEmptyToken = new Label("(Empty token list, you may want to select another base text from the menu above.)");
        this.lblEmptyToken.setVisible(false);
        this.lblEmptyToken.addStyleName("empty_token_hint");
        this.layout.addComponent((Component)this.lblEmptyToken);
    }

    public void attach() {
        super.attach();
        if (this.input != null) {
            this.manuallySelectedTokenAnnos = this.input.getVisibleTokenAnnos();
            this.segmentationName = this.forceToken ? null : this.input.getSegmentationName();
            List texts = this.input.getDocument().getDocumentGraph().getTextualDSs();
            if (this.input.getUI() instanceof AnnisUI && texts != null && texts.size() > 0 && !((AnnisUI)this.input.getUI()).getConfig().isDisableRTL() && Helper.containsRTLText(((STextualDS)texts.get(0)).getText())) {
                this.addStyleName("rtl");
            }
            this.createAnnotationGrid();
        }
    }

    protected boolean canShowEmptyTokenWarning() {
        return false;
    }

    private LinkedHashMap<String, ArrayList<Row>> computeAnnotationRows(Map<SToken, Integer> token2index) {
        boolean showTokenAnnotations;
        LinkedList<String> annos = new LinkedList<String>();
        boolean showSpanAnnotations = this.isShowingSpanAnnotations();
        if (showSpanAnnotations) {
            annos.addAll(EventExtractor.computeDisplayAnnotations(this.input, SSpan.class));
        }
        if (showTokenAnnotations = this.isShowingTokenAnnotations()) {
            List<String> tokenAnnos = EventExtractor.computeDisplayAnnotations(this.input, SToken.class);
            if (this.manuallySelectedTokenAnnos != null) {
                tokenAnnos.retainAll(this.manuallySelectedTokenAnnos);
            }
            annos.addAll(tokenAnnos);
        }
        HashSet<String> mediaAnnotations = null;
        if (this.isFilteringMediaLayer()) {
            mediaAnnotations = new HashSet<String>();
            Pattern patternMedia = Pattern.compile("(annis::)?time");
            for (String qname : annos) {
                if (!patternMedia.matcher(qname).matches()) continue;
                mediaAnnotations.add(qname);
            }
        }
        LinkedHashMap<String, ArrayList<Row>> rowsByAnnotation = EventExtractor.parseSalt(this.input, showSpanAnnotations, showTokenAnnotations, annos, mediaAnnotations, this.isAddingPlaybackRow(), token2index, this.pdfController, this.enforcedText);
        return rowsByAnnotation;
    }

    private Row computeTokenRow(List<SNode> tokens, SDocumentGraph graph, LinkedHashMap<String, ArrayList<Row>> rowsByAnnotation, Map<SToken, Integer> token2index) {
        HashSet<String> validTextIDs = new HashSet<String>();
        if (this.enforcedText == null) {
            for (ArrayList<Row> rowsForAnnotation : rowsByAnnotation.values()) {
                for (Row r : rowsForAnnotation) {
                    validTextIDs.addAll(r.getTextIDs());
                }
            }
            List allTexts = graph.getTextualDSs();
            if (validTextIDs.isEmpty() && allTexts != null && (allTexts.size() == 1 || allTexts.size() == 2)) {
                validTextIDs.add(((STextualDS)allTexts.get(0)).getId());
            }
        } else {
            validTextIDs.add(this.enforcedText.getId());
        }
        Row tokenRow = new Row();
        for (SNode t : tokens) {
            STextualDS tokenText = Helper.getTextualDSForNode(t, graph);
            if (tokenText == null || !validTextIDs.contains(tokenText.getId()) || !this.hasSegmentation(t, this.segmentationName)) continue;
            Range<Integer> coveredRange = Helper.getLeftRightSpan(t, graph, token2index);
            String text = SingleGridComponent.extractTextForToken(t, this.segmentationName);
            GridEvent event = new GridEvent(t.getId(), (Integer)coveredRange.lowerEndpoint(), (Integer)coveredRange.upperEndpoint(), text);
            event.setTextID(tokenText.getId());
            Long match = this.isCoveredTokenMarked() ? this.markCoveredTokens(this.input.getMarkedAndCovered(), t) : this.tokenMatch(t);
            event.setMatch(match);
            tokenRow.addEvent(event);
        }
        return tokenRow;
    }

    private boolean createAnnotationGrid() {
        String resultID = this.input.getId();
        this.grid = new AnnotationGrid(this.mediaController, this.pdfController, resultID);
        this.grid.addStyleName(this.getMainStyle());
        this.grid.addStyleName("corpus-font-force");
        this.grid.setEscapeHTML(Boolean.parseBoolean(this.input.getMappings().getOrDefault("escape_html", "true")));
        LinkedList<Class<? extends SNode>> types = new LinkedList<Class<? extends SNode>>();
        if (this.isShowingSpanAnnotations()) {
            types.add(SSpan.class);
        }
        if (this.isShowingTokenAnnotations()) {
            types.add(SToken.class);
        }
        this.grid.setAnnosWithNamespace(EventExtractor.computeDisplayedNamespace(this.input, types));
        this.layout.addComponent((Component)this.grid);
        SDocumentGraph graph = this.input.getDocument().getDocumentGraph();
        List<SNode> sortedSegmentationNodes = Helper.getSortedSegmentationNodes(this.segmentationName, graph);
        Map<SToken, Integer> token2index = Helper.createToken2IndexMap(graph, this.enforcedText);
        Preconditions.checkArgument((!token2index.isEmpty() ? 1 : 0) != 0, (Object)"Token list must be non-empty");
        LinkedHashMap<String, ArrayList<Row>> rowsByAnnotation = this.computeAnnotationRows(token2index);
        String gridTemplates = this.input.getMappings().getOrDefault("templates", "");
        if (!gridTemplates.equals("")) {
            String[] split;
            for (String s : split = gridTemplates.split("\\|\\|")) {
                String[] unit_split = s.split("==>");
                Set<Map.Entry<String, ArrayList<Row>>> set = rowsByAnnotation.entrySet();
                for (Map.Entry<String, ArrayList<Row>> me : set) {
                    String rowKey = me.getKey();
                    ArrayList<Row> rowValue = me.getValue();
                    for (Row rowValue1 : rowValue) {
                        String rowName;
                        ArrayList<GridEvent> rowEvents = rowValue1.getEvents();
                        if (unit_split[0].indexOf(61) < 0) {
                            rowName = rowKey.split("::")[1];
                            if (!rowName.equals(unit_split[0])) continue;
                            for (GridEvent ev : rowEvents) {
                                String origValue = ev.getValue();
                                String newValue = unit_split[1].replaceAll("%%value%%", origValue);
                                ev.setValue(newValue);
                            }
                            continue;
                        }
                        rowName = rowKey.split("::")[1];
                        String targetRow = unit_split[0].split("=")[0];
                        String targetValue = unit_split[0].split("=")[1].replaceAll("\"", "");
                        if (!rowName.equals(targetRow)) continue;
                        for (GridEvent ev : rowEvents) {
                            String origValue = ev.getValue();
                            if (!origValue.equals(targetValue)) continue;
                            ev.setValue(unit_split[1]);
                        }
                    }
                }
            }
        }
        Row tokenRow = this.computeTokenRow(sortedSegmentationNodes, graph, rowsByAnnotation, token2index);
        String tokenRowCaption = "tok";
        if (this.isHidingToken()) {
            tokenRow.setStyle("invisible_token");
            tokenRowCaption = "";
            this.grid.setTokRowKey("");
        }
        if (this.isTokenFirst()) {
            LinkedHashMap<String, ArrayList<Row>> newList = new LinkedHashMap<String, ArrayList<Row>>();
            newList.put(tokenRowCaption, Lists.newArrayList((Object[])new Row[]{tokenRow}));
            newList.putAll(rowsByAnnotation);
            rowsByAnnotation = newList;
        } else {
            rowsByAnnotation.put(tokenRowCaption, Lists.newArrayList((Object[])new Row[]{tokenRow}));
        }
        EventExtractor.removeEmptySpace(rowsByAnnotation, tokenRow);
        boolean tokenRowIsEmpty = true;
        for (GridEvent tokenEvent : tokenRow.getEvents()) {
            if (tokenEvent.getValue() == null || tokenEvent.getValue().trim().isEmpty()) continue;
            tokenRowIsEmpty = false;
            break;
        }
        if (!this.isHidingToken() && this.canShowEmptyTokenWarning()) {
            this.lblEmptyToken.setVisible(tokenRowIsEmpty);
        }
        this.grid.setRowsByAnnotation(rowsByAnnotation);
        return !tokenRowIsEmpty;
    }

    public AnnotationGrid getGrid() {
        return this.grid;
    }

    public VisualizerInput getInput() {
        return this.input;
    }

    protected String getMainStyle() {
        return "partitur_table";
    }

    private boolean hasSegmentation(SNode node, String segmentation) {
        if (segmentation == null) {
            return node instanceof SToken;
        }
        for (SRelation outRel : node.getOutRelations()) {
            if (!(outRel instanceof SOrderRelation) || !segmentation.equals(outRel.getType())) continue;
            return true;
        }
        for (SRelation inRel : node.getInRelations()) {
            if (!(inRel instanceof SOrderRelation) || !segmentation.equals(inRel.getType())) continue;
            return true;
        }
        return false;
    }

    protected boolean isAddingPlaybackRow() {
        return false;
    }

    protected boolean isCoveredTokenMarked() {
        return false;
    }

    protected boolean isFilteringMediaLayer() {
        return false;
    }

    protected boolean isHidingToken() {
        return Boolean.parseBoolean(this.input.getMappings().getOrDefault("hide_tok", "false"));
    }

    protected boolean isShowingSpanAnnotations() {
        return true;
    }

    protected boolean isShowingTokenAnnotations() {
        return Boolean.parseBoolean(this.input.getMappings().get("tok_anno"));
    }

    protected boolean isTokenFirst() {
        return false;
    }

    private Long markCoveredTokens(Map<SNode, Long> markedAndCovered, SNode tok) {
        SFeature featMatched = tok.getFeature("annis", "matchednode");
        if (markedAndCovered.containsKey(tok) && featMatched == null) {
            return markedAndCovered.get(tok);
        }
        return featMatched != null ? featMatched.getValue_SNUMERIC() : null;
    }

    public boolean setSegmentationLayer(String segmentationName, Map<SNode, Long> markedAndCovered) {
        this.segmentationName = segmentationName;
        this.input.setMarkedAndCovered(markedAndCovered);
        this.layout.removeComponent((Component)this.grid);
        return this.createAnnotationGrid();
    }

    public void setVisibleTokenAnnos(Set<String> annos) {
        this.manuallySelectedTokenAnnos = annos;
        this.layout.removeComponent((Component)this.grid);
        this.createAnnotationGrid();
    }

    private Long tokenMatch(SNode tok) {
        SFeature featMatched = tok.getFeature("annis", "matchednode");
        Long matchRaw = featMatched == null ? null : featMatched.getValue_SNUMERIC();
        return matchRaw;
    }
}

