/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.gridtree;

import com.google.common.collect.Range;
import com.vaadin.ui.Panel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.visualizers.AbstractVisualizer;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.widgets.grid.AnnotationGrid;
import org.corpus_tools.annis.gui.widgets.grid.GridEvent;
import org.corpus_tools.annis.gui.widgets.grid.Row;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.springframework.stereotype.Component;

@Component
public class GridTreeVisualizer
extends AbstractVisualizer {
    private static final long serialVersionUID = 2295569067592940440L;

    public Panel createComponent(VisualizerInput visInput, VisualizationToggle visToggle) {
        return new GridTreePanel(visInput, visToggle);
    }

    @Override
    public String getShortName() {
        return "grid_tree";
    }

    private static class Traverse
    implements GraphTraverseHandler {
        int depth = 0;
        int endIdx;
        int startIdx;
        String annotationKey;
        Map<String, ArrayList<Row>> table;
        Set<SNode> visited = new HashSet<SNode>();
        final Map<SToken, Integer> token2index;

        private Traverse(int startIdx, int endIdx, String nodeKey, String namespace, Map<String, ArrayList<Row>> table, Map<SToken, Integer> token2index) {
            this.startIdx = startIdx;
            this.endIdx = endIdx;
            this.annotationKey = nodeKey;
            this.table = table;
            this.token2index = token2index;
        }

        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE g, String string, SRelation sr, SNode snode, long l) {
            return sr == null || sr instanceof SDominanceRelation;
        }

        private SAnnotation getAnno(SNode n) {
            Set annos = n.getAnnotations();
            if (annos != null) {
                for (SAnnotation a : annos) {
                    if (!this.annotationKey.equals(a.getName())) continue;
                    return a;
                }
            }
            return null;
        }

        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE g, String string, SNode currNode, SRelation edge, SNode fromNode, long l) {
            assert (this.depth >= 0);
            if (this.visited.contains(currNode)) {
                this.visited.remove(currNode);
                --this.depth;
            }
        }

        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE g, String string, SNode currNode, SRelation edge, SNode fromNode, long l) {
            SAnnotation anno = this.getAnno(currNode);
            if (anno != null && currNode != null && currNode.getGraph() instanceof SDocumentGraph) {
                String rIdx = String.valueOf(this.depth);
                if (!this.table.containsKey(rIdx)) {
                    ArrayList<Row> rows = new ArrayList<Row>();
                    rows.add(new Row());
                    this.table.put(rIdx, rows);
                }
                Range<Integer> overlappedSpan = Helper.getLeftRightSpan(currNode, (SDocumentGraph)currNode.getGraph(), this.token2index);
                int leftIdx = Math.max((Integer)overlappedSpan.lowerEndpoint(), this.startIdx);
                int rightIdx = Math.min((Integer)overlappedSpan.upperEndpoint(), this.endIdx);
                GridEvent e = new GridEvent(currNode.getId(), leftIdx, rightIdx, anno.getValue_STEXT());
                SFeature featMatched = currNode.getFeature("annis", "matchednode");
                Long match = featMatched == null ? null : featMatched.getValue_SNUMERIC();
                e.setMatch(match);
                e.setTooltip(anno.getQName() + "=\"" + e.getValue() + "\"");
                this.table.get(rIdx).get(0).addEvent(e);
                this.visited.add(currNode);
                ++this.depth;
            }
        }
    }

    private static class GridTreePanel
    extends Panel {
        private static final long serialVersionUID = 2184038091306427584L;
        private VisualizerInput input;
        private SDocumentGraph graph;

        public GridTreePanel(VisualizerInput visInput, VisualizationToggle visToggle) {
            if (visInput == null) {
                return;
            }
            this.input = visInput;
            this.graph = this.input.getSResult().getDocumentGraph();
            AnnotationGrid grid = new AnnotationGrid(this.input.getId(), this.getTokKey());
            String escapeHTML = visInput.getMappings().getOrDefault("escape_html", "true");
            grid.setEscapeHTML(Boolean.parseBoolean(escapeHTML));
            List roots = this.graph.getRoots();
            TreeMap<String, ArrayList<Row>> table = new TreeMap<String, ArrayList<Row>>();
            Map<SToken, Integer> token2index = Helper.createToken2IndexMap(this.graph, null);
            List sortedToken = this.graph.getSortedTokenByText();
            int startIdx = -1;
            int endIdx = -1;
            if (sortedToken != null && sortedToken.get(0) != null) {
                startIdx = token2index.get(sortedToken.get(0));
                endIdx = token2index.get(sortedToken.get(sortedToken.size() - 1));
            }
            Traverse traverse = new Traverse(startIdx, endIdx, this.getNodeKey(), this.input.getNamespace(), table, token2index);
            this.graph.traverse(roots, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "gridtree", (GraphTraverseHandler)traverse);
            ArrayList<Row> baseRows = this.createBaseRows(token2index);
            table.put(this.getTokKey(), baseRows);
            this.addCoveredIDs(this.getTokKey(), table);
            grid.setRowsByAnnotation(table);
            this.setContent((com.vaadin.ui.Component)grid);
            grid.addStyleName("partitur_table");
            grid.addStyleName("corpus-font-force");
        }

        private void addCoveredIDs(String baseRowIdx, Map<String, ArrayList<Row>> table) {
            if (!table.containsKey(baseRowIdx)) {
                throw new IllegalArgumentException("table index does not exist");
            }
            Row baseRow = table.get(baseRowIdx).get(0);
            for (Map.Entry<String, ArrayList<Row>> e : table.entrySet()) {
                if (e.getKey().equals(baseRowIdx)) continue;
                Row row = table.get(e.getKey()).get(0);
                for (GridEvent event : row.getEvents()) {
                    int leftIdx = event.getLeft();
                    int rightIdx = event.getRight();
                    for (GridEvent baseEvent : baseRow.getEvents()) {
                        if (leftIdx > baseEvent.getLeft() || baseEvent.getRight() > rightIdx) continue;
                        event.getCoveredIDs().add(baseEvent.getId());
                    }
                }
            }
        }

        private ArrayList<Row> createBaseRows(Map<SToken, Integer> token2index) {
            ArrayList<Row> baseRows;
            block3: {
                Row baseRow;
                block2: {
                    baseRows = new ArrayList<Row>();
                    baseRow = new Row();
                    baseRows.add(baseRow);
                    if (!this.getTokKey().equals("tok")) break block2;
                    for (SToken t : this.graph.getSortedTokenByText()) {
                        int idx = token2index.get(t);
                        baseRow.addEvent(new GridEvent(t.getId(), idx, idx, Helper.getSpannedText(t)));
                    }
                    break block3;
                }
                List sSpans = this.graph.getSpans();
                if (sSpans == null) break block3;
                for (SSpan n : sSpans) {
                    if (!this.hasAnno((SNode)n)) continue;
                    Range<Integer> overlappedSpan = Helper.getLeftRightSpan((SNode)n, n.getGraph(), token2index);
                    int leftIdx = (Integer)overlappedSpan.lowerEndpoint();
                    int rightIdx = (Integer)overlappedSpan.upperEndpoint();
                    baseRow.addEvent(new GridEvent(n.getId(), leftIdx, rightIdx, this.getAnnoText((SNode)n)));
                }
            }
            return baseRows;
        }

        private String getAnnoText(SNode n) {
            Set annos = n.getAnnotations();
            if (annos != null) {
                for (SAnnotation a : annos) {
                    if (!this.getTokKey().equals(a.getName())) continue;
                    return a.getValue_STEXT();
                }
            }
            return "";
        }

        private String getNodeKey() {
            return this.input.getMappings().getOrDefault("node_key", "cat");
        }

        private String getTokKey() {
            return this.input.getMappings().getOrDefault("tok_key", "tok");
        }

        private boolean hasAnno(SNode n) {
            Set annos = n.getAnnotations();
            if (annos != null) {
                for (SAnnotation a : annos) {
                    if (!this.getTokKey().equals(a.getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

