/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.pdf;

import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Panel;
import org.corpus_tools.annis.gui.PDFPageHelper;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.media.PDFController;
import org.corpus_tools.annis.gui.media.PDFViewer;
import org.corpus_tools.annis.gui.visualizers.AbstractVisualizer;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.pdf.PDFPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PDFVisualizer
extends AbstractVisualizer {
    private static final long serialVersionUID = -5208334507204533281L;
    private final Logger log = LoggerFactory.getLogger(PDFVisualizer.class);

    public Panel createComponent(VisualizerInput input, VisualizationToggle visToggle) {
        PDFViewerImpl pdfViewer = null;
        try {
            if (VaadinSession.getCurrent().getAttribute(PDFController.class) != null) {
                VaadinSession session = VaadinSession.getCurrent();
                PDFController pdfController = (PDFController)session.getAttribute(PDFController.class);
                pdfViewer = new PDFViewerImpl(input, visToggle);
                pdfController.addPDF(input.getId(), pdfViewer);
            }
        }
        catch (Exception ex) {
            this.log.error("could not create pdf vis", (Throwable)ex);
        }
        return pdfViewer;
    }

    @Override
    public String getShortName() {
        return "pdf";
    }

    private static class PDFViewerImpl
    extends Panel
    implements PDFViewer {
        private static final long serialVersionUID = -2541354371319522012L;
        VisualizerInput input;
        VisualizationToggle visToggle;
        PDFPanel pdfPanel;

        public PDFViewerImpl(VisualizerInput input, VisualizationToggle visToggle) {
            this.visToggle = visToggle;
            this.input = input;
        }

        private void initPDFPanel(String page) {
            if (this.pdfPanel != null) {
                this.pdfPanel = null;
            }
            this.pdfPanel = new PDFPanel(this.input, page);
            this.setContent((com.vaadin.ui.Component)this.pdfPanel);
            this.setHeight(this.input.getMappings().getOrDefault("height", "-1") + "px");
        }

        @Override
        public void openPDFPage(String page) {
            if ("-1".equals(page)) {
                page = new PDFPageHelper(this.input).getMostLeftAndMostRightPageAnno();
            }
            page = page == null ? "-1" : page;
            this.initPDFPanel(page);
            if (!this.isVisible()) {
                this.setVisible(true);
                this.visToggle.toggleVisualizer(true, null);
            }
        }
    }
}

