/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.tree;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.corpus_tools.annis.gui.visualizers.component.tree.NodeStructureData;

public class OrderedNodeList {
    private final double minDistance;
    private final List<NodeStructureData> nodes = new ArrayList<NodeStructureData>();
    private final List<Double> points = new ArrayList<Double>();

    public OrderedNodeList(double minDistance_) {
        this.minDistance = minDistance_;
    }

    public void addVerticalEdgePosition(NodeStructureData structData, Point2D pos) {
        int idx = this.findInsertionIndex(pos.getX());
        this.nodes.add(idx, structData);
        this.points.add(idx, pos.getX());
    }

    public double findBestPosition(NodeStructureData nodeStructureData, double minX, double maxX) {
        double optimalPos = (minX + maxX) / 2.0;
        if (nodeStructureData.isContinuous()) {
            return optimalPos;
        }
        if (this.hasConflict(nodeStructureData, optimalPos)) {
            double lastPos = minX;
            double bestPos = minX + this.minDistance / 2.0;
            double bestDist = 2.147483647E9;
            for (double x : this.findConflicts(nodeStructureData, minX, maxX)) {
                double regionOptimalPos;
                double dist;
                double space = Math.abs(x - lastPos);
                if (space > 2.0 * this.minDistance && (dist = Math.abs((regionOptimalPos = this.nearest(optimalPos, lastPos + this.minDistance, x - this.minDistance)) - optimalPos)) < bestDist) {
                    bestPos = regionOptimalPos;
                    bestDist = dist;
                }
                lastPos = x;
            }
            return bestPos;
        }
        return optimalPos;
    }

    private Collection<Double> findConflicts(NodeStructureData nodeStructureData, double minX, double maxX) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int pos : this.findInRegion(minX, maxX)) {
            if (!nodeStructureData.hasVerticalEdgeConflict(this.nodes.get(pos))) continue;
            result.add(this.points.get(pos));
        }
        result.add(maxX);
        return result;
    }

    private Collection<Integer> findInRegion(double low, double high) {
        int start = this.findInsertionIndex(low);
        int end = this.findInsertionIndex(high);
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = start; i < end; ++i) {
            l.add(i);
        }
        return l;
    }

    private int findInsertionIndex(double pos) {
        int idx = Collections.binarySearch(this.points, pos);
        if (idx < 0) {
            idx = -(idx + 1);
        }
        return idx;
    }

    private boolean hasConflict(NodeStructureData nodeStructureData, double atPos) {
        for (int lower : this.findInRegion(atPos - this.minDistance, atPos + this.minDistance)) {
            if (!nodeStructureData.hasVerticalEdgeConflict(this.nodes.get(lower))) continue;
            return true;
        }
        return false;
    }

    private double nearest(double optimalPos, double min, double max) {
        return Math.max(min, Math.min(max, optimalPos));
    }
}

