/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.tree;

import java.awt.Color;
import java.awt.Stroke;
import org.corpus_tools.annis.gui.visualizers.component.tree.GraphicsBackend;

public interface Shape {
    public Color getFillColor();

    public double getInternalYOffset(String var1, GraphicsBackend.Font var2, GraphicsBackend.Alignment var3);

    public Stroke getPenStyle();

    public Color getStrokeColor();

    public double getXPadding();

    public double getYPadding();

    public static class Rectangle
    extends AbstractShape {
        public Rectangle(Color stroke, Color fill, Stroke penStyle, double padding) {
            super(padding, padding, stroke, fill, penStyle);
        }
    }

    public static class Invisible
    extends AbstractShape {
        public Invisible(double padding) {
            super(padding, padding, null, null, null);
        }
    }

    public static class Ellipse
    extends AbstractShape {
        public Ellipse(Color stroke, Color fill, Stroke penStyle, double padding) {
            super(padding + 4.0, padding, stroke, fill, penStyle);
        }

        @Override
        public double getInternalYOffset(String label, GraphicsBackend.Font font, GraphicsBackend.Alignment alignment) {
            double paddingRatio = super.getYPadding() / super.getXPadding();
            return font.extents(label).getHeight() * alignment.getYAlign() * (1.0 - paddingRatio);
        }
    }

    public static abstract class AbstractShape
    implements Shape {
        private final double xPadding;
        private final double yPadding;
        private final Color stroke;
        private final Color fill;
        private final Stroke penStyle;

        public AbstractShape(double xPadding_, double yPadding_, Color stroke_, Color fill_, Stroke penStyle_) {
            this.xPadding = xPadding_;
            this.yPadding = yPadding_;
            this.stroke = stroke_;
            this.fill = fill_;
            this.penStyle = penStyle_;
        }

        @Override
        public Color getFillColor() {
            return this.fill;
        }

        @Override
        public double getInternalYOffset(String label, GraphicsBackend.Font font, GraphicsBackend.Alignment alignment) {
            return font.extents(label).getHeight() * alignment.getYAlign();
        }

        @Override
        public Stroke getPenStyle() {
            return this.penStyle;
        }

        @Override
        public Color getStrokeColor() {
            return this.stroke;
        }

        @Override
        public double getXPadding() {
            return this.xPadding;
        }

        @Override
        public double getYPadding() {
            return this.yPadding;
        }
    }
}

