/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.tree;

import com.vaadin.ui.Notification;
import edu.uci.ics.jung.graph.DirectedGraph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.corpus_tools.annis.gui.MatchedNodeColors;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.AbstractImageVisualizer;
import org.corpus_tools.annis.gui.visualizers.component.tree.AnnisGraphTools;
import org.corpus_tools.annis.gui.visualizers.component.tree.ConstituentLayouter;
import org.corpus_tools.annis.gui.visualizers.component.tree.GraphicsBackend;
import org.corpus_tools.annis.gui.visualizers.component.tree.LayoutOptions;
import org.corpus_tools.annis.gui.visualizers.component.tree.Shape;
import org.corpus_tools.annis.gui.visualizers.component.tree.TreeElementLabeler;
import org.corpus_tools.annis.gui.visualizers.component.tree.TreeElementStyler;
import org.corpus_tools.annis.gui.visualizers.component.tree.VerticalOrientation;
import org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg.AbstractImageGraphicsItem;
import org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg.Java2dBackend;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class TigerTreeVisualizer
extends AbstractImageVisualizer {
    private static final long serialVersionUID = -6254684499926926147L;
    private static final int SIDE_MARGIN = 20;
    private static final int TOP_MARGIN = 40;
    private static final int TREE_DISTANCE = 40;
    public static final String TERMINAL_NAME_KEY = "terminal_name";
    public static final String TERMINAL_NS_KEY = "terminal_ns";
    private transient Java2dBackend backend;
    private final DefaultLabeler labeler = new DefaultLabeler();
    private transient DefaultStyler styler;
    private AnnisGraphTools graphtools;

    public TigerTreeVisualizer() throws FontFormatException, IOException {
        this.initTransients();
    }

    private Graphics2D createCanvas(BufferedImage image) {
        Graphics2D canvas = (Graphics2D)image.getGraphics();
        canvas.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        canvas.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        canvas.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        return canvas;
    }

    private Java2dBackend getBackend() {
        if (this.backend == null) {
            this.backend = new Java2dBackend();
        }
        return this.backend;
    }

    @Override
    public String getContentType() {
        return "image/png";
    }

    @Override
    public String getShortName() {
        return "tree";
    }

    private void initTransients() throws FontFormatException, IOException {
        this.styler = new DefaultStyler(this.getBackend());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, FontFormatException {
        in.defaultReadObject();
        this.initTransients();
    }

    private void renderTree(AbstractImageGraphicsItem item, Graphics2D canvas) {
        ArrayList<AbstractImageGraphicsItem> allItems = new ArrayList<AbstractImageGraphicsItem>();
        item.getAllChildren(allItems);
        Collections.sort(allItems, (o1, o2) -> o1.getZValue() - o2.getZValue());
        for (AbstractImageGraphicsItem c : allItems) {
            c.draw(canvas);
        }
    }

    @Override
    public void writeOutput(VisualizerInput input, OutputStream outstream) {
        BufferedImage image;
        this.graphtools = new AnnisGraphTools(input);
        LinkedList<AbstractImageGraphicsItem> layouts = new LinkedList<AbstractImageGraphicsItem>();
        double width = 0.0;
        double maxheight = 0.0;
        for (DirectedGraph<SNode, SRelation> g : this.graphtools.getSyntaxGraphs()) {
            if (g.getEdgeCount() <= 0 || g.getVertexCount() <= 0) continue;
            ConstituentLayouter<AbstractImageGraphicsItem> cl = new ConstituentLayouter<AbstractImageGraphicsItem>(g, this.getBackend(), this.labeler, this.styler, input, this.graphtools);
            AbstractImageGraphicsItem item = cl.createLayout(new LayoutOptions(VerticalOrientation.TOP_ROOT, AnnisGraphTools.detectLayoutDirection(input.getDocument().getDocumentGraph(), input.getUI())));
            Rectangle2D treeSize = item.getBounds();
            maxheight = Math.max(maxheight, treeSize.getHeight());
            width += treeSize.getWidth();
            layouts.add(item);
        }
        if (width == 0.0 || maxheight == 0.0) {
            input.getUI().access(() -> Notification.show((String)"Can't generate tree visualization.", (Notification.Type)Notification.Type.WARNING_MESSAGE));
            image = new BufferedImage(1, 1, 2);
        } else {
            image = new BufferedImage((int)(width + (double)((layouts.size() - 1) * 40) + 40.0), (int)(maxheight + 80.0), 2);
            Graphics2D canvas = this.createCanvas(image);
            double xOffset = 20.0;
            for (AbstractImageGraphicsItem item : layouts) {
                AffineTransform t = canvas.getTransform();
                Rectangle2D bounds = item.getBounds();
                canvas.translate(xOffset, 40.0 + maxheight - bounds.getHeight());
                this.renderTree(item, canvas);
                xOffset += bounds.getWidth() + 40.0;
                canvas.setTransform(t);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "png", outstream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class DefaultStyler
    implements TreeElementStyler {
        public static final int LABEL_PADDING = 2;
        public static final int HEIGHT_STEP = 40;
        public static final int TOKEN_SPACING = 15;
        public static final int VEDGE_OVERLAP_THRESHOLD = 20;
        private final BasicStroke DEFAULT_PEN_STYLE = new BasicStroke(1.0f);
        private final Java2dBackend backend;
        private final Font notoSansFontRegular;
        private final Font notoSansFontBold;

        public DefaultStyler(Java2dBackend backend) throws FontFormatException, IOException {
            this.backend = backend;
            File regularFont = File.createTempFile("NotoSans-Regular", ".ttf");
            File boldFont = File.createTempFile("NotoSans-Bold", ".ttf");
            regularFont.deleteOnExit();
            boldFont.deleteOnExit();
            FileUtils.copyToFile((InputStream)new ClassPathResource("NotoSans-Regular.ttf", TigerTreeVisualizer.class).getInputStream(), (File)regularFont);
            FileUtils.copyToFile((InputStream)new ClassPathResource("NotoSans-Bold.ttf", TigerTreeVisualizer.class).getInputStream(), (File)boldFont);
            this.notoSansFontRegular = Font.createFont(0, regularFont.getAbsoluteFile());
            this.notoSansFontBold = Font.createFont(0, boldFont.getAbsoluteFile());
        }

        @Override
        public Color getEdgeColor(SRelation e, VisualizerInput input) {
            if (TigerTreeVisualizer.this.graphtools.hasEdgeSubtype(e, TigerTreeVisualizer.this.graphtools.getSecEdgeSubType())) {
                return new Color(0.5f, 0.5f, 0.8f, 0.7f);
            }
            return new Color(0.3f, 0.3f, 0.3f);
        }

        @Override
        public GraphicsBackend.Font getFont(SNode n, VisualizerInput input) {
            if (AnnisGraphTools.isTerminal(n, input)) {
                return this.backend.getFont(this.notoSansFontRegular, 12, 0);
            }
            return this.backend.getFont(this.notoSansFontBold, 15, 1);
        }

        @Override
        public GraphicsBackend.Font getFont(SRelation e) {
            return this.backend.getFont(this.notoSansFontRegular, 10, 0);
        }

        @Override
        public int getHeightStep() {
            return 40;
        }

        @Override
        public int getLabelPadding() {
            return 2;
        }

        @Override
        public Shape getShape(SNode n, VisualizerInput input) {
            SFeature featMatch = n.getFeature("annis", "matchednode");
            if (featMatch != null) {
                Color backColor;
                int matchIdx = featMatch.getValue_SNUMERIC().intValue() - 1;
                MatchedNodeColors[] allColors = MatchedNodeColors.values();
                Color color = backColor = matchIdx >= 0 && matchIdx < allColors.length ? allColors[matchIdx].getColor() : Color.RED;
                if (AnnisGraphTools.isTerminal(n, input)) {
                    return new Shape.Rectangle(Color.WHITE, backColor, this.DEFAULT_PEN_STYLE, this.getLabelPadding());
                }
                return new Shape.Ellipse(Color.WHITE, backColor, this.DEFAULT_PEN_STYLE, this.getLabelPadding());
            }
            if (AnnisGraphTools.isTerminal(n, input)) {
                return new Shape.Invisible(this.getLabelPadding());
            }
            return new Shape.Ellipse(Color.BLACK, Color.WHITE, this.DEFAULT_PEN_STYLE, this.getLabelPadding());
        }

        @Override
        public Shape getShape(SRelation e, VisualizerInput input) {
            if (TigerTreeVisualizer.this.graphtools.hasEdgeSubtype(e, TigerTreeVisualizer.this.graphtools.getSecEdgeSubType())) {
                return new Shape.Rectangle(this.getEdgeColor(e, input), Color.WHITE, this.DEFAULT_PEN_STYLE, this.getLabelPadding());
            }
            return new Shape.Rectangle(new Color(0.4f, 0.4f, 0.4f), Color.WHITE, this.DEFAULT_PEN_STYLE, this.getLabelPadding());
        }

        @Override
        public Stroke getStroke(SRelation e, VisualizerInput input) {
            if (TigerTreeVisualizer.this.graphtools.hasEdgeSubtype(e, TigerTreeVisualizer.this.graphtools.getSecEdgeSubType())) {
                return new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
            }
            return new BasicStroke(2.0f);
        }

        @Override
        public Color getTextBrush(SNode n, VisualizerInput input) {
            SFeature featMatch = n.getFeature("annis", "matchednode");
            if (featMatch != null) {
                return Color.WHITE;
            }
            return Color.BLACK;
        }

        @Override
        public Color getTextBrush(SRelation n) {
            return Color.BLACK;
        }

        @Override
        public int getTokenSpacing() {
            return 15;
        }

        @Override
        public int getVEdgeOverlapThreshold() {
            return 20;
        }
    }

    private static class DefaultLabeler
    implements TreeElementLabeler,
    Serializable {
        private static final long serialVersionUID = 1302584248978638957L;

        private DefaultLabeler() {
        }

        private String extractAnnotation(Set<SAnnotation> annotations, String namespace, String featureName) {
            String result = AnnisGraphTools.extractAnnotation(annotations, namespace, featureName);
            if (result == null) {
                result = "--";
            }
            return result;
        }

        @Override
        public String getLabel(SNode n, VisualizerInput input) {
            if (AnnisGraphTools.isTerminal(n, input)) {
                String terminalName = input.getMappings().get(TigerTreeVisualizer.TERMINAL_NAME_KEY);
                if (terminalName == null) {
                    String spannedText = ((SDocumentGraph)n.getGraph()).getText(n);
                    if (spannedText == null || "".equals(spannedText)) {
                        spannedText = " ";
                    }
                    return spannedText;
                }
                String terminalNamespace = input.getMappings().get(TigerTreeVisualizer.TERMINAL_NS_KEY);
                return this.extractAnnotation(n.getAnnotations(), terminalNamespace, terminalName);
            }
            return this.extractAnnotation(n.getAnnotations(), input.getMappings().getOrDefault("node_anno_ns", input.getNamespace()), input.getMappings().getOrDefault("node_key", "cat"));
        }

        @Override
        public String getLabel(SRelation e, VisualizerInput input) {
            return this.extractAnnotation(e.getAnnotations(), input.getMappings().getOrDefault("edge_anno_ns", input.getNamespace()), input.getMappings().getOrDefault("edge_key", "func"));
        }
    }
}

