/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.corpus_tools.annis.gui.visualizers.component.tree.GraphicsBackend;
import org.corpus_tools.annis.gui.visualizers.component.tree.Shape;
import org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg.AbstractImageGraphicsItem;
import org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg.GraphicsItemGroup;
import org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg.LabelItem;

public class Java2dBackend
implements GraphicsBackend<AbstractImageGraphicsItem> {
    public static final FontRenderContext FRC = new FontRenderContext(new AffineTransform(), true, true);

    @Override
    public AbstractImageGraphicsItem arrow(final Point2D tip, Point2D fromPoint, Rectangle2D dimensions, final Color color) {
        final GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(dimensions.getHeight(), dimensions.getWidth() / 2.0);
        path.lineTo(dimensions.getHeight(), -dimensions.getWidth() / 2.0);
        path.closePath();
        final double angle = this.getRotationAngle(tip, fromPoint);
        return new AbstractImageGraphicsItem(){

            @Override
            public void draw(Graphics2D canvas) {
                AffineTransform t = canvas.getTransform();
                canvas.setColor(color);
                canvas.translate(tip.getX(), tip.getY());
                canvas.rotate(angle);
                canvas.fill(path);
                canvas.setTransform(t);
            }

            @Override
            public Rectangle2D getBounds() {
                return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            }
        };
    }

    @Override
    public AbstractImageGraphicsItem cubicCurve(final CubicCurve2D curveData, final Stroke strokeStyle, final Color color) {
        return new AbstractImageGraphicsItem(){

            @Override
            public void draw(Graphics2D canvas) {
                canvas.setStroke(strokeStyle);
                canvas.setColor(color);
                canvas.draw(curveData);
            }

            @Override
            public Rectangle2D getBounds() {
                return curveData.getBounds2D();
            }
        };
    }

    @Override
    public GraphicsBackend.Font getFont(Font original, int pointSize, int style) {
        return new Java2dFont(original, pointSize, style);
    }

    private double getRotationAngle(Point2D origin, Point2D target) {
        double l = Math.hypot(origin.getX() - target.getX(), origin.getY() - target.getY());
        double x = Math.acos((origin.getX() - target.getX()) * Math.signum(origin.getX() - target.getX()) / l);
        if (origin.getX() > target.getX()) {
            if (origin.getY() < target.getY()) {
                x = -x;
            }
            x += Math.PI;
        } else if (origin.getY() > target.getY()) {
            x = -x;
        }
        return x;
    }

    @Override
    public AbstractImageGraphicsItem group() {
        return new GraphicsItemGroup();
    }

    @Override
    public AbstractImageGraphicsItem makeLabel(String label, Point2D pos, GraphicsBackend.Font font, Color color, GraphicsBackend.Alignment alignment, Shape shape) {
        return new LabelItem(label, pos, (Java2dFont)font, color, alignment, shape);
    }

    @Override
    public AbstractImageGraphicsItem makeLines(final Collection<Line2D> lines, final Color color, final Stroke stroke) {
        return new AbstractImageGraphicsItem(){

            @Override
            public void draw(Graphics2D canvas) {
                canvas.setColor(color);
                canvas.setStroke(stroke);
                for (Line2D l : lines) {
                    canvas.draw(l);
                }
            }

            @Override
            public Rectangle2D getBounds() {
                return null;
            }
        };
    }

    public static class Java2dFont
    implements GraphicsBackend.Font {
        private final Font awtFont;

        public Java2dFont(Font original, int pointSize, int style) {
            this.awtFont = original.deriveFont(style, pointSize);
        }

        @Override
        public Rectangle2D extents(String string) {
            if (string.isEmpty()) {
                return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            }
            TextLayout tl = new TextLayout(string, this.awtFont, FRC);
            return tl.getBounds();
        }

        @Override
        public double getAscent() {
            return this.lineMetrics().getAscent();
        }

        public Font getAwtFont() {
            return this.awtFont;
        }

        @Override
        public double getLineHeight() {
            return this.lineMetrics().getHeight();
        }

        private LineMetrics lineMetrics() {
            return this.awtFont.getLineMetrics("Xg\u00dc", FRC);
        }
    }
}

