/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.htmlvis;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.visualizers.htmlvis.AnnotationNameAndValueMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.AnnotationNameMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.AnnotationValueMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.PseudoRegionMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.SpanHTMLOutputter;
import org.corpus_tools.annis.gui.visualizers.htmlvis.SpanMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.TokenMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.VisParserException;
import org.corpus_tools.annis.gui.visualizers.htmlvis.VisualizationDefinition;
import org.corpus_tools.annis.visualizers.htmlvis.HTMLVisConfigBaseListener;
import org.corpus_tools.annis.visualizers.htmlvis.HTMLVisConfigLexer;
import org.corpus_tools.annis.visualizers.htmlvis.HTMLVisConfigParser;

public class VisParser
extends HTMLVisConfigBaseListener {
    private List<VisualizationDefinition> definitions = new LinkedList<VisualizationDefinition>();
    private SpanMatcher currentMatcher;
    private SpanHTMLOutputter currentOutputter;

    public VisParser(InputStream inStream) throws IOException, VisParserException {
        HTMLVisConfigLexer lexer = new HTMLVisConfigLexer((CharStream)new ANTLRInputStream(inStream));
        HTMLVisConfigParser parser = new HTMLVisConfigParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        final LinkedList errors = new LinkedList();
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                errors.add("line " + line + ":" + charPositionInLine + " " + msg);
            }
        });
        HTMLVisConfigParser.StartContext tree = parser.start();
        if (!errors.isEmpty()) {
            throw new VisParserException("Parser error:\n" + StringUtils.join(errors, (String)"\n"));
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)this, (ParseTree)tree);
    }

    @Override
    public void enterConditionAll(HTMLVisConfigParser.ConditionAllContext ctx) {
        this.currentMatcher = new PseudoRegionMatcher(PseudoRegionMatcher.PseudoRegion.ALL);
    }

    @Override
    public void enterConditionBegin(HTMLVisConfigParser.ConditionBeginContext ctx) {
        this.currentMatcher = new PseudoRegionMatcher(PseudoRegionMatcher.PseudoRegion.BEGIN);
    }

    @Override
    public void enterConditionEnd(HTMLVisConfigParser.ConditionEndContext ctx) {
        this.currentMatcher = new PseudoRegionMatcher(PseudoRegionMatcher.PseudoRegion.END);
    }

    @Override
    public void enterConditionName(HTMLVisConfigParser.ConditionNameContext ctx) {
        String namespace = null;
        if (ctx.qName().namespace != null) {
            namespace = ctx.qName().namespace.getText();
        }
        this.currentMatcher = new AnnotationNameMatcher(namespace, ctx.qName().name.getText());
    }

    @Override
    public void enterConditionNameAndValue(HTMLVisConfigParser.ConditionNameAndValueContext ctx) {
        String namespace = null;
        if (ctx.qName().namespace != null) {
            namespace = ctx.qName().namespace.getText();
        }
        this.currentMatcher = new AnnotationNameAndValueMatcher(namespace, ctx.qName().name.getText(), ctx.value().innervalue().getText());
    }

    @Override
    public void enterConditionTok(HTMLVisConfigParser.ConditionTokContext ctx) {
        this.currentMatcher = new TokenMatcher();
    }

    @Override
    public void enterConditionValue(HTMLVisConfigParser.ConditionValueContext ctx) {
        this.currentMatcher = new AnnotationValueMatcher(ctx.value().innervalue().getText());
    }

    @Override
    public void enterElementNoStyle(HTMLVisConfigParser.ElementNoStyleContext ctx) {
        this.currentOutputter.setElement(ctx.ID().getText());
        this.currentOutputter.setStyle("");
    }

    @Override
    public void enterElementNoStyleAttribute(HTMLVisConfigParser.ElementNoStyleAttributeContext ctx) {
        this.currentOutputter.setElement(ctx.ID(0).getText());
        this.currentOutputter.setStyle("");
        this.currentOutputter.setAttribute(ctx.ID(1).getText());
    }

    @Override
    public void enterElementWithStyle(HTMLVisConfigParser.ElementWithStyleContext ctx) {
        this.currentOutputter.setElement(ctx.ID().getText());
        this.currentOutputter.setStyle(ctx.value().innervalue().getText());
    }

    @Override
    public void enterElementWithStyleAttribute(HTMLVisConfigParser.ElementWithStyleAttributeContext ctx) {
        this.currentOutputter.setElement(ctx.ID(0).getText());
        this.currentOutputter.setStyle(ctx.value().innervalue().getText());
        this.currentOutputter.setAttribute(ctx.ID(1).getText());
    }

    @Override
    public void enterTypeAnno(HTMLVisConfigParser.TypeAnnoContext ctx) {
        this.currentOutputter.setType(SpanHTMLOutputter.Type.ANNO_NAME);
    }

    @Override
    public void enterTypeConstant(HTMLVisConfigParser.TypeConstantContext ctx) {
        this.currentOutputter.setType(SpanHTMLOutputter.Type.CONSTANT);
        this.currentOutputter.setConstant(ctx.innertype().getText());
    }

    @Override
    public void enterTypeEscapedValue(HTMLVisConfigParser.TypeEscapedValueContext ctx) {
        this.currentOutputter.setType(SpanHTMLOutputter.Type.ESCAPED_VALUE);
    }

    @Override
    public void enterTypeHtmlTemp(HTMLVisConfigParser.TypeHtmlTempContext ctx) {
        this.currentOutputter.setType(SpanHTMLOutputter.Type.HTML_TEMPLATE);
        this.currentOutputter.setConstant(ctx.innerhtmltemp().getText());
    }

    @Override
    public void enterTypeMeta(HTMLVisConfigParser.TypeMetaContext ctx) {
        this.currentOutputter.setType(SpanHTMLOutputter.Type.META_NAME);
        this.currentOutputter.setMetaname(ctx.innermeta().getText().trim());
    }

    @Override
    public void enterTypeValue(HTMLVisConfigParser.TypeValueContext ctx) {
        this.currentOutputter.setType(SpanHTMLOutputter.Type.VALUE);
    }

    @Override
    public void enterVis(HTMLVisConfigParser.VisContext ctx) {
        this.currentMatcher = null;
        this.currentOutputter = new SpanHTMLOutputter();
        this.currentOutputter.setType(SpanHTMLOutputter.Type.EMPTY);
        this.currentOutputter.setElement("div");
    }

    @Override
    public void exitVis(HTMLVisConfigParser.VisContext ctx) {
        if (this.currentMatcher != null && this.currentOutputter != null) {
            VisualizationDefinition def = new VisualizationDefinition();
            def.setMatcher(this.currentMatcher);
            def.setOutputter(this.currentOutputter);
            this.definitions.add(def);
        }
    }

    public VisualizationDefinition[] getDefinitions() {
        return this.definitions.toArray(new VisualizationDefinition[this.definitions.size()]);
    }
}

