/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.iframe;

import com.hp.gagawa.java.DocumentType;
import com.hp.gagawa.java.Node;
import com.hp.gagawa.java.elements.Body;
import com.hp.gagawa.java.elements.Doctype;
import com.hp.gagawa.java.elements.Head;
import com.hp.gagawa.java.elements.Html;
import com.hp.gagawa.java.elements.Link;
import com.hp.gagawa.java.elements.Script;
import com.hp.gagawa.java.elements.Table;
import com.hp.gagawa.java.elements.Td;
import com.hp.gagawa.java.elements.Text;
import com.hp.gagawa.java.elements.Tr;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.MatchedNodeColors;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.iframe.WriterVisualizer;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CorefVisualizer
extends WriterVisualizer {
    private static final long serialVersionUID = 7651955495320624660L;
    private static final Logger log = LoggerFactory.getLogger(CorefVisualizer.class);
    long globalIndex;
    List<TReferent> referentList;
    List<TComponent> komponent;
    HashMap<String, List<Long>> componentOfToken;
    HashMap<String, List<String>> tokensOfNode;
    HashMap<String, HashMap<Long, Integer>> referentOfToken;
    List<String> visitedNodes;
    LinkedList<TComponenttype> componenttype;
    private HashMap<Integer, Integer> colorlist;

    private static String componentNameForRelation(SRelation rel) {
        return rel.getType() != null && !rel.getType().isEmpty() ? rel.getType() : null;
    }

    private void addEmptyLines(Table parentTable, int numberOfLines) {
        for (int i = 0; i < numberOfLines; ++i) {
            Tr trSpace = new Tr();
            parentTable.appendChild((Node)trSpace);
            Td tdSpace = new Td();
            trSpace.appendChild((Node)tdSpace);
            trSpace.setCSSClass("line");
        }
    }

    private boolean connectionOf(String pre, String now, long currentComponent) {
        LinkedList<Long> prel = new LinkedList<Long>();
        LinkedList<Long> nowl = new LinkedList<Long>();
        if (!pre.equals(now) && this.referentOfToken.get(pre) != null && this.referentOfToken.get(now) != null) {
            for (long l : this.referentOfToken.get(pre).keySet()) {
                if (this.referentList.get((int)l) == null || this.referentList.get((int)l).component != currentComponent || !this.referentOfToken.get(pre).get(l).equals(0)) continue;
                prel.add(l);
            }
            for (long l : this.referentOfToken.get(now).keySet()) {
                if (this.referentList.get((int)l) == null || this.referentList.get((int)l).component != currentComponent || !this.referentOfToken.get(now).get(l).equals(0)) continue;
                nowl.add(l);
            }
            for (long l : nowl) {
                if (!prel.contains(l)) continue;
                return true;
            }
        }
        prel = new LinkedList();
        nowl = new LinkedList();
        if (!pre.equals(now) && this.referentOfToken.get(pre) != null && this.referentOfToken.get(now) != null) {
            for (long l : this.referentOfToken.get(pre).keySet()) {
                if (this.referentList.get((int)l) == null || this.referentList.get((int)l).component != currentComponent || !this.referentOfToken.get(pre).get(l).equals(1)) continue;
                prel.add(l);
            }
            for (long l : this.referentOfToken.get(now).keySet()) {
                if (this.referentList.get((int)l) == null || this.referentList.get((int)l).component != currentComponent || !this.referentOfToken.get(now).get(l).equals(1)) continue;
                nowl.add(l);
            }
            for (long l : nowl) {
                if (!prel.contains(l)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getAllTokens(SStructuredNode n, String name, TComponenttype c, long cnr, String namespace) {
        List<Object> result = null;
        if (!this.visitedNodes.contains(n.getId())) {
            List list;
            List outEdges;
            result = new LinkedList();
            this.visitedNodes.add(n.getId());
            if (this.tokensOfNode.containsKey(n.getId())) {
                for (String string : this.tokensOfNode.get(n.getId())) {
                    result.add(string);
                    if (this.componentOfToken.get(string) == null) {
                        LinkedList<Long> newlist = new LinkedList<Long>();
                        newlist.add(cnr);
                        this.componentOfToken.put(string, newlist);
                        continue;
                    }
                    if (this.componentOfToken.get(string).contains(cnr)) continue;
                    this.componentOfToken.get(string).add(cnr);
                }
            } else {
                result = this.searchTokens((SNode)n, cnr);
                if (result != null) {
                    this.tokensOfNode.put(n.getId(), result);
                }
            }
            if ((outEdges = n.getGraph().getOutRelations(n.getId())) != null) {
                for (SRelation e : outEdges) {
                    SPointingRelation rel;
                    if (!this.includeEdge((SRelation<? extends SNode, ? extends SNode>)e, namespace) || !name.equals(CorefVisualizer.componentNameForRelation((SRelation)(rel = (SPointingRelation)e))) || this.visitedNodes.contains(((SStructuredNode)rel.getTarget()).getId())) continue;
                    c.nodeList.add(((SStructuredNode)rel.getTarget()).getId());
                    List<String> Med = this.getAllTokens((SStructuredNode)rel.getTarget(), name, c, cnr, namespace);
                    for (String l : Med) {
                        if (result == null || result.contains(l)) continue;
                        result.add(l);
                    }
                }
            }
            if ((list = n.getGraph().getInRelations(n.getId())) != null) {
                for (SRelation e : list) {
                    SPointingRelation rel;
                    if (!this.includeEdge((SRelation<? extends SNode, ? extends SNode>)e, namespace) || !name.equals(CorefVisualizer.componentNameForRelation((SRelation)(rel = (SPointingRelation)e))) || this.visitedNodes.contains(((SStructuredNode)rel.getSource()).getId())) continue;
                    c.nodeList.add(((SStructuredNode)rel.getSource()).getId());
                    List<String> Med = this.getAllTokens((SStructuredNode)rel.getSource(), name, c, cnr, namespace);
                    for (String s : Med) {
                        if (result == null || result.contains(s)) continue;
                        result.add(s);
                    }
                }
            }
        }
        return result;
    }

    private String getAnnotations(String id, long component) {
        String result = "";
        String incoming = "";
        String outgoing = "";
        int nri = 1;
        int nro = 1;
        if (this.referentOfToken.get(id) != null) {
            for (long l : this.referentOfToken.get(id).keySet()) {
                if (this.referentList.get((int)l) == null || this.referentList.get((int)l).component != component || this.referentList.get((int)l).annotations == null || this.referentList.get((int)l).annotations.size() <= 0) continue;
                int num = this.referentOfToken.get(id).get(l);
                if (num == 0 || num == 2) {
                    for (SerializableAnnotation an : this.referentList.get((int)l).annotations) {
                        if (nri == 1) {
                            incoming = ", &lt;b&gt;incoming Annotations&lt;/b&gt;: " + an.getName() + "=" + an.getValue();
                            --nri;
                            continue;
                        }
                        incoming = incoming + ", " + an.getName() + "=" + an.getValue();
                    }
                }
                if (num != 1 && num != 2) continue;
                for (SerializableAnnotation an : this.referentList.get((int)l).annotations) {
                    if (nro == 1) {
                        outgoing = ", &lt;b&gt;outgoing Annotations&lt;/b&gt;: " + an.getName() + "=" + an.getValue();
                        --nro;
                        continue;
                    }
                    outgoing = outgoing + ", " + an.getName() + "=" + an.getValue();
                }
            }
        }
        if (nro < 1) {
            result = result + outgoing;
        }
        if (nri < 1) {
            result = result + incoming;
        }
        return result;
    }

    private int getNewColor(int i) {
        int r = i * 224 % 255;
        int b = (i + 23) * 74353 % 255;
        int g = (i + 197) * 1034345 % 255;
        if ((r + b + g) / 3 < 100) {
            r = 255 - r;
            g = 255 - g;
            b = 255 - b;
        } else if ((r + b + g) / 3 > 192) {
            r = 1 * (r / 2);
            g = 1 * (g / 2);
            b = 1 * (b / 2);
        }
        if (r == 255 && g == 255 && b == 255) {
            r = 255;
            g = 255;
            b = 0;
        }
        return r * 65536 + g * 256 + b;
    }

    @Override
    public String getShortName() {
        return "discourse";
    }

    private boolean includeEdge(SRelation<? extends SNode, ? extends SNode> e, String namespace) {
        SPointingRelation rel;
        return e instanceof SPointingRelation && CorefVisualizer.componentNameForRelation((SRelation)(rel = (SPointingRelation)e)) != null && rel.getSource() != null && rel.getTarget() != null && rel.getLayers() != null && !rel.getLayers().isEmpty() && namespace.equals(((SLayer)rel.getLayers().iterator().next()).getName());
    }

    @Override
    public boolean isUsingText() {
        return true;
    }

    private List<Node> outputSingleText(List<SToken> token, VisualizerInput input) throws IOException {
        LinkedList<Node> result = new LinkedList<Node>();
        List<Long> finalpositions = null;
        int maxlinkcount = 0;
        String currentId = null;
        for (SToken tok : token) {
            List<Long> prevpositions = finalpositions;
            if (prevpositions != null && prevpositions.size() < 1) {
                prevpositions = null;
            }
            String lastId = currentId;
            currentId = tok.getId();
            List<Long> listpositions = this.componentOfToken.get(currentId);
            LinkedList<Boolean> checklist = null;
            if (prevpositions == null && listpositions != null) {
                finalpositions = listpositions;
            } else if (listpositions == null) {
                finalpositions = new LinkedList<Long>();
            } else {
                checklist = new LinkedList<Boolean>();
                for (int i = 0; prevpositions != null && i < prevpositions.size(); ++i) {
                    if (listpositions.contains(prevpositions.get(i))) {
                        checklist.add(true);
                        continue;
                    }
                    checklist.add(false);
                }
                LinkedList<Long> remains = new LinkedList<Long>();
                for (int i = 0; i < listpositions.size(); ++i) {
                    if (prevpositions == null || prevpositions.contains(listpositions.get(i))) continue;
                    remains.add(listpositions.get(i));
                }
                int minsize = checklist.size() + remains.size();
                int number = 0;
                finalpositions = new LinkedList<Long>();
                for (int i = 0; i < minsize; ++i) {
                    if (prevpositions != null && checklist.size() > i && ((Boolean)checklist.get(i)).booleanValue()) {
                        finalpositions.add(prevpositions.get(i));
                        continue;
                    }
                    if (remains.size() > number) {
                        Long ll = (Long)remains.get(number);
                        finalpositions.add(ll);
                        ++number;
                        --minsize;
                        continue;
                    }
                    finalpositions.add(Long.MIN_VALUE);
                }
            }
            String onclick = "";
            String style = "";
            if (input.getMarkedAndCovered().containsKey(tok)) {
                MatchedNodeColors[] vals = MatchedNodeColors.values();
                long match = Math.min(input.getMarkedAndCovered().get(tok) - 1L, (long)vals.length - 1L);
                style = style + "color: " + vals[(int)match].getHTMLColor() + ";";
            }
            boolean underline = false;
            if (!finalpositions.isEmpty()) {
                style = style + "cursor:pointer;";
                underline = true;
                onclick = "togglePRAuto(this);";
            }
            Table tableSingleTok = new Table();
            result.add((Node)tableSingleTok);
            tableSingleTok.setCSSClass("token");
            int currentlinkcount = 0;
            if (underline) {
                boolean firstone = true;
                int index = -1;
                if (!finalpositions.isEmpty()) {
                    for (Long currentPositionComponent : finalpositions) {
                        int color;
                        String tooltip;
                        ++index;
                        String left = "";
                        String right = "";
                        TComponent currentWriteComponent = null;
                        String currentType = "";
                        if (!currentPositionComponent.equals(Long.MIN_VALUE) && (long)this.komponent.size() > currentPositionComponent) {
                            currentWriteComponent = this.komponent.get((int)currentPositionComponent.longValue());
                            List pi = currentWriteComponent.tokenList;
                            LinkedList<String> preparedPi = new LinkedList<String>();
                            for (String s : pi) {
                                preparedPi.add(this.prepareID(s));
                            }
                            currentType = currentWriteComponent.type;
                            left = StringUtils.join(preparedPi, (String)",");
                            right = "" + currentPositionComponent + 1;
                        }
                        String annotations = this.getAnnotations(tok.getId(), currentPositionComponent);
                        if (firstone) {
                            firstone = false;
                            if (currentWriteComponent == null) {
                                String left2 = "";
                                String right2 = "";
                                long pr = 0L;
                                String currentType2 = "";
                                String annotations2 = "";
                                for (Long currentPositionComponent2 : finalpositions) {
                                    if (currentPositionComponent2.equals(Long.MIN_VALUE) || (long)this.komponent.size() <= currentPositionComponent2) continue;
                                    TComponent currentWriteComponent2 = this.komponent.get((int)currentPositionComponent2.longValue());
                                    List pi2 = currentWriteComponent2.tokenList;
                                    LinkedList<String> preparedPi2 = new LinkedList<String>();
                                    for (String s : pi2) {
                                        preparedPi2.add(this.prepareID(s));
                                    }
                                    currentType2 = currentWriteComponent2.type;
                                    left2 = StringUtils.join(preparedPi2, (String)",");
                                    right2 = "" + currentPositionComponent2 + 1;
                                    annotations2 = this.getAnnotations(tok.getId(), currentPositionComponent2);
                                    pr = currentPositionComponent2;
                                    break;
                                }
                                tooltip = "&lt;b&gt;Component&lt;/b&gt;: " + (pr + 1L) + ", &lt;b&gt;Type&lt;/b&gt;: " + currentType2 + annotations2;
                                Tr trTok = new Tr();
                                tableSingleTok.appendChild((Node)trTok);
                                Td tdTok = new Td();
                                trTok.appendChild((Node)tdTok);
                                tdTok.setId("tok_" + this.prepareID(tok.getId()));
                                tdTok.setTitle(tooltip);
                                tdTok.setStyle(style);
                                tdTok.setAttribute("onclick", onclick);
                                tdTok.setAttribute("annis:pr_left", left2);
                                tdTok.setAttribute("annis:pr_right", right2);
                                Text textTok = new Text("&nbsp;" + Helper.getSpannedText(tok) + "&nbsp;");
                                tdTok.appendChild((Node)textTok);
                            } else {
                                tooltip = "&lt;b&gt;Component&lt;/b&gt;: " + (currentPositionComponent + 1L) + ", &lt;b&gt;Type&lt;/b&gt; " + currentType + annotations;
                                Tr trTok = new Tr();
                                tableSingleTok.appendChild((Node)trTok);
                                Td tdTok = new Td();
                                trTok.appendChild((Node)tdTok);
                                tdTok.setId("tok_" + this.prepareID(tok.getId()));
                                tdTok.setTitle(tooltip);
                                tdTok.setStyle(style);
                                tdTok.setAttribute("onclick", onclick);
                                tdTok.setAttribute("annis:pr_left", left);
                                tdTok.setAttribute("annis:pr_right", right);
                                Text textTok = new Text("&nbsp;" + Helper.getSpannedText(tok) + "&nbsp;");
                                tdTok.appendChild((Node)textTok);
                            }
                        }
                        ++currentlinkcount;
                        if (currentPositionComponent.equals(Long.MIN_VALUE)) {
                            Tr trBlank = new Tr();
                            tableSingleTok.appendChild((Node)trBlank);
                            Td tdBlank = new Td();
                            trBlank.appendChild((Node)tdBlank);
                            trBlank.setCSSClass("line");
                            continue;
                        }
                        if (this.colorlist.containsKey((int)currentPositionComponent.longValue())) {
                            color = this.colorlist.get((int)currentPositionComponent.longValue());
                        } else {
                            color = this.getNewColor((int)currentPositionComponent.longValue());
                            this.colorlist.put((int)currentPositionComponent.longValue(), color);
                        }
                        if (color > 0xFFFFFF) {
                            color = 0xFFFFFF;
                        }
                        String addition = ";border-style: solid; border-width: 0px 0px 0px 2px; border-color: white ";
                        if (lastId != null && currentId != null && checklist != null && checklist.size() > index && ((Boolean)checklist.get(index)).booleanValue() && this.connectionOf(lastId, currentId, currentPositionComponent)) {
                            addition = "";
                        }
                        tooltip = "&lt;b&gt;Component&lt;/b&gt;: " + (currentPositionComponent + 1L) + ", &lt;b&gt;Type&lt;/b&gt;: " + currentType + annotations;
                        Tr trLineContainer = new Tr();
                        tableSingleTok.appendChild((Node)trLineContainer);
                        Td tdLineContainer = new Td();
                        trLineContainer.appendChild((Node)tdLineContainer);
                        Table tableLineContainer = new Table();
                        tdLineContainer.appendChild((Node)tableLineContainer);
                        trLineContainer.setCSSClass("line");
                        tableLineContainer.setCSSClass("linecontainer");
                        Tr trLine = new Tr();
                        tableLineContainer.appendChild((Node)trLine);
                        Td tdLine = new Td();
                        trLine.appendChild((Node)tdLine);
                        tdLine.setCSSClass("clickableline");
                        tdLine.setStyle("background-color: #" + Integer.toHexString(color) + "; " + style + addition);
                        tdLine.setAttribute("onclick", onclick);
                        tdLine.setAttribute("annis:pr_left", left);
                        tdLine.setAttribute("annis:pr_right", right);
                        tdLine.setTitle(tooltip);
                        Tr trSpace = new Tr();
                        tableLineContainer.appendChild((Node)trSpace);
                        Td tdSpace = new Td();
                        trSpace.appendChild((Node)tdSpace);
                        tdSpace.setCSSClass("space");
                    }
                }
                if (currentlinkcount > maxlinkcount) {
                    maxlinkcount = currentlinkcount;
                    continue;
                }
                if (currentlinkcount >= maxlinkcount) continue;
                this.addEmptyLines(tableSingleTok, maxlinkcount - currentlinkcount);
                continue;
            }
            Tr trTok = new Tr();
            tableSingleTok.appendChild((Node)trTok);
            Td tdTok = new Td();
            trTok.appendChild((Node)tdTok);
            tdTok.setId("tok_" + this.prepareID(tok.getId()));
            tdTok.setStyle(style);
            Text textTok = new Text("&nbsp;" + Helper.getSpannedText(tok) + "&nbsp;");
            tdTok.appendChild((Node)textTok);
            if (maxlinkcount <= 0) continue;
            this.addEmptyLines(tableSingleTok, maxlinkcount);
        }
        return result;
    }

    private String prepareID(String orig) {
        return DigestUtils.md5Hex((String)orig);
    }

    private List<String> searchTokens(SNode n, long cnr) {
        LinkedList<String> result;
        block5: {
            block3: {
                block4: {
                    result = new LinkedList<String>();
                    if (!(n instanceof SToken)) break block3;
                    result.add(n.getId());
                    if (this.componentOfToken.get(n.getId()) != null) break block4;
                    LinkedList<Long> newlist = new LinkedList<Long>();
                    newlist.add(cnr);
                    this.componentOfToken.put(n.getId(), newlist);
                    break block5;
                }
                List<Long> newlist = this.componentOfToken.get(n.getId());
                if (newlist.contains(cnr)) break block5;
                newlist.add(cnr);
                break block5;
            }
            List outgoing = n.getGraph().getOutRelations(n.getId());
            if (outgoing != null) {
                for (SRelation e : outgoing) {
                    if (e instanceof SPointingRelation || !(e.getSource() instanceof SNode) || !(e.getTarget() instanceof SNode)) continue;
                    List<String> Med = this.searchTokens((SNode)e.getTarget(), cnr);
                    for (String s : Med) {
                        if (result.contains(s)) continue;
                        result.add(s);
                    }
                }
            }
        }
        return result;
    }

    private void setReferent(SNode n, long index, int value) {
        if (n instanceof SToken) {
            SToken tok = (SToken)n;
            if (!this.referentOfToken.containsKey(tok.getId())) {
                HashMap<Long, Integer> newlist = new HashMap<Long, Integer>();
                newlist.put(index, value);
                this.referentOfToken.put(tok.getId(), newlist);
            } else {
                this.referentOfToken.get(tok.getId()).put(this.globalIndex, value);
            }
        } else {
            List outEdges = n.getGraph().getOutRelations(n.getId());
            if (outEdges != null) {
                for (SRelation edge : outEdges) {
                    if (edge instanceof SPointingRelation || edge.getSource() == null || edge.getTarget() == null) continue;
                    this.setReferent((SNode)edge.getTarget(), index, value);
                }
            }
        }
    }

    @Override
    public void writeOutput(VisualizerInput input, Writer w) {
        Html html = new Html();
        Head head = new Head();
        Body body = new Body();
        html.removeXmlns();
        html.appendChild((Node)head);
        html.appendChild((Node)body);
        try {
            LinkedList<String> fonts = new LinkedList<String>();
            if (input.getFont() != null) {
                Link linkFont = new Link();
                linkFont.setHref(input.getFont().getUrl());
                head.appendChild((Node)linkFont);
                fonts.add(input.getFont().getName());
            }
            fonts.add("serif");
            Link linkJQueryUI = new Link();
            linkJQueryUI.setHref(input.getResourcePath("coref/jquery-ui-1.11.4.custom/jquery-ui.min.css"));
            linkJQueryUI.setRel("stylesheet");
            linkJQueryUI.setType("text/css");
            head.appendChild((Node)linkJQueryUI);
            Link linkJQueryUIStructure = new Link();
            linkJQueryUIStructure.setHref(input.getResourcePath("coref/jquery-ui-1.11.4.custom/jquery-ui.structure.min.css"));
            linkJQueryUIStructure.setRel("stylesheet");
            linkJQueryUIStructure.setType("text/css");
            head.appendChild((Node)linkJQueryUIStructure);
            Script scriptJquery = new Script("text/javascript");
            scriptJquery.setSrc(input.getResourcePath("coref/jquery.js"));
            head.appendChild((Node)scriptJquery);
            Script scriptUI = new Script("text/javascript");
            scriptUI.setSrc(input.getResourcePath("coref/jquery-ui-1.11.4.custom/jquery-ui.min.js"));
            head.appendChild((Node)scriptUI);
            Link linkCoref = new Link();
            linkCoref.setHref(input.getResourcePath("coref/coref.css"));
            linkCoref.setRel("stylesheet");
            linkCoref.setType("text/css");
            head.appendChild((Node)linkCoref);
            Script scriptCoref = new Script("text/javascript");
            scriptCoref.setSrc(input.getResourcePath("coref/CorefVisualizer.js"));
            head.appendChild((Node)scriptCoref);
            body.setStyle("font-family: '" + StringUtils.join(fonts, (String)"', '") + "';");
            this.globalIndex = 0L;
            this.tokensOfNode = new HashMap();
            this.referentList = new LinkedList<TReferent>();
            this.komponent = new LinkedList<TComponent>();
            this.referentOfToken = new HashMap();
            this.componentOfToken = new HashMap();
            this.componenttype = new LinkedList();
            SDocument saltDoc = input.getDocument();
            SDocumentGraph saltGraph = saltDoc.getDocumentGraph();
            if (saltGraph == null) {
                body.setText("An Error occured: Could not get Graph of Result (Graph == null).");
                return;
            }
            List edgeList = saltGraph.getRelations();
            if (edgeList == null) {
                return;
            }
            for (SRelation rawRel : edgeList) {
                Object currentComponenttype;
                TComponent currentComponent;
                int n;
                if (!this.includeEdge((SRelation<? extends SNode, ? extends SNode>)rawRel, input.getNamespace())) continue;
                SPointingRelation rel = (SPointingRelation)rawRel;
                String relType = CorefVisualizer.componentNameForRelation((SRelation)rel);
                this.visitedNodes = new LinkedList<String>();
                boolean gotIt = false;
                for (n = 0; n < this.componenttype.size(); ++n) {
                    if (this.componenttype.get(n) == null || this.componenttype.get(n).type == null || this.componenttype.get(n).nodeList == null || !this.componenttype.get(n).type.equals(relType) || !this.componenttype.get(n).nodeList.contains(((SStructuredNode)rel.getSource()).getId())) continue;
                    gotIt = true;
                    break;
                }
                if (gotIt) {
                    currentComponent = this.komponent.get(n);
                    currentComponenttype = this.componenttype.get(n);
                } else {
                    currentComponenttype = new TComponenttype();
                    ((TComponenttype)currentComponenttype).type = relType;
                    this.componenttype.add((TComponenttype)currentComponenttype);
                    n = this.komponent.size();
                    currentComponent = new TComponent();
                    currentComponent.type = relType;
                    currentComponent.tokenList = new LinkedList();
                    this.komponent.add(currentComponent);
                    ((TComponenttype)currentComponenttype).nodeList.add(((SStructuredNode)rel.getSource()).getId());
                }
                TReferent ref = new TReferent();
                ref.annotations = new HashSet();
                for (SAnnotation anno : rel.getAnnotations()) {
                    ref.annotations.add(new SerializableAnnotation(anno));
                }
                ref.component = n;
                this.referentList.add(ref);
                List<String> currentTokens = this.getAllTokens((SStructuredNode)rel.getSource(), CorefVisualizer.componentNameForRelation((SRelation)rel), (TComponenttype)currentComponenttype, n, input.getNamespace());
                this.setReferent((SNode)rel.getTarget(), this.globalIndex, 0);
                this.setReferent((SNode)rel.getSource(), this.globalIndex, 1);
                for (String s : currentTokens) {
                    if (currentComponent.tokenList.contains(s)) continue;
                    currentComponent.tokenList.add(s);
                }
                ++this.globalIndex;
            }
            this.colorlist = new HashMap();
            LinkedList<List<Node>> nodesPerText = new LinkedList<List<Node>>();
            List texts = saltGraph.getTextualDSs();
            if (texts != null && !texts.isEmpty()) {
                for (STextualDS t : texts) {
                    DataSourceSequence sequence = new DataSourceSequence((SSequentialDS)t, (Number)0, (Number)(t.getText() != null ? t.getText().length() : 0));
                    List list = saltGraph.getSortedTokenByText(saltGraph.getTokensBySequence(sequence));
                    if (list == null) continue;
                    boolean validText = true;
                    if (Boolean.parseBoolean(input.getMappings().getOrDefault("hide_empty", "false"))) {
                        validText = false;
                        for (SToken tok : list) {
                            if (this.referentOfToken.get(tok.getId()) == null || this.referentOfToken.get(tok.getId()).isEmpty()) continue;
                            validText = true;
                            break;
                        }
                    }
                    if (!validText) continue;
                    List<Node> nodes = this.outputSingleText(list, input);
                    nodesPerText.add(nodes);
                }
                Table tableTexts = new Table();
                Tr trTextRow = new Tr();
                trTextRow.setCSSClass("textRow");
                if (nodesPerText.size() > 1) {
                    body.appendChild((Node)tableTexts);
                    tableTexts.appendChild((Node)trTextRow);
                }
                for (List list : nodesPerText) {
                    if (nodesPerText.size() > 1) {
                        Td tdSingleText = new Td();
                        trTextRow.appendChild((Node)tdSingleText);
                        tdSingleText.setCSSClass("text");
                        tdSingleText.appendChild(list);
                        continue;
                    }
                    body.appendChild(list);
                }
            } else {
                Text errorTxt = new Text("Could not find any texts for the " + input.getNamespace() + " node namespace (layer).");
                body.appendChild((Node)errorTxt);
            }
            w.append(new Doctype(DocumentType.HTMLTransitional).write());
            w.append(html.write());
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    private static class TReferent
    implements Serializable {
        private static final long serialVersionUID = 4574048056625309895L;
        private Set<SerializableAnnotation> annotations = new HashSet<SerializableAnnotation>();
        private long component = -1L;

        TReferent() {
        }
    }

    private static class TComponenttype
    implements Serializable {
        private static final long serialVersionUID = -2055379528368649264L;
        private String type = "";
        private List<String> nodeList = new LinkedList<String>();

        TComponenttype() {
        }
    }

    private static class TComponent
    implements Serializable {
        private static final long serialVersionUID = -6194481931107809732L;
        private List<String> tokenList = new LinkedList<String>();
        private String type = "";

        TComponent() {
        }
    }

    private static class SerializableAnnotation
    implements Serializable {
        private static final long serialVersionUID = -7415931420941549791L;
        private String name;
        private String value;

        public SerializableAnnotation(SAnnotation orig) {
            this.name = orig.getName();
            this.value = orig.getValue_STEXT();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

