/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.widgets.grid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.corpus_tools.annis.gui.widgets.grid.GridEvent;

public class Row
implements Serializable {
    private static final long serialVersionUID = -6022902240993893086L;
    private final ArrayList<GridEvent> events = new ArrayList();
    private final BitSet occupancySet;
    private final Set<String> textIDs = new HashSet<String>();
    private String style;

    public Row() {
        this.occupancySet = new BitSet();
    }

    public boolean addEvent(GridEvent e) {
        BitSet eventOccupance = new BitSet(e.getRight());
        eventOccupance.set(e.getLeft(), e.getRight() + 1, true);
        if (this.occupancySet.intersects(eventOccupance)) {
            return false;
        }
        this.occupancySet.or(eventOccupance);
        this.events.add(e);
        if (e.getTextID() != null && !e.getTextID().isEmpty()) {
            this.textIDs.add(e.getTextID());
        }
        return true;
    }

    public boolean addEvent(ListIterator<GridEvent> iterator, GridEvent e) {
        BitSet eventOccupance = new BitSet(e.getRight());
        eventOccupance.set(e.getLeft(), e.getRight() + 1, true);
        if (this.occupancySet.intersects(eventOccupance)) {
            return false;
        }
        this.occupancySet.or(eventOccupance);
        iterator.add(e);
        if (e.getTextID() != null && !e.getTextID().isEmpty()) {
            this.textIDs.add(e.getTextID());
        }
        return true;
    }

    public boolean canMerge(Row other) {
        return !this.occupancySet.intersects(other.occupancySet);
    }

    public ArrayList<GridEvent> getEvents() {
        return this.events;
    }

    public BitSet getOccupancyGridCopy() {
        return (BitSet)this.occupancySet.clone();
    }

    public String getStyle() {
        return this.style;
    }

    public Set<String> getTextIDs() {
        return new HashSet<String>(this.textIDs);
    }

    public boolean merge(Row other) throws IllegalArgumentException {
        if (this.canMerge(other)) {
            this.occupancySet.or(other.occupancySet);
            for (GridEvent e : other.events) {
                this.events.add(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeEvent(GridEvent event) {
        boolean success = this.events.remove(event);
        if (success) {
            this.occupancySet.set(event.getLeft(), event.getRight() + 1, false);
        }
        return success;
    }

    public void removeEvent(ListIterator<GridEvent> iterator) {
        if (iterator != null) {
            iterator.previous();
            GridEvent event = iterator.next();
            if (event != null) {
                iterator.remove();
                this.occupancySet.set(event.getLeft(), event.getRight() + 1, false);
            }
        }
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

