/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.widgets.gwt.client.ui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;
import com.vaadin.client.ApplicationConnection;
import com.vaadin.client.Paintable;
import com.vaadin.client.UIDL;
import com.vaadin.client.WidgetUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VAnnotationGrid
extends Composite
implements Paintable {
    public static final String CLASSNAME = "v-annotationgrid";
    protected String paintableId;
    ApplicationConnection gClient;
    private AnnotationGridTable table = new AnnotationGridTable();
    private FlexTable.FlexCellFormatter formatter = this.table.getFlexCellFormatter();
    private BiMap<Position, String> position2id;
    private Map<String, String[]> highlighted;
    private Map<Position, Double> startTimes;
    private Map<Position, Double> endTimes;
    private Map<Position, String> pdfPageNumbers;
    private boolean escapeHTML = true;

    public VAnnotationGrid() {
        this.initWidget((Widget)this.table);
        this.setStyleName(CLASSNAME);
        this.highlighted = new HashMap<String, String[]>();
        this.position2id = HashBiMap.create();
        this.startTimes = new HashMap<Position, Double>();
        this.endTimes = new HashMap<Position, Double>();
        this.pdfPageNumbers = new HashMap<Position, String>();
    }

    private void addRow(UIDL row, int rowNumber) {
        String name;
        String style;
        String caption = row.getStringAttribute("caption");
        boolean showNamespace = row.getBooleanAttribute("show-namespace");
        String string = style = row.hasAttribute("style") ? row.getStringAttribute("style") : null;
        if (showNamespace) {
            name = caption;
        } else {
            String[] captionSplit = caption.split("::");
            name = captionSplit[captionSplit.length - 1];
        }
        boolean showCaption = row.getBooleanAttribute("show-caption");
        int startColumn = 0;
        if (showCaption) {
            this.table.setHTML(rowNumber, 0, WidgetUtil.escapeHTML((String)name));
            this.formatter.addStyleName(rowNumber, 0, "header");
            startColumn = 1;
        }
        if (style != null && !style.isEmpty()) {
            this.table.getRowFormatter().addStyleName(rowNumber, style);
        }
        int colspanOffset = 0;
        UIDL events = row.getChildByTagName("events");
        for (int j = 0; j < events.getChildCount(); ++j) {
            UIDL event = events.getChildUIDL(j);
            String id = event.getStringAttribute("id");
            int left = event.getIntAttribute("left");
            int right = event.getIntAttribute("right");
            String value = event.getStringAttribute("value");
            if (this.escapeHTML) {
                value = WidgetUtil.escapeHTML((String)value);
            }
            int col = left + startColumn - colspanOffset;
            this.table.setHTML(rowNumber, col, value);
            if (event.hasAttribute("tooltip")) {
                com.google.gwt.user.client.Element tdElement = this.table.getCellFormatter().getElement(rowNumber, col);
                tdElement.setTitle(event.getStringAttribute("tooltip"));
            }
            this.position2id.put((Object)new Position(rowNumber, col), (Object)id);
            int colspan = right - left + 1;
            this.formatter.setColSpan(rowNumber, col, colspan);
            if (colspan > 1) {
                colspanOffset += colspan - 1;
            }
            this.addStyleForEvent(event, rowNumber, col);
        }
    }

    private void addStyleForEvent(UIDL event, int rowNumber, int col) {
        String id = event.getStringAttribute("id");
        if (event.hasAttribute("style")) {
            String[] styles;
            for (String s : styles = event.getStringArrayAttribute("style")) {
                this.formatter.addStyleName(rowNumber, col, s);
            }
        } else {
            this.formatter.addStyleName(rowNumber, col, "single_event");
        }
        if (event.hasAttribute("highlight")) {
            this.highlighted.put(id, event.getStringArrayAttribute("highlight"));
        }
        if (event.hasAttribute("startTime")) {
            this.formatter.addStyleName(rowNumber, col, "speaker");
            this.startTimes.put(new Position(rowNumber, col), event.getDoubleAttribute("startTime"));
            if (event.hasAttribute("endTime")) {
                this.endTimes.put(new Position(rowNumber, col), event.getDoubleAttribute("endTime"));
            }
        }
        if (event.hasAttribute("openPDF")) {
            String number = event.getStringAttribute("openPDF");
            this.formatter.addStyleName(rowNumber, col, "pdf");
            this.pdfPageNumbers.put(new Position(rowNumber, col), number);
        }
    }

    private int getRealColumnCount(int row) {
        int result = 0;
        for (int i = 0; i < this.table.getCellCount(row); ++i) {
            result += this.formatter.getColSpan(row, i);
        }
        return result;
    }

    public void onClick(int row, int col) {
        Position pos = new Position(row, col);
        if (this.startTimes.containsKey(pos)) {
            if (this.endTimes.containsKey(pos)) {
                this.gClient.updateVariable(this.paintableId, "play", "" + this.startTimes.get(pos) + "-" + this.endTimes.get(pos), true);
            } else {
                this.gClient.updateVariable(this.paintableId, "play", "" + this.startTimes.get(pos), true);
            }
        }
        if (this.pdfPageNumbers.containsKey(pos)) {
            this.gClient.updateVariable(this.paintableId, "openPDF", this.pdfPageNumbers.get(pos), true);
        }
    }

    public void updateFromUIDL(UIDL uidl, ApplicationConnection client) {
        if (client.updateComponent((Widget)this, uidl, true)) {
            return;
        }
        this.gClient = client;
        this.paintableId = uidl.getId();
        try {
            int row;
            UIDL rows;
            if (uidl.hasAttribute("escapeHTML")) {
                this.escapeHTML = uidl.getBooleanAttribute("escapeHTML");
            }
            if ((rows = uidl.getChildByTagName("rows")) != null) {
                this.table.removeAllRows();
                this.highlighted.clear();
                this.position2id.clear();
                for (int i = 0; i < rows.getChildCount(); ++i) {
                    UIDL row2 = rows.getChildUIDL(i);
                    if (!"row".equals(row2.getTag())) continue;
                    this.addRow(row2, i);
                }
            }
            int maxCellCount = 0;
            for (row = 0; row < this.table.getRowCount(); ++row) {
                maxCellCount = Math.max(maxCellCount, this.getRealColumnCount(row));
            }
            for (row = 0; row < this.table.getRowCount(); ++row) {
                int isValue = this.getRealColumnCount(row);
                if (isValue >= maxCellCount) continue;
                int diff = maxCellCount - isValue;
                this.table.setHTML(row, this.table.getCellCount(row) + diff - 1, "");
            }
        }
        catch (Exception ex) {
            Logger.getLogger(VAnnotationGrid.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public static class Position {
        private int column;
        private int row;

        private Position(int row, int column) {
            this.column = column;
            this.row = row;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Position other = (Position)obj;
            if (this.column != other.column) {
                return false;
            }
            return this.row == other.row;
        }

        public int getColumn() {
            return this.column;
        }

        public int getRow() {
            return this.row;
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + this.column;
            hash = 71 * hash + this.row;
            return hash;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public void setRow(int row) {
            this.row = row;
        }
    }

    public class AnnotationGridTable
    extends FlexTable {
        public AnnotationGridTable() {
            this.sinkEvents(49);
        }

        public void onBrowserEvent(Event event) {
            com.google.gwt.user.client.Element td = this.getEventTargetCell(event);
            if (td == null) {
                return;
            }
            int row = TableRowElement.as((Element)td.getParentElement()).getSectionRowIndex();
            int column = TableCellElement.as((Element)td).getCellIndex();
            String id = (String)VAnnotationGrid.this.position2id.get((Object)new Position(row, column));
            String[] targetIDs = (String[])VAnnotationGrid.this.highlighted.get(id);
            if (targetIDs != null && targetIDs.length > 0) {
                switch (event.getTypeInt()) {
                    case 16: {
                        td.addClassName("highlight-source");
                        for (String targetID : targetIDs) {
                            Position pos = (Position)VAnnotationGrid.this.position2id.inverse().get((Object)targetID);
                            if (pos == null) continue;
                            VAnnotationGrid.this.formatter.addStyleName(pos.getRow(), pos.getColumn(), "highlight-target");
                        }
                        break;
                    }
                    case 32: {
                        td.removeClassName("highlight-source");
                        for (String targetID : targetIDs) {
                            Position pos = (Position)VAnnotationGrid.this.position2id.inverse().get((Object)targetID);
                            if (pos == null) continue;
                            VAnnotationGrid.this.formatter.removeStyleName(pos.getRow(), pos.getColumn(), "highlight-target");
                        }
                        break;
                    }
                    case 1: {
                        VAnnotationGrid.this.onClick(row, column);
                        break;
                    }
                }
            }
        }
    }
}

