/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.widgets.gwt.client.ui;

import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Widget;
import java.util.logging.Logger;
import org.corpus_tools.annis.gui.widgets.gwt.client.ui.autoheightiframe.AutoHeightIFrameConnector;

public class VAutoHeightIFrame
extends Widget {
    private static final Logger logger = Logger.getLogger("VAutoHeightIFrame");
    public static final String CLASSNAME = "v-autoheightiframe";
    private IFrameElement iframe = Document.get().createIFrameElement();
    private int additionalHeight;
    private AutoHeightIFrameConnector.LoadCallback callback;

    public VAutoHeightIFrame() {
        this.iframe.setFrameBorder(0);
        this.iframe.setScrolling("auto");
        this.setElement((Element)this.iframe);
        this.setStyleName(CLASSNAME);
        this.addDomHandler((EventHandler)((LoadHandler)event -> {
            if (!this.iframe.getSrc().endsWith("empty.html")) {
                try {
                    final Document doc = this.iframe.getContentDocument();
                    if (doc != null) {
                        Timer t = new Timer(){

                            public void run() {
                                VAutoHeightIFrame.this.checkIFrameLoaded(doc);
                            }
                        };
                        t.schedule(100);
                    }
                }
                catch (JavaScriptException ex) {
                    logger.severe("trying to access iframe source from different domain which is forbidden");
                }
            }
        }), LoadEvent.getType());
    }

    private void checkIFrameLoaded(Document doc) {
        int newHeight = -1;
        doc.getScrollLeft();
        String contentType = this.getContentType(doc);
        if (contentType != null && contentType.startsWith("image/")) {
            NodeList imgList = doc.getElementsByTagName("img");
            if (imgList.getLength() > 0) {
                ImageElement img = (ImageElement)imgList.getItem(0);
                newHeight = img.getPropertyInt("naturalHeight");
            }
        } else {
            logger.fine("body height defined?: " + doc.getBody().hasAttribute("scrollHeight"));
            logger.fine("document height defined?: " + doc.getDocumentElement().hasAttribute("scrollHeight"));
            int bodyHeight = doc.getBody().getScrollHeight();
            int documentHeight = doc.getDocumentElement().getScrollHeight();
            logger.fine("body scrollHeight: " + bodyHeight + "document scrollHeight: " + documentHeight);
            int maxHeight = Math.max(bodyHeight, documentHeight);
            if (maxHeight > 20) {
                newHeight = maxHeight + this.additionalHeight;
            }
        }
        logger.fine("newheight: " + newHeight);
        if (newHeight > -1 && this.callback != null) {
            this.callback.onIFrameLoaded(newHeight);
        }
    }

    public final native String getContentType(Document var1);

    public void setLoadCallback(AutoHeightIFrameConnector.LoadCallback callback) {
        this.callback = callback;
    }

    public void update(String url, int additionalHeight) {
        if (this.iframe.getSrc() != null && url != null && this.iframe.getSrc().equals(url)) {
            return;
        }
        if (additionalHeight > -1) {
            this.additionalHeight = additionalHeight;
        }
        Style style = this.iframe.getStyle();
        style.setWidth(100.0, Style.Unit.PCT);
        if (url != null) {
            this.iframe.setSrc(url);
        }
    }
}

