/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.widgets.gwt.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.user.client.ui.Widget;
import com.vaadin.client.ApplicationConnection;
import com.vaadin.client.Paintable;
import com.vaadin.client.UIDL;
import com.vaadin.client.ValueMap;
import org.corpus_tools.annis.gui.widgets.gwt.client.ui.JITConf;
import org.corpus_tools.annis.gui.widgets.gwt.client.ui.JITVisualization;

public class VJITWrapper
extends Widget
implements Paintable {
    private Document doc = Document.get();
    private final String elementID = Document.get().createUniqueId();
    private JITVisualization visualization;
    private JSONObject jsonData;
    private JITConf config;

    public VJITWrapper() {
        DivElement wrapper = this.doc.createDivElement();
        DivElement container = (DivElement)wrapper.appendChild((Node)this.doc.createDivElement());
        this.setElement((Element)wrapper);
        container.setAttribute("id", "container_" + this.elementID);
        wrapper.setAttribute("id", this.elementID);
    }

    public JSONObject parseStringToJSON(String jsonString) {
        JSONObject json = null;
        try {
            json = JSONParser.parseStrict((String)jsonString).isObject();
        }
        catch (Exception ex) {
            GWT.log((String)("this json " + jsonString + " is not parsed"), (Throwable)ex);
        }
        return json;
    }

    private void setupConfig() {
        if (this.config == null) {
            this.config = new JITConf();
        }
        this.config.setProperty("json", this.jsonData);
        this.config.setProperty("wrapper", this.elementID);
        this.config.setProperty("container", "container_" + this.elementID);
    }

    private void setupConfig(ValueMap mappings) {
        if (this.config == null) {
            this.config = new JITConf();
        }
        for (String key : mappings.getKeySet()) {
            this.config.setProperty(key, mappings.getString(key));
        }
        this.setupConfig();
    }

    public void updateFromUIDL(UIDL uidl, ApplicationConnection client) {
        if (client.updateComponent((Widget)this, uidl, true)) {
            return;
        }
        if (uidl.hasAttribute("visData")) {
            this.jsonData = this.parseStringToJSON(uidl.getStringAttribute("visData"));
            if (uidl.hasAttribute("mappings")) {
                this.setupConfig(uidl.getMapAttribute("mappings"));
            } else {
                this.setupConfig();
            }
            if (this.visualization == null) {
                this.visualization = this.visualizationInit(this.config.getJavaScriptObject());
            }
            if (this.jsonData != null) {
                this.visualization.render();
            } else {
                GWT.log((String)"jsonData are null");
            }
        }
    }

    public native JITVisualization visualizationInit(JavaScriptObject var1);
}

