/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.cffmaven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.corpus_tools.cffmaven.AbstractCffMojo;
import org.corpus_tools.cffmaven.TemplateConfiguration;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;

@Mojo(name="create", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CreateMojo
extends AbstractCffMojo {
    @Parameter(defaultValue="${basedir}/CITATION.cff")
    private File output;
    @Parameter
    private File input;
    @Parameter(defaultValue="true")
    private boolean skipExistingDependencies;
    @Parameter
    private String dateReleased;
    @Parameter
    private List<TemplateConfiguration> referenceTemplates;

    public void execute() throws MojoExecutionException {
        Iterator<TemplateConfiguration> iterator;
        LoadSettings yamlLoadSettings = LoadSettings.builder().build();
        Load yamlLoad = new Load(yamlLoadSettings);
        LinkedHashMap<String, Object> cff = new LinkedHashMap<String, Object>();
        cff.putIfAbsent("cff-version", "1.1.0");
        if (this.input != null && this.input.isFile()) {
            try (FileInputStream inputFile = new FileInputStream(this.input);){
                this.getLog().info((CharSequence)("Reading input CFF file " + this.input.getPath()));
                Iterator loaded = yamlLoad.loadFromInputStream((InputStream)inputFile);
                if (loaded instanceof Map) {
                    for (Map.Entry e : ((Map)((Object)loaded)).entrySet()) {
                        if (!(e.getKey() instanceof String)) continue;
                        cff.put((String)e.getKey(), e.getValue());
                    }
                }
            }
            catch (Throwable ex) {
                this.getLog().error((CharSequence)("Error loading input YAML file " + this.input.getPath()), ex);
            }
        }
        ProjectBuildingRequest projectBuildingRequest = this.createProjectBuildingRequest();
        cff.putIfAbsent("message", "If you use this software, please cite it as below.");
        cff.putIfAbsent("title", this.project.getName());
        cff.putIfAbsent("version", this.project.getVersion());
        if (this.dateReleased == null) {
            SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-dd");
            cff.putIfAbsent("date-released", df.format(new Date()));
        } else {
            cff.put("date-released", this.dateReleased);
        }
        LinkedList authors = new LinkedList();
        for (Developer dev : this.project.getModel().getDevelopers()) {
            HashMap<String, String> author = new HashMap<String, String>();
            author.put("name", dev.getName());
            authors.add(author);
        }
        if (!authors.isEmpty()) {
            cff.putIfAbsent("authors", authors);
        }
        List<Map<String, Object>> references = this.mapExistingReferences(cff.get("references"));
        Set existingTitles = references.stream().map(ref -> ref.get("title")).filter(title -> title != null).map(title -> title.toString()).collect(Collectors.toSet());
        TreeMap<String, Map<String, Object>> newReferences = new TreeMap<String, Map<String, Object>>();
        LinkedHashMap<Pattern, File> templatePatterns = new LinkedHashMap<Pattern, File>();
        if (this.referenceTemplates != null && (iterator = this.referenceTemplates.iterator()).hasNext()) {
            TemplateConfiguration config = iterator.next();
            Pattern p = Pattern.compile(config.getPattern().toString());
            templatePatterns.put(p, config.getTemplate());
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            try {
                Map<String, Object> newRef = null;
                for (Map.Entry entry : templatePatterns.entrySet()) {
                    if (!((Pattern)entry.getKey()).matcher(artifact.toString()).matches()) continue;
                    try {
                        newRef = this.createReferenceFromTemplate(artifact, projectBuildingRequest, (File)entry.getValue(), yamlLoad);
                    }
                    catch (IOException e) {
                        this.getLog().error((CharSequence)("Could create reference from template " + ((File)entry.getValue()).getPath()), (Throwable)e);
                    }
                }
                if (newRef == null) {
                    newRef = this.createReference(artifact, projectBuildingRequest);
                }
                String newRefTitle = newRef.getOrDefault("title", "");
                if (this.skipExistingDependencies && existingTitles.contains(newRefTitle)) {
                    this.getLog().info((CharSequence)("Ignoring existing dependency " + artifact.toString()));
                    continue;
                }
                if (newReferences.containsKey(newRefTitle)) continue;
                this.getLog().info((CharSequence)("Adding dependency " + artifact.toString()));
                newReferences.put(newRefTitle, newRef);
            }
            catch (ProjectBuildingException ex) {
                this.getLog().error((CharSequence)("Can not resolve dependency artifact " + artifact.toString()), (Throwable)ex);
            }
        }
        for (Map ref2 : newReferences.values()) {
            references.add(ref2);
        }
        cff.put("references", references);
        DumpSettings dumpSettings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).build();
        Dump dumpYaml = new Dump(dumpSettings);
        try {
            FileWriter outWriter = new FileWriter(this.output);
            Object object = null;
            try {
                String yamlAsString = dumpYaml.dumpToString(cff);
                outWriter.write(yamlAsString);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (outWriter != null) {
                    if (object != null) {
                        try {
                            outWriter.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        outWriter.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Could not write Citation file", (Throwable)ex);
        }
    }

    private List<Map<String, Object>> mapExistingReferences(Object existingReferences) {
        LinkedList<Map<String, Object>> references = new LinkedList<Map<String, Object>>();
        if (existingReferences instanceof List) {
            for (Object ref : (List)existingReferences) {
                if (!(ref instanceof Map)) continue;
                LinkedHashMap existingRefEntry = new LinkedHashMap();
                for (Map.Entry e : ((Map)ref).entrySet()) {
                    if (!(e.getKey() instanceof String)) continue;
                    existingRefEntry.put((String)e.getKey(), e.getValue());
                }
                references.add(existingRefEntry);
            }
        }
        return references;
    }
}

