/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.cffmaven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.corpus_tools.cffmaven.AbstractCffMojo;

@Mojo(name="third-party-folder", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ThirdPartyFolderMojo
extends AbstractCffMojo {
    private static final Pattern INCLUDE_THIRD_PARTY_FILE_PATTERN = Pattern.compile("(meta-info/)?((notice|dependencies|about|license)(\\.md|\\.txt|\\.html|\\.rst)?)|(about_files/.+)", 2);
    @Parameter(defaultValue="${basedir}/THIRD-PARTY")
    private File thirdPartyFolder;
    @Parameter(defaultValue="true")
    private boolean deleteFolder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectBuildingRequest projectBuildingRequest = this.createProjectBuildingRequest();
        if (this.deleteFolder && this.thirdPartyFolder != null && !this.thirdPartyFolder.getPath().isEmpty() && this.thirdPartyFolder.isDirectory()) {
            try {
                this.getLog().info((CharSequence)("Deleting third party folder " + this.thirdPartyFolder.getPath()));
                FileUtils.deleteDirectory((File)this.thirdPartyFolder);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Could not delete third party folder", (Throwable)e);
            }
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            try {
                String newRefTitle;
                Map<String, Object> newRef = this.createReference(artifact, projectBuildingRequest);
                String titleForThirdParty = newRefTitle = (String)newRef.getOrDefault("title", "");
                titleForThirdParty = titleForThirdParty.replaceFirst("\\s*\\([^)]*\\)$", "");
                this.createThirdPartyFolder(titleForThirdParty, artifact, projectBuildingRequest);
            }
            catch (ProjectBuildingException ex) {
                this.getLog().error((CharSequence)("Can not resolve dependency artifact " + artifact.toString()), (Throwable)ex);
            }
        }
    }

    private void createThirdPartyFolder(String title, Artifact artifact, ProjectBuildingRequest projectBuildingRequest) {
        if (this.thirdPartyFolder != null && !this.thirdPartyFolder.getPath().isEmpty()) {
            File artifactFolder = new File(this.thirdPartyFolder, title.replaceAll("\\W+", "_"));
            if (artifact.getFile() != null && artifact.getFile().isFile()) {
                try (ZipFile artifactFile = new ZipFile(artifact.getFile());){
                    Enumeration<? extends ZipEntry> entries = artifactFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry currentEntry = entries.nextElement();
                        String entryPath = currentEntry.getName().replace('\\', '/').replaceFirst("^META-INF/", "");
                        this.getLog().debug((CharSequence)("Checking zip file entry \"" + entryPath + "\" for inclusion in third party folder."));
                        if (!INCLUDE_THIRD_PARTY_FILE_PATTERN.matcher(entryPath).matches()) continue;
                        File outputFile = new File(artifactFolder, entryPath);
                        if (outputFile.exists()) {
                            this.getLog().warn((CharSequence)("Not overwriting existing file " + outputFile.getPath()));
                            continue;
                        }
                        this.getLog().info((CharSequence)("Copying " + entryPath + " from " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " to " + outputFile.getPath()));
                        if (!outputFile.getParentFile().isDirectory() && !outputFile.getParentFile().mkdirs()) continue;
                        InputStream is = artifactFile.getInputStream(currentEntry);
                        Throwable throwable = null;
                        try {
                            Files.copy(is, outputFile.toPath(), new CopyOption[0]);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                }
                catch (IOException ex) {
                    this.getLog().warn((CharSequence)("Could not open artifact file " + artifact.getFile() + ". No 3rd party files will be extracted from it."), (Throwable)ex);
                }
            }
        }
    }
}

