/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.cffmaven;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class KnownLicenses {
    private static final Map<String, String> toSpdx;

    private static String norm(String license) {
        if (license != null) {
            return license.toLowerCase().trim();
        }
        return "";
    }

    public static Optional<String> parse(String orig) {
        return Optional.ofNullable(toSpdx.get(KnownLicenses.norm(orig)));
    }

    static {
        LinkedHashMap<String, String> licenseMap = new LinkedHashMap<String, String>();
        licenseMap.put(KnownLicenses.norm("Apache-2.0"), "Apache-2.0");
        licenseMap.put(KnownLicenses.norm("Apache License 2.0"), "Apache-2.0");
        licenseMap.put(KnownLicenses.norm("Apache License, Version 2.0"), "Apache-2.0");
        licenseMap.put(KnownLicenses.norm("Apache 2.0"), "Apache-2.0");
        licenseMap.put(KnownLicenses.norm("The Apache Software License, Version 2.0"), "Apache-2.0");
        licenseMap.put(KnownLicenses.norm("http://www.apache.org/licenses/LICENSE-2.0.txt"), "Apache-2.0");
        licenseMap.put(KnownLicenses.norm("GPL-2.0-with-classpath-exception"), "GPL-2.0-with-classpath-exception");
        licenseMap.put(KnownLicenses.norm("GNU General Public License v2.0 w/Classpath exception"), "GPL-2.0-with-classpath-exception");
        licenseMap.put(KnownLicenses.norm("GNU General Public License, version 2 (GPL2), with the classpath exception"), "GPL-2.0 WITH Classpath-exception-2.0");
        licenseMap.put(KnownLicenses.norm("MIT"), "MIT");
        licenseMap.put(KnownLicenses.norm("MIT license"), "MIT");
        licenseMap.put(KnownLicenses.norm("EPL-1.0"), "EPL-1.0");
        licenseMap.put(KnownLicenses.norm("Eclipse Public License 1.0"), "EPL-1.0");
        licenseMap.put(KnownLicenses.norm("Eclipse Public License, Version 1.0"), "EPL-1.0");
        licenseMap.put(KnownLicenses.norm("COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0"), "CDDL-1.0");
        toSpdx = Collections.unmodifiableMap(licenseMap);
    }
}

