/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.cffmaven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.corpus_tools.cffmaven.AbstractCffMojo;

@Mojo(name="third-party-folder", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ThirdPartyFolderMojo
extends AbstractCffMojo {
    private static final Pattern INCLUDE_THIRD_PARTY_FILE_PATTERN = Pattern.compile("(meta-info/)?((notice|dependencies|about|license)(\\.md|\\.txt|\\.html|\\.rst)?)|(about_files/.+)", 2);
    @Parameter(defaultValue="true")
    private boolean deleteFolder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectBuildingRequest projectBuildingRequest = this.createProjectBuildingRequest();
        if (this.deleteFolder && this.thirdPartyFolder != null && !this.thirdPartyFolder.getPath().isEmpty() && this.thirdPartyFolder.isDirectory()) {
            try {
                this.getLog().info((CharSequence)("Deleting third party folder " + this.thirdPartyFolder.getPath()));
                FileUtils.deleteDirectory((File)this.thirdPartyFolder);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Could not delete third party folder", (Throwable)e);
            }
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            try {
                String newRefTitle;
                Map<String, Object> newRef = this.createReference(artifact, projectBuildingRequest);
                String titleForThirdParty = newRefTitle = (String)newRef.getOrDefault("title", "");
                titleForThirdParty = titleForThirdParty.replaceFirst("\\s*\\([^)]*\\)$", "");
                this.createThirdPartyFolder(titleForThirdParty, artifact, projectBuildingRequest);
            }
            catch (ProjectBuildingException ex) {
                this.getLog().error((CharSequence)("Can not resolve dependency artifact " + artifact.toString()), (Throwable)ex);
            }
        }
    }

    private void createThirdPartyFolder(String title, Artifact artifact, ProjectBuildingRequest projectBuildingRequest) {
        File artifactFolder = this.getArtifactFolder(title);
        if (artifactFolder != null) {
            String[] children;
            if (artifact.getFile() != null && artifact.getFile().isFile()) {
                try (ZipFile artifactFile = new ZipFile(artifact.getFile());){
                    Enumeration<? extends ZipEntry> entries = artifactFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry currentEntry = entries.nextElement();
                        String entryPath = currentEntry.getName().replace('\\', '/').replaceFirst("^META-INF/", "");
                        this.getLog().debug((CharSequence)("Checking zip file entry \"" + entryPath + "\" for inclusion in third party folder."));
                        if (!INCLUDE_THIRD_PARTY_FILE_PATTERN.matcher(entryPath).matches()) continue;
                        File outputFile = new File(artifactFolder, entryPath);
                        if (outputFile.exists()) {
                            this.getLog().warn((CharSequence)("Not overwriting existing file " + outputFile.getPath()));
                            continue;
                        }
                        this.getLog().info((CharSequence)("Copying " + entryPath + " from " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " to " + outputFile.getPath()));
                        if (!outputFile.getParentFile().isDirectory() && !outputFile.getParentFile().mkdirs()) continue;
                        InputStream is = artifactFile.getInputStream(currentEntry);
                        Throwable throwable = null;
                        try {
                            Files.copy(is, outputFile.toPath(), new CopyOption[0]);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                }
                catch (IOException ex) {
                    this.getLog().warn((CharSequence)("Could not open artifact file " + artifact.getFile() + ". No 3rd party files will be extracted from it."), (Throwable)ex);
                }
            }
            if ((children = artifactFolder.list()) == null || children.length == 0) {
                try {
                    Throwable throwable;
                    Response response;
                    Request downloadRequest;
                    HttpUrl url;
                    Map<String, Object> reference = this.createReference(artifact, projectBuildingRequest);
                    Object licenseUrl = reference.get("license-url");
                    Object licenseId = reference.get("license");
                    String licenseFileName = "LICENSE.txt";
                    Optional<Object> licenseText = Optional.empty();
                    if (licenseUrl instanceof String) {
                        url = HttpUrl.parse((String)((String)licenseUrl));
                        downloadRequest = new Request.Builder().url(url).build();
                        this.getLog().info((CharSequence)("Downloading license for " + artifact.toString() + " from URL " + licenseUrl));
                        try {
                            response = this.http.newCall(downloadRequest).execute();
                            throwable = null;
                            try {
                                if (response.code() == 200) {
                                    licenseText = Optional.ofNullable(response.body().string());
                                }
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (response != null) {
                                    if (throwable != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        response.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            this.getLog().error((CharSequence)("License download for URL " + licenseUrl + " failed."), (Throwable)e);
                        }
                    }
                    if (!licenseText.isPresent() && licenseId instanceof String) {
                        licenseFileName = licenseId + ".txt";
                        url = HttpUrl.parse((String)("https://raw.githubusercontent.com/spdx/license-list-data/master/text/" + (String)licenseId + ".txt"));
                        downloadRequest = new Request.Builder().url(url).build();
                        this.getLog().info((CharSequence)("Downloading license for " + artifact.toString() + " from SPDX repository"));
                        try {
                            response = this.http.newCall(downloadRequest).execute();
                            throwable = null;
                            try {
                                if (response.code() == 200) {
                                    licenseText = Optional.ofNullable(response.body().string());
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (response != null) {
                                    if (throwable != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        response.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            this.getLog().error((CharSequence)("License download for URL " + licenseUrl + " failed."), (Throwable)e);
                        }
                    }
                    if (licenseText.isPresent() && artifactFolder.mkdirs()) {
                        File outputFile = new File(artifactFolder, licenseFileName);
                        try {
                            FileUtils.writeStringToFile((File)outputFile, (String)((String)licenseText.get()));
                        }
                        catch (IOException e) {
                            this.getLog().error((CharSequence)("Writing license file to " + outputFile.getPath() + " failed."), (Throwable)e);
                        }
                    }
                }
                catch (ProjectBuildingException e) {
                    this.getLog().error((CharSequence)"Could not construct Maven project descriptor", (Throwable)e);
                }
            }
        }
    }
}

