/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.cffmaven;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.corpus_tools.cffmaven.KnownLicenses;
import org.corpus_tools.cffmaven.RemoteLicenseInformation;
import org.json.JSONArray;
import org.json.JSONObject;
import org.snakeyaml.engine.v2.api.Load;

public abstract class AbstractCffMojo
extends AbstractMojo {
    protected static final String P2_PLUGIN_GROUP_ID = "p2.eclipse-plugin";
    protected static final Pattern MINOR_VERSION_HEURISTIC = Pattern.compile("^([0-9]\\.[0-9])\\..*");
    protected static final Pattern ARTIFACTID_HEURISTIC_SUFFIX = Pattern.compile("(.*)(\\.)([^.]+)$");
    protected static final HttpUrl DEFINITIONS_ENDPOINT = HttpUrl.parse((String)"https://api.clearlydefined.io/definitions");
    @Parameter(defaultValue="true")
    private boolean includeEmail;
    @Parameter(defaultValue="true")
    private boolean p2IgnorePatchLevel;
    @Parameter(defaultValue="false")
    private boolean p2ReconstructGroupId;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Component
    private ProjectBuilder mavenProjectBuilder;
    protected final OkHttpClient http = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.SECONDS).build();
    private final TemplateLoader handlebarsTemplateLoader = new FileTemplateLoader("", "");
    private final Handlebars handlebars = new Handlebars(this.handlebarsTemplateLoader);
    @Parameter(defaultValue="${basedir}/THIRD-PARTY")
    protected File thirdPartyFolder;
    @Parameter(defaultValue="${basedir}/CITATION.cff")
    protected File output;
    @Parameter
    protected List<String> ignoredArtifacts;
    private List<Pattern> ignoredPatterns;

    protected Map<String, Object> createReference(Artifact artifact, ProjectBuildingRequest projectBuildingRequest) throws ProjectBuildingException {
        LinkedHashMap<String, Object> reference = new LinkedHashMap<String, Object>();
        reference.put("type", "software");
        reference.put("title", artifact.getArtifactId());
        reference.put("version", artifact.getVersion());
        if (P2_PLUGIN_GROUP_ID.equals(artifact.getGroupId())) {
            this.createReferenceFromP2(reference, artifact, projectBuildingRequest);
        } else {
            this.createReferenceFromMavenArtifact(reference, artifact, projectBuildingRequest);
        }
        return reference;
    }

    protected Map<String, Object> createReferenceFromTemplate(Artifact artifact, ProjectBuildingRequest projectBuildingRequest, File templateFile, Load yamlLoad) throws ProjectBuildingException, IOException {
        LinkedHashMap<String, Object> reference = new LinkedHashMap<String, Object>();
        Template template = this.handlebars.compile(templateFile.getAbsolutePath());
        String referenceRaw = template.apply((Object)artifact);
        Object loaded = yamlLoad.loadFromString(referenceRaw);
        if (loaded instanceof Map) {
            for (Map.Entry e : ((Map)loaded).entrySet()) {
                if (e.getKey() instanceof String) {
                    reference.put((String)e.getKey(), e.getValue());
                    continue;
                }
                this.getLog().warn((CharSequence)("Template " + templateFile.getPath() + " as a non-string key '" + e.getKey() + "' which will be ignored"));
            }
        } else {
            this.getLog().warn((CharSequence)("Template " + templateFile.getPath() + " is not a map and will be ignored"));
        }
        return reference;
    }

    private void createReferenceFromP2(Map<String, Object> reference, Artifact artifact, ProjectBuildingRequest projectBuildingRequest) throws ProjectBuildingException {
        if (!this.createReferenceFromIncludedPom(reference, artifact, projectBuildingRequest)) {
            LinkedList authorList = new LinkedList();
            Optional<RemoteLicenseInformation> remoteLicense = this.queryLicenseFromClearlyDefined(artifact);
            if (remoteLicense.isPresent()) {
                reference.put("license", remoteLicense.get().getSpdx());
                for (String name : remoteLicense.get().getAuthors()) {
                    LinkedHashMap<String, String> author = new LinkedHashMap<String, String>();
                    author.put("name", name);
                    authorList.add(author);
                }
            }
            reference.put("authors", authorList);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean createReferenceFromIncludedPom(Map<String, Object> reference, Artifact artifact, ProjectBuildingRequest projectBuildingRequest) throws ProjectBuildingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createReferenceFromMavenArtifact(Map<String, Object> reference, Artifact artifact, ProjectBuildingRequest projectBuildingRequest) throws ProjectBuildingException {
        List licenses;
        ProjectBuildingResult result = this.mavenProjectBuilder.build(artifact, projectBuildingRequest);
        MavenProject project = result.getProject();
        if (project.getName() != null && !project.getName().isEmpty()) {
            reference.put("title", project.getName());
            reference.put("abbreviation", String.valueOf(project.getGroupId()) + ":" + project.getArtifactId());
        }
        if (project.getVersion() != null && !project.getVersion().isEmpty()) {
            reference.put("version", project.getVersion());
        }
        if (!(licenses = project.getLicenses()).isEmpty()) {
            Optional<RemoteLicenseInformation> remoteLicense;
            License l = (License)licenses.get(0);
            Optional<String> spdx = KnownLicenses.parse(l.getName());
            if (!spdx.isPresent() && (remoteLicense = this.queryLicenseFromClearlyDefined(artifact)).isPresent()) {
                spdx = Optional.of(remoteLicense.get().getSpdx());
            }
            if (spdx.isPresent()) {
                reference.put("license", spdx.get());
            } else if (l.getUrl() != null && !l.getUrl().isEmpty()) {
                this.getLog().warn((CharSequence)("Falling back to license URL for unknown license \"" + l.getName() + "\""));
                reference.put("license-url", l.getUrl());
            } else {
                this.getLog().error((CharSequence)("Unknown license for " + artifact.toString()));
            }
            Object title = reference.get("title");
            if (title instanceof String) {
                File thirdPartyFolder = this.getArtifactFolder((String)reference.get("title"));
                Path relativePath = this.output.getParentFile().toPath().relativize(thirdPartyFolder.toPath());
                reference.put("notes", "More license information can be found in the " + relativePath.toString() + " directory.");
            }
        }
        LinkedList authorList = new LinkedList();
        for (Developer dev : project.getDevelopers()) {
            LinkedHashMap<String, String> author = new LinkedHashMap<String, String>();
            if (dev.getName() == null) continue;
            author.put("name", dev.getName());
            if (this.includeEmail && dev.getEmail() != null && !dev.getEmail().isEmpty()) {
                author.put("email", dev.getEmail());
            }
            authorList.add(author);
        }
        reference.put("authors", authorList);
        String scmUrl = this.getRepositoryCodeUrl(project.getScm());
        if (scmUrl != null) {
            reference.put("repository-code", scmUrl);
        }
    }

    protected String getRepositoryCodeUrl(Scm scm) {
        String scmUrl;
        if (scm != null && (scmUrl = scm.getUrl()) != null && !scmUrl.isEmpty()) {
            if (scmUrl.startsWith("scm:") || scmUrl.startsWith("git@")) {
                this.getLog().warn((CharSequence)("Invalid SCM URL " + scmUrl + " detected .It will be ignored."));
            } else {
                return scmUrl;
            }
        }
        return null;
    }

    protected File getArtifactFolder(String artifactTitle) {
        if (this.thirdPartyFolder != null && !this.thirdPartyFolder.getPath().isEmpty()) {
            return new File(this.thirdPartyFolder, artifactTitle.replaceAll("[^a-zA-Z_0-9.]+", "_"));
        }
        return null;
    }

    private Optional<RemoteLicenseInformation> queryLicenseFromClearlyDefined(Artifact artifact) {
        LinkedList<String> patterns = new LinkedList<String>();
        if (P2_PLUGIN_GROUP_ID.equals(artifact.getGroupId())) {
            Matcher m;
            Optional<Object> minorVersion = Optional.empty();
            Matcher minorVersionMatcher = MINOR_VERSION_HEURISTIC.matcher(artifact.getVersion());
            if (minorVersionMatcher.matches()) {
                minorVersion = Optional.of(minorVersionMatcher.group(1));
                this.getLog().debug((CharSequence)("Minor version is " + (String)minorVersion.get() + " for artifact " + artifact.toString()));
            }
            patterns.add(String.valueOf(artifact.getArtifactId()) + "/" + artifact.getVersion());
            if (this.p2IgnorePatchLevel && minorVersion.isPresent()) {
                patterns.add(String.valueOf(artifact.getArtifactId()) + "/" + (String)minorVersion.get());
            }
            if (this.p2ReconstructGroupId && (m = ARTIFACTID_HEURISTIC_SUFFIX.matcher(artifact.getArtifactId())).find()) {
                String groupId = m.group(1);
                String artifactId = m.group(3);
                patterns.add(String.valueOf(groupId) + "/" + artifactId + "/" + artifact.getVersion());
                if (this.p2IgnorePatchLevel && minorVersion.isPresent()) {
                    patterns.add(String.valueOf(groupId) + "/" + artifactId + "/" + (String)minorVersion.get());
                }
            }
        } else {
            patterns.add(String.valueOf(artifact.getGroupId()) + "/" + artifact.getArtifactId() + "/" + artifact.getVersion());
        }
        TreeMap<Long, RemoteLicenseInformation> remoteLicensesByScore = new TreeMap<Long, RemoteLicenseInformation>();
        for (String pattern : patterns) {
            this.getLog().debug((CharSequence)("Trying pattern \"" + pattern + "\" for artifact " + artifact.toString()));
            HttpUrl findUrl = DEFINITIONS_ENDPOINT.newBuilder().addQueryParameter("pattern", pattern).build();
            Request findRequest = new Request.Builder().url(findUrl).build();
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (Response response = this.http.newCall(findRequest).execute();){
                    if (response.code() != 200) continue;
                    JSONArray searchResult = new JSONArray(response.body().string());
                    for (Object foundArtifactId : searchResult) {
                        Optional<RemoteLicenseInformation> result;
                        if (!(foundArtifactId instanceof String) || !(result = this.queryLicenseForId((String)foundArtifactId)).isPresent()) continue;
                        this.getLog().debug((CharSequence)("Found license information with score " + result.get().getScore() + " for artifact " + artifact.toString()));
                        remoteLicensesByScore.put(result.get().getScore(), result.get());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)"Could not interact with clearlydefined.io", (Throwable)ex);
            }
        }
        if (remoteLicensesByScore.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((RemoteLicenseInformation)remoteLicensesByScore.lastEntry().getValue());
    }

    private Optional<RemoteLicenseInformation> queryLicenseForId(String id) throws IOException {
        JSONObject licensedObject;
        JSONObject root;
        HttpUrl artifactUrl = DEFINITIONS_ENDPOINT.newBuilder().addEncodedPathSegment(id).build();
        Response response = this.http.newCall(new Request.Builder().url(artifactUrl).build()).execute();
        if (response.code() == 200 && (root = new JSONObject(response.body().string())).has("licensed") && (licensedObject = root.getJSONObject("licensed")).has("declared")) {
            JSONObject attribution;
            JSONObject core;
            JSONObject facets;
            JSONObject scores;
            RemoteLicenseInformation result = new RemoteLicenseInformation();
            result.setSpdx(licensedObject.getString("declared"));
            if (root.has("scores") && (scores = root.getJSONObject("scores")).has("effective")) {
                result.setScore(scores.getLong("effective"));
            }
            if (licensedObject.has("facets") && (facets = licensedObject.getJSONObject("facets")) != null && facets.has("core") && (core = facets.getJSONObject("core")).has("attribution") && (attribution = core.getJSONObject("attribution")).has("parties")) {
                JSONArray parties = attribution.getJSONArray("parties");
                for (Object p : parties) {
                    if (!(p instanceof String)) continue;
                    result.getAuthors().add((String)p);
                }
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    protected ProjectBuildingRequest createProjectBuildingRequest() {
        return new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest()).setRemoteRepositories(this.remoteRepositories).setValidationLevel(0).setResolveDependencies(false).setProcessPlugins(false);
    }

    protected boolean isIgnored(Artifact artifact) {
        if (this.ignoredPatterns == null) {
            this.ignoredPatterns = new LinkedList<Pattern>();
            if (this.ignoredArtifacts != null) {
                for (String patternRaw : this.ignoredArtifacts) {
                    Pattern pattern = Pattern.compile(patternRaw);
                    this.getLog().info((CharSequence)("Adding ignored pattern " + patternRaw));
                    this.ignoredPatterns.add(pattern);
                }
            }
        }
        for (Pattern p : this.ignoredPatterns) {
            if (!p.matcher(artifact.toString()).matches()) continue;
            return true;
        }
        return false;
    }
}

