/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.cffmaven;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class KnownLicenses {
    private static final Map<String, String> toSpdx;
    protected static final String SPDX_APACHE20 = "Apache-2.0";
    protected static final String SPDX_GPL20CLASSPATHEX = "GPL-2.0-with-classpath-exception";
    protected static final String SPDX_MIT = "MIT";
    protected static final String SPDX_EPL10 = "EPL-1.0";

    private static String norm(String license) {
        if (license != null) {
            return license.toLowerCase().trim();
        }
        return "";
    }

    public static Optional<String> parse(String orig) {
        return Optional.ofNullable(toSpdx.get(KnownLicenses.norm(orig)));
    }

    static {
        LinkedHashMap<String, String> licenseMap = new LinkedHashMap<String, String>();
        licenseMap.put(KnownLicenses.norm(SPDX_APACHE20), SPDX_APACHE20);
        licenseMap.put(KnownLicenses.norm("Apache License 2.0"), SPDX_APACHE20);
        licenseMap.put(KnownLicenses.norm("Apache License, Version 2.0"), SPDX_APACHE20);
        licenseMap.put(KnownLicenses.norm("Apache 2.0"), SPDX_APACHE20);
        licenseMap.put(KnownLicenses.norm("The Apache Software License, Version 2.0"), SPDX_APACHE20);
        licenseMap.put(KnownLicenses.norm("http://www.apache.org/licenses/LICENSE-2.0.txt"), SPDX_APACHE20);
        licenseMap.put(KnownLicenses.norm(SPDX_GPL20CLASSPATHEX), "");
        licenseMap.put(KnownLicenses.norm("GNU General Public License v2.0 w/Classpath exception"), SPDX_GPL20CLASSPATHEX);
        licenseMap.put(KnownLicenses.norm("GNU General Public License, version 2 (GPL2), with the classpath exception"), SPDX_GPL20CLASSPATHEX);
        licenseMap.put(KnownLicenses.norm(SPDX_MIT), SPDX_MIT);
        licenseMap.put(KnownLicenses.norm("MIT license"), SPDX_MIT);
        licenseMap.put(KnownLicenses.norm(SPDX_EPL10), SPDX_EPL10);
        licenseMap.put(KnownLicenses.norm("Eclipse Public License 1.0"), SPDX_EPL10);
        licenseMap.put(KnownLicenses.norm("Eclipse Public License, Version 1.0"), SPDX_EPL10);
        licenseMap.put(KnownLicenses.norm("COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0"), "CDDL-1.0");
        toSpdx = Collections.unmodifiableMap(licenseMap);
    }
}

