/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.cffmaven;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.corpus_tools.cffmaven.KnownLicenses;
import org.corpus_tools.cffmaven.RemoteLicenseInformation;
import org.corpus_tools.cffmaven.TemplateConfiguration;
import org.ehcache.Cache;
import org.ehcache.PersistentCacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.CacheManagerConfiguration;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.json.JSONArray;
import org.json.JSONObject;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;

public abstract class AbstractCffMojo
extends AbstractMojo {
    protected static final Pattern P2_PLUGIN_GROUP_ID = Pattern.compile("p2.eclipse[.\\-]plugin");
    protected static final Pattern MINOR_VERSION_HEURISTIC = Pattern.compile("^(\\d\\.\\d)\\..*");
    protected static final Pattern ARTIFACTID_HEURISTIC_SUFFIX = Pattern.compile("(.*)(\\.)([^.]+)$");
    protected static final HttpUrl DEFINITIONS_ENDPOINT = HttpUrl.parse((String)"https://api.clearlydefined.io/definitions");
    protected static final String TITLE = "title";
    protected static final String VERSION = "version";
    @Parameter(defaultValue="true")
    private boolean includeEmail;
    @Parameter(defaultValue="true")
    private boolean p2IgnorePatchLevel;
    @Parameter(defaultValue="false")
    private boolean p2ReconstructGroupId;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Component
    private ProjectBuilder mavenProjectBuilder;
    protected final OkHttpClient http = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.SECONDS).build();
    private final TemplateLoader handlebarsTemplateLoader = new FileTemplateLoader("", "");
    private final Handlebars handlebars = new Handlebars(this.handlebarsTemplateLoader);
    @Parameter(defaultValue="${basedir}/THIRD-PARTY")
    protected File thirdPartyFolder;
    @Parameter(defaultValue="${basedir}/CITATION.cff")
    protected File output;
    @Parameter
    protected List<String> ignoredArtifacts;
    @Parameter
    private List<TemplateConfiguration> referenceTemplates;
    private List<Pattern> ignoredPatterns;
    private Cache<String, RemoteLicenseInformation> remoteLicenseCache;
    private PersistentCacheManager cacheManager;
    private Map<Pattern, File> templatePatterns;
    private Load yamlLoad = new Load(LoadSettings.builder().build());

    protected Map<String, Object> createReference(Artifact artifact, ProjectBuildingRequest projectBuildingRequest) throws ProjectBuildingException {
        Map<String, Object> templateRef = null;
        for (Map.Entry<Pattern, File> entry : this.getTemplatePatterns().entrySet()) {
            this.getLog().debug((CharSequence)("Testing artifact " + artifact.toString() + " with pattern " + entry.getKey().pattern()));
            if (!entry.getKey().matcher(artifact.toString()).matches()) continue;
            try {
                this.getLog().info((CharSequence)("Adding reference " + artifact.toString() + " from template " + entry.getValue().getPath()));
                templateRef = this.createReferenceFromTemplate(artifact, projectBuildingRequest, entry.getValue(), this.yamlLoad);
                break;
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could create reference from template " + entry.getValue().getPath()), (Throwable)e);
            }
        }
        if (templateRef == null) {
            LinkedHashMap<String, Object> reference = new LinkedHashMap<String, Object>();
            reference.put("type", "software");
            reference.put(TITLE, artifact.getArtifactId());
            reference.put(VERSION, artifact.getVersion());
            if (P2_PLUGIN_GROUP_ID.matcher(artifact.getGroupId()).matches()) {
                this.createReferenceFromP2(reference, artifact, projectBuildingRequest);
            } else {
                this.createReferenceFromMavenArtifact(reference, artifact, projectBuildingRequest);
            }
            return reference;
        }
        return templateRef;
    }

    protected Map<String, Object> createReferenceFromTemplate(Artifact artifact, ProjectBuildingRequest projectBuildingRequest, File templateFile, Load yamlLoad) throws ProjectBuildingException, IOException {
        LinkedHashMap<String, Object> reference = new LinkedHashMap<String, Object>();
        Template template = this.handlebars.compile(templateFile.getAbsolutePath());
        String referenceRaw = template.apply((Object)artifact);
        Object loaded = yamlLoad.loadFromString(referenceRaw);
        if (loaded instanceof Map) {
            for (Map.Entry e : ((Map)loaded).entrySet()) {
                if (e.getKey() instanceof String) {
                    reference.put((String)e.getKey(), e.getValue());
                    continue;
                }
                this.getLog().warn((CharSequence)("Template " + templateFile.getPath() + " as a non-string key '" + e.getKey() + "' which will be ignored"));
            }
        } else {
            this.getLog().warn((CharSequence)("Template " + templateFile.getPath() + " is not a map and will be ignored"));
        }
        return reference;
    }

    private void createReferenceFromP2(Map<String, Object> reference, Artifact artifact, ProjectBuildingRequest projectBuildingRequest) throws ProjectBuildingException {
        if (!this.createReferenceFromIncludedPom(reference, artifact, projectBuildingRequest)) {
            LinkedHashSet authorSet = new LinkedHashSet();
            Optional<RemoteLicenseInformation> remoteLicense = this.queryLicenseFromClearlyDefined(artifact);
            if (remoteLicense.isPresent()) {
                reference.put("license", remoteLicense.get().getSpdx());
                for (String name : remoteLicense.get().getAuthors()) {
                    LinkedHashMap<String, String> author = new LinkedHashMap<String, String>();
                    author.put("name", name);
                    authorSet.add(author);
                }
            }
            if (authorSet.isEmpty()) {
                this.getLog().info((CharSequence)("No author info found for P2 artifact " + artifact.getId() + ". Creating fallback information."));
                LinkedHashMap<String, CallSite> author = new LinkedHashMap<String, CallSite>();
                author.put("name", (CallSite)((Object)("The " + reference.get(TITLE) + " " + reference.get(VERSION) + " Team")));
                authorSet.add(author);
            }
            reference.put("authors", new LinkedList(authorSet));
        }
    }

    /*
     * Exception decompiling
     */
    private boolean createReferenceFromIncludedPom(Map<String, Object> reference, Artifact artifact, ProjectBuildingRequest projectBuildingRequest) throws ProjectBuildingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createReferenceFromMavenArtifact(Map<String, Object> reference, Artifact artifact, ProjectBuildingRequest projectBuildingRequest) throws ProjectBuildingException {
        List licenses;
        ProjectBuildingResult result = this.mavenProjectBuilder.build(artifact, projectBuildingRequest);
        MavenProject project = result.getProject();
        if (project.getName() != null && !project.getName().isEmpty()) {
            reference.put(TITLE, project.getName());
            reference.put("abbreviation", project.getGroupId() + ":" + project.getArtifactId());
        }
        if (project.getVersion() != null && !project.getVersion().isEmpty()) {
            reference.put(VERSION, project.getVersion());
        }
        if (!(licenses = project.getLicenses()).isEmpty()) {
            Optional<RemoteLicenseInformation> remoteLicense;
            License l = (License)licenses.get(0);
            Optional<String> spdx = KnownLicenses.parse(l.getName());
            if (!spdx.isPresent() && (remoteLicense = this.queryLicenseFromClearlyDefined(artifact)).isPresent()) {
                spdx = Optional.of(remoteLicense.get().getSpdx());
            }
            if (spdx.isPresent()) {
                reference.put("license", spdx.get());
            } else if (l.getUrl() != null && !l.getUrl().isEmpty()) {
                this.getLog().warn((CharSequence)("Falling back to license URL for unknown license \"" + l.getName() + "\""));
                reference.put("license-url", l.getUrl());
            } else {
                this.getLog().error((CharSequence)("Unknown license for " + artifact.toString()));
            }
            Object title = reference.get(TITLE);
            if (title instanceof String) {
                File artifactFolder = this.getArtifactFolder((String)reference.get(TITLE));
                Path relativePath = this.output.getParentFile().toPath().relativize(artifactFolder.toPath());
                reference.put("notes", "More license information can be found in the " + relativePath.toString() + " directory.");
            }
        }
        LinkedHashSet authorSet = new LinkedHashSet();
        for (Developer dev : project.getDevelopers()) {
            LinkedHashMap<String, String> author = new LinkedHashMap<String, String>();
            if (dev.getName() == null) continue;
            author.put("name", dev.getName());
            if (this.includeEmail && dev.getEmail() != null && !dev.getEmail().isEmpty()) {
                author.put("email", dev.getEmail());
            }
            authorSet.add(author);
        }
        if (authorSet.isEmpty()) {
            this.getLog().info((CharSequence)("No author info found for Maven artifact " + artifact.getArtifactId() + ". Creating fallback information."));
            LinkedHashMap<String, CallSite> author = new LinkedHashMap<String, CallSite>();
            author.put("name", (CallSite)((Object)("The " + reference.get(TITLE) + " " + reference.get(VERSION) + " Team")));
            authorSet.add(author);
        }
        reference.put("authors", new LinkedList(authorSet));
        String scmUrl = this.getRepositoryCodeUrl(project.getScm());
        if (scmUrl != null) {
            reference.put("repository-code", scmUrl);
        }
    }

    protected String getRepositoryCodeUrl(Scm scm) {
        String scmUrl;
        if (scm != null && (scmUrl = scm.getUrl()) != null && !scmUrl.isEmpty()) {
            if (scmUrl.startsWith("scm:") || scmUrl.startsWith("git@")) {
                this.getLog().warn((CharSequence)("Invalid SCM URL " + scmUrl + " detected .It will be ignored."));
            } else {
                return scmUrl;
            }
        }
        return null;
    }

    protected File getArtifactFolder(String artifactTitle) {
        if (this.thirdPartyFolder != null && !this.thirdPartyFolder.getPath().isEmpty()) {
            return new File(this.thirdPartyFolder, artifactTitle.replaceAll("[^a-zA-Z_0-9.]+", "_"));
        }
        return null;
    }

    private Optional<RemoteLicenseInformation> queryLicenseFromClearlyDefined(Artifact artifact) {
        if (this.getRemoteLicenseCache().containsKey((Object)artifact.getId())) {
            return Optional.ofNullable((RemoteLicenseInformation)this.getRemoteLicenseCache().get((Object)artifact.getId()));
        }
        LinkedList<CallSite> patterns = new LinkedList<CallSite>();
        if (P2_PLUGIN_GROUP_ID.matcher(artifact.getGroupId()).matches()) {
            Matcher matcher;
            Optional<Object> minorVersion = Optional.empty();
            Matcher minorVersionMatcher = MINOR_VERSION_HEURISTIC.matcher(artifact.getVersion());
            if (minorVersionMatcher.matches()) {
                minorVersion = Optional.of(minorVersionMatcher.group(1));
                this.getLog().debug((CharSequence)("Minor version is " + (String)minorVersion.get() + " for artifact " + artifact.toString()));
            }
            patterns.add((CallSite)((Object)(artifact.getArtifactId() + "/" + artifact.getVersion())));
            if (this.p2IgnorePatchLevel && minorVersion.isPresent()) {
                patterns.add((CallSite)((Object)(artifact.getArtifactId() + "/" + (String)minorVersion.get())));
            }
            if (this.p2ReconstructGroupId && (matcher = ARTIFACTID_HEURISTIC_SUFFIX.matcher(artifact.getArtifactId())).find()) {
                String groupId = matcher.group(1);
                String artifactId = matcher.group(3);
                patterns.add((CallSite)((Object)(groupId + "/" + artifactId + "/" + artifact.getVersion())));
                if (this.p2IgnorePatchLevel && minorVersion.isPresent()) {
                    patterns.add((CallSite)((Object)(groupId + "/" + artifactId + "/" + (String)minorVersion.get())));
                }
            }
        } else {
            patterns.add((CallSite)((Object)(artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + artifact.getVersion())));
        }
        TreeMap<Long, RemoteLicenseInformation> remoteLicensesByScore = new TreeMap<Long, RemoteLicenseInformation>();
        for (String string : patterns) {
            this.getLog().debug((CharSequence)("Trying pattern \"" + string + "\" for artifact " + artifact.toString()));
            HttpUrl findUrl = DEFINITIONS_ENDPOINT.newBuilder().addQueryParameter("pattern", string).build();
            Request findRequest = new Request.Builder().url(findUrl).build();
            try {
                Response response = this.http.newCall(findRequest).execute();
                try {
                    if (response.code() != 200) continue;
                    JSONArray searchResult = new JSONArray(response.body().string());
                    for (Object foundArtifactId : searchResult) {
                        Optional<RemoteLicenseInformation> result;
                        if (!(foundArtifactId instanceof String) || !(result = this.queryLicenseForId((String)foundArtifactId)).isPresent()) continue;
                        this.getLog().debug((CharSequence)("Found license information with score " + result.get().getScore() + " for artifact " + artifact.toString()));
                        remoteLicensesByScore.put(result.get().getScore(), result.get());
                    }
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)"Could not interact with clearlydefined.io", (Throwable)ex);
            }
        }
        if (remoteLicensesByScore.isEmpty()) {
            return Optional.empty();
        }
        RemoteLicenseInformation result = (RemoteLicenseInformation)remoteLicensesByScore.lastEntry().getValue();
        this.getRemoteLicenseCache().put((Object)artifact.getId(), (Object)result);
        return Optional.of(result);
    }

    private Optional<RemoteLicenseInformation> queryLicenseForId(String id) throws IOException {
        JSONObject licensedObject;
        JSONObject root;
        HttpUrl artifactUrl = DEFINITIONS_ENDPOINT.newBuilder().addEncodedPathSegment(id).build();
        Response response = this.http.newCall(new Request.Builder().url(artifactUrl).build()).execute();
        if (response.code() == 200 && (root = new JSONObject(response.body().string())).has("licensed") && (licensedObject = root.getJSONObject("licensed")).has("declared")) {
            JSONObject attribution;
            JSONObject core;
            JSONObject facets;
            JSONObject scores;
            RemoteLicenseInformation result = new RemoteLicenseInformation();
            result.setSpdx(licensedObject.getString("declared"));
            if (root.has("scores") && (scores = root.getJSONObject("scores")).has("effective")) {
                result.setScore(scores.getLong("effective"));
            }
            if (licensedObject.has("facets") && (facets = licensedObject.getJSONObject("facets")) != null && facets.has("core") && (core = facets.getJSONObject("core")).has("attribution") && (attribution = core.getJSONObject("attribution")).has("parties")) {
                JSONArray parties = attribution.getJSONArray("parties");
                for (Object p : parties) {
                    if (!(p instanceof String)) continue;
                    result.getAuthors().add((String)p);
                }
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    protected ProjectBuildingRequest createProjectBuildingRequest() {
        return new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest()).setRemoteRepositories(this.remoteRepositories).setValidationLevel(0).setResolveDependencies(false).setProcessPlugins(false);
    }

    protected boolean isIgnored(Artifact artifact) {
        if (this.ignoredPatterns == null) {
            this.ignoredPatterns = new LinkedList<Pattern>();
            if (this.ignoredArtifacts != null) {
                for (String patternRaw : this.ignoredArtifacts) {
                    Pattern pattern = Pattern.compile(patternRaw);
                    this.getLog().info((CharSequence)("Adding ignored pattern " + patternRaw));
                    this.ignoredPatterns.add(pattern);
                }
            }
        }
        for (Pattern p : this.ignoredPatterns) {
            if (!p.matcher(artifact.toString()).matches()) continue;
            return true;
        }
        return false;
    }

    protected Map<Pattern, File> getTemplatePatterns() {
        if (this.templatePatterns == null) {
            this.templatePatterns = new LinkedHashMap<Pattern, File>();
            if (this.referenceTemplates != null) {
                for (TemplateConfiguration config : this.referenceTemplates) {
                    Pattern p = Pattern.compile(config.getPattern());
                    this.templatePatterns.put(p, config.getTemplate());
                }
            }
        }
        return this.templatePatterns;
    }

    protected PersistentCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            CacheManagerConfiguration cacheConfig = CacheManagerBuilder.persistence((String)(System.getProperty("user.home") + "/.m2/repository/.cache/cff-maven-plugin/" + ((Object)((Object)this)).getClass().getSimpleName()));
            this.cacheManager = (PersistentCacheManager)CacheManagerBuilder.newCacheManagerBuilder().with(cacheConfig).build(true);
        }
        return this.cacheManager;
    }

    protected Cache<String, RemoteLicenseInformation> getRemoteLicenseCache() {
        if (this.remoteLicenseCache == null) {
            this.remoteLicenseCache = this.getCacheManager().createCache("remoteLicense", (Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, RemoteLicenseInformation.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap(100L, (ResourceUnit)EntryUnit.ENTRIES).disk(100L, MemoryUnit.MB, true)));
        }
        return this.remoteLicenseCache;
    }

    protected void closeCache() {
        this.getCacheManager().close();
        this.cacheManager = null;
        this.remoteLicenseCache = null;
    }
}

