/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.cffmaven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.corpus_tools.cffmaven.AbstractCffMojo;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;

@Mojo(name="create", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CreateMojo
extends AbstractCffMojo {
    protected static final String REFERENCES = "references";
    @Parameter
    private File input;
    @Parameter(defaultValue="true")
    private boolean skipExistingDependencies;
    @Parameter
    private String dateReleased;

    public void execute() throws MojoExecutionException {
        Load yamlLoad = new Load(LoadSettings.builder().build());
        LinkedHashMap<String, Object> cff = new LinkedHashMap<String, Object>();
        cff.putIfAbsent("cff-version", "1.2.0");
        cff.putIfAbsent("type", "software");
        if (this.input != null && this.input.isFile()) {
            try (FileInputStream inputFile = new FileInputStream(this.input);){
                this.getLog().info((CharSequence)("Reading input CFF file " + this.input.getPath()));
                Object loaded = yamlLoad.loadFromInputStream((InputStream)inputFile);
                if (loaded instanceof Map) {
                    for (Map.Entry e : ((Map)loaded).entrySet()) {
                        if (!(e.getKey() instanceof String)) continue;
                        cff.put((String)e.getKey(), e.getValue());
                    }
                }
            }
            catch (Throwable ex) {
                this.getLog().error((CharSequence)("Error loading input YAML file " + this.input.getPath()), ex);
            }
        }
        ProjectBuildingRequest projectBuildingRequest = this.createProjectBuildingRequest();
        cff.putIfAbsent("message", "If you use this software, please cite it as below.");
        cff.putIfAbsent("title", this.project.getName());
        cff.putIfAbsent("version", this.project.getVersion());
        if (this.dateReleased == null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            cff.putIfAbsent("date-released", df.format(new Date()));
        } else {
            cff.put("date-released", this.dateReleased);
        }
        LinkedHashSet authors = new LinkedHashSet();
        for (Developer dev : this.project.getModel().getDevelopers()) {
            HashMap<String, String> author = new HashMap<String, String>();
            author.put("name", dev.getName());
            authors.add(author);
        }
        if (authors.isEmpty()) {
            this.getLog().info((CharSequence)"No author info found for this project. Creating fallback information.");
            HashMap<String, CallSite> author = new HashMap<String, CallSite>();
            author.put("name", (CallSite)((Object)("The " + cff.get("title") + " " + cff.get("version") + " Team")));
            authors.add(author);
        }
        cff.putIfAbsent("authors", new LinkedList(authors));
        String scmUrl = this.getRepositoryCodeUrl(this.project.getScm());
        if (scmUrl != null) {
            cff.put("repository-code", scmUrl);
        }
        List<Map<String, Object>> references = this.mapExistingReferences(cff.get(REFERENCES));
        Set existingTitles = references.stream().map(ref -> ref.get("title")).filter(title -> title != null).map(title -> title.toString()).collect(Collectors.toSet());
        TreeMap<String, Map<String, Object>> newReferences = new TreeMap<String, Map<String, Object>>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (this.isIgnored(artifact)) continue;
            try {
                Map<String, Object> newRef = this.createReference(artifact, projectBuildingRequest);
                String newRefTitle = (String)newRef.getOrDefault("title", "");
                if (this.skipExistingDependencies && existingTitles.contains(newRefTitle)) {
                    this.getLog().info((CharSequence)("Ignoring existing dependency " + artifact.toString()));
                    continue;
                }
                if (newReferences.containsKey(newRefTitle)) continue;
                this.getLog().info((CharSequence)("Adding reference " + artifact.toString()));
                newReferences.put(newRefTitle, newRef);
            }
            catch (ProjectBuildingException ex) {
                this.getLog().error((CharSequence)("Can not resolve dependency artifact " + artifact.toString()), (Throwable)ex);
            }
        }
        for (Map ref2 : newReferences.values()) {
            references.add(ref2);
        }
        cff.remove(REFERENCES);
        cff.put(REFERENCES, references);
        DumpSettings dumpSettings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).build();
        Dump dumpYaml = new Dump(dumpSettings);
        try (FileWriter outWriter = new FileWriter(this.output);){
            String yamlAsString = dumpYaml.dumpToString(cff);
            outWriter.write(yamlAsString);
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Could not write Citation file", (Throwable)ex);
        }
        this.closeCache();
    }

    private List<Map<String, Object>> mapExistingReferences(Object existingReferences) {
        LinkedList<Map<String, Object>> references = new LinkedList<Map<String, Object>>();
        if (existingReferences instanceof List) {
            for (Object ref : (List)existingReferences) {
                if (!(ref instanceof Map)) continue;
                LinkedHashMap existingRefEntry = new LinkedHashMap();
                for (Map.Entry e : ((Map)ref).entrySet()) {
                    if (!(e.getKey() instanceof String)) continue;
                    existingRefEntry.put((String)e.getKey(), e.getValue());
                }
                references.add(existingRefEntry);
            }
        }
        return references;
    }
}

