/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.resources;

import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.BasicTranscription;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Event;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Speaker;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.TLI;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Tier;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.UDInformation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.emf.common.util.URI;

public class EXBWriter {
    private String encoding = "UTF-8";
    PrintStream fileWriter = null;

    public void write(BasicTranscription basicTranscription, URI uri) throws IOException {
        this.fileWriter = new PrintStream((OutputStream)new FileOutputStream(uri.toFileString()), true, this.encoding);
        try {
            StringBuilder element;
            this.fileWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.fileWriter.println("<basic-transcription>");
            this.fileWriter.println("<head>");
            this.fileWriter.println("<meta-information>");
            this.fileWriter.print("<project-name>");
            if (basicTranscription.getMetaInformation() != null && basicTranscription.getMetaInformation().getProjectName() != null) {
                this.fileWriter.print(basicTranscription.getMetaInformation().getProjectName());
            }
            this.fileWriter.print("</project-name>");
            this.fileWriter.print("<transcription-name>");
            if (basicTranscription.getMetaInformation() != null && basicTranscription.getMetaInformation().getTranscriptionName() != null) {
                this.fileWriter.print(basicTranscription.getMetaInformation().getTranscriptionName());
            }
            this.fileWriter.print("</transcription-name>");
            this.fileWriter.print("<referenced-file");
            this.fileWriter.print(" url=\"");
            if (basicTranscription.getMetaInformation() != null && basicTranscription.getMetaInformation().getReferencedFile() != null) {
                this.fileWriter.print(basicTranscription.getMetaInformation().getReferencedFile());
            }
            this.fileWriter.print("\">");
            this.fileWriter.print("</referenced-file>");
            if (basicTranscription.getMetaInformation() != null && basicTranscription.getMetaInformation().getUdMetaInformations() != null && basicTranscription.getMetaInformation().getUdMetaInformations().size() > 0) {
                this.fileWriter.print("<ud-meta-information>");
                for (UDInformation udInfo : basicTranscription.getMetaInformation().getUdMetaInformations()) {
                    if (udInfo.getAttributeName() == null || udInfo.getAttributeName().equals("")) continue;
                    this.fileWriter.print("<ud-information");
                    this.fileWriter.print(" attribute-name=\"" + udInfo.getAttributeName() + "\">");
                    if (udInfo.getValue() != null) {
                        this.fileWriter.print(udInfo.getValue());
                    }
                    this.fileWriter.print("</ud-information>");
                }
                this.fileWriter.print("</ud-meta-information>");
            } else {
                this.fileWriter.print("<ud-meta-information/>");
            }
            this.fileWriter.print("<comment");
            if (basicTranscription.getMetaInformation() != null && basicTranscription.getMetaInformation().getComment() != null) {
                this.fileWriter.print(basicTranscription.getMetaInformation().getComment());
            } else {
                this.fileWriter.print(">");
            }
            this.fileWriter.print("</comment>");
            this.fileWriter.print("<transcription-convention>");
            if (basicTranscription.getMetaInformation() != null && basicTranscription.getMetaInformation().getTranscriptionConvention() != null) {
                this.fileWriter.print(basicTranscription.getMetaInformation().getTranscriptionConvention());
            }
            this.fileWriter.print("</transcription-convention>");
            this.fileWriter.println("</meta-information>");
            if (basicTranscription.getSpeakertable() != null) {
                this.fileWriter.println("<speakertable>");
                for (Speaker speaker : basicTranscription.getSpeakertable()) {
                    this.fileWriter.print("<speaker");
                    if (speaker.getId() != null) {
                        this.fileWriter.print(" id=\"" + speaker.getId() + "\">");
                    } else {
                        this.fileWriter.print(">");
                    }
                    this.fileWriter.println();
                    this.fileWriter.print("<abbreviation>");
                    if (speaker.getAbbreviation() != null) {
                        this.fileWriter.print(speaker.getAbbreviation());
                    }
                    this.fileWriter.println("</abbreviation>");
                    this.fileWriter.print("<sex");
                    if (speaker.isSetSex()) {
                        this.fileWriter.print(" value=\"" + (Object)((Object)speaker.getSex()) + "\">");
                    } else {
                        this.fileWriter.print(">");
                    }
                    this.fileWriter.println("</sex>");
                    this.fileWriter.print("<languages-used>");
                    for (String lang : speaker.getLanguageUsed()) {
                        this.fileWriter.print("<language>");
                        this.fileWriter.print(lang);
                        this.fileWriter.println("</language>");
                    }
                    this.fileWriter.println("</languages-used>");
                    this.fileWriter.print("<l1>");
                    for (String lang : speaker.getL1()) {
                        this.fileWriter.print("<language>");
                        this.fileWriter.print(lang);
                        this.fileWriter.println("</language>");
                    }
                    this.fileWriter.println("</l1>");
                    this.fileWriter.print("<l2>");
                    for (String lang : speaker.getL2()) {
                        this.fileWriter.print("<language>");
                        this.fileWriter.print(lang);
                        this.fileWriter.println("</language>");
                    }
                    this.fileWriter.println("</l2>");
                    this.fileWriter.print("<ud-speaker-information>");
                    for (UDInformation udInfo : speaker.getUdSpeakerInformations()) {
                        if (udInfo.getAttributeName() == null || udInfo.getAttributeName().equals("")) continue;
                        this.fileWriter.print("<ud-information");
                        this.fileWriter.print(" attribute-name=\"" + udInfo.getAttributeName() + "\">");
                        if (udInfo.getValue() != null) {
                            this.fileWriter.print(udInfo.getValue());
                        }
                        this.fileWriter.print("</ud-information>");
                    }
                    this.fileWriter.println("</ud-speaker-information>");
                    this.fileWriter.print("<comment>");
                    if (speaker.getComment() != null) {
                        this.fileWriter.print(speaker.getComment());
                    }
                    this.fileWriter.println("</comment>");
                    this.fileWriter.println("</speaker>");
                }
                this.fileWriter.println("</speakertable>");
            }
            this.fileWriter.println("</head>");
            this.fileWriter.println("<basic-body>");
            if (basicTranscription.getCommonTimeLine() != null) {
                this.fileWriter.println("<common-timeline>");
                for (TLI tli : basicTranscription.getCommonTimeLine().getTLIs()) {
                    element = new StringBuilder();
                    element.append("<tli");
                    if (tli.getId() != null) {
                        element.append(" id=\"" + tli.getId() + "\"");
                    }
                    if (tli.getTime() != null) {
                        element.append(" time=\"" + tli.getTime() + "\"");
                    }
                    if (tli.isSetType()) {
                        element.append(" type=\"" + (Object)((Object)tli.getType()) + "\"");
                    }
                    element.append("/>");
                    this.fileWriter.println(element);
                }
                this.fileWriter.println("</common-timeline>");
            }
            for (Tier tier : basicTranscription.getTiers()) {
                element = new StringBuilder();
                element.append("<tier");
                if (tier.getId() != null) {
                    element.append(" id=\"" + tier.getId() + "\"");
                }
                if (tier.getSpeaker() != null) {
                    element.append(" speaker=\"" + tier.getSpeaker().getId() + "\"");
                }
                if (tier.getCategory() != null) {
                    element.append(" category=\"" + tier.getCategory() + "\"");
                }
                if (tier.isSetType()) {
                    element.append(" type=\"" + (Object)((Object)tier.getType()) + "\"");
                }
                if (tier.getDisplayName() != null) {
                    element.append(" display-name=\"" + tier.getDisplayName() + "\"");
                }
                element.append(">");
                this.fileWriter.print(element);
                if (tier.getUdTierInformations() != null && tier.getUdTierInformations().size() > 0) {
                    this.fileWriter.print("<ud-tier-information>");
                    for (UDInformation udInfo : tier.getUdTierInformations()) {
                        if (udInfo.getAttributeName() == null || udInfo.getAttributeName().equals("")) continue;
                        this.fileWriter.print("<ud-information");
                        this.fileWriter.print(" attribute-name=\"" + udInfo.getAttributeName() + "\">");
                        if (udInfo.getValue() != null) {
                            this.fileWriter.print(udInfo.getValue());
                        }
                        this.fileWriter.print("</ud-information>");
                    }
                    this.fileWriter.print("</ud-tier-information>");
                }
                if (tier.getEvents().size() > 0) {
                    this.fileWriter.println();
                    for (Event event : tier.getEvents()) {
                        element = new StringBuilder();
                        element.append("<event");
                        if (event.getStart() != null) {
                            element.append(" start=\"" + event.getStart().getId() + "\"");
                        }
                        if (event.getEnd() != null) {
                            element.append(" end=\"" + event.getEnd().getId() + "\"");
                        }
                        if (event.isSetMedium() && event.getMedium() != null) {
                            element.append(" medium=\"" + (Object)((Object)event.getMedium()) + "\"");
                        }
                        if (event.getUrl() != null) {
                            element.append(" url=\"" + event.getUrl() + "\"");
                        }
                        element.append(">");
                        this.fileWriter.print(element);
                        for (UDInformation udInfo : event.getUdInformations()) {
                            if (udInfo.getAttributeName() == null || udInfo.getAttributeName().equals("")) continue;
                            this.fileWriter.print("<ud-information");
                            this.fileWriter.print(" attribute-name=\"" + udInfo.getAttributeName() + "\">");
                            if (udInfo.getValue() != null) {
                                this.fileWriter.print(udInfo.getValue());
                            }
                            this.fileWriter.print("</ud-information>");
                        }
                        if (event.getValue() != null && !event.getValue().equals("")) {
                            this.fileWriter.print(event.getValue());
                        }
                        this.fileWriter.println("</event>");
                    }
                }
                this.fileWriter.println("</tier>");
            }
            this.fileWriter.println("</basic-body>");
            this.fileWriter.print("</basic-transcription>");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.fileWriter.flush();
            this.fileWriter.close();
        }
    }
}

