/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.resources;

import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.BasicTranscription;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.CommonTimeLine;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.EVENT_MEDIUM;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Event;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.ExmaraldaBasicFactory;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.MetaInformation;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.SPEAKER_SEX;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Speaker;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.TIER_TYPE;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.TIME_TYPE;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.TLI;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Tier;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.UDInformation;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.exceptions.ExmaraldaException;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.resources.ExmaraldaXML;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class EXBReader
extends DefaultHandler2
implements ExmaraldaXML {
    private BasicTranscription basicTranscription = null;
    private File exmaraldaFile = null;
    private Tier currTier = null;
    private Event currEvent = null;
    private Speaker currSpeaker = null;
    private UDInformation currUDInfo = null;
    private Stack<String> currObjectName = new Stack();

    public void setBasicTranscription(BasicTranscription basicTranscription) {
        this.basicTranscription = basicTranscription;
    }

    public BasicTranscription getBasicTranscription() {
        return this.basicTranscription;
    }

    public File getExmaraldaFile() {
        return this.exmaraldaFile;
    }

    public void setExmaraldaFile(File exmaraldaFile) {
        this.exmaraldaFile = exmaraldaFile;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuffer text = new StringBuffer();
        for (int i = start; i < start + length; ++i) {
            text.append(ch[i]);
        }
        if ("project-name".equals(this.currObjectName.peek())) {
            this.getBasicTranscription().getMetaInformation().setProjectName(text.toString());
        } else if ("transcription-name".equals(this.currObjectName.peek())) {
            this.getBasicTranscription().getMetaInformation().setTranscriptionName(text.toString());
        } else if ("comment".equals(this.currObjectName.peek())) {
            this.currObjectName.pop();
            if ("meta-information".equals(this.currObjectName.peek())) {
                if (this.getBasicTranscription().getMetaInformation().getComment() == null) {
                    this.getBasicTranscription().getMetaInformation().setComment(text.toString());
                } else {
                    this.getBasicTranscription().getMetaInformation().setComment(this.getBasicTranscription().getMetaInformation().getComment() + text);
                }
            } else if ("speaker".equals(this.currObjectName.peek())) {
                if (this.currSpeaker.getComment() == null) {
                    this.currSpeaker.setComment(text.toString());
                } else {
                    this.currSpeaker.setComment(this.currSpeaker.getComment() + text);
                }
            }
            this.currObjectName.push("comment");
        } else if ("transcription-convention".equals(this.currObjectName.peek())) {
            if (this.getBasicTranscription().getMetaInformation().getTranscriptionConvention() == null) {
                this.getBasicTranscription().getMetaInformation().setTranscriptionConvention(text.toString());
            } else {
                this.getBasicTranscription().getMetaInformation().setTranscriptionConvention(this.getBasicTranscription().getMetaInformation().getTranscriptionConvention() + text);
            }
        } else if ("abbreviation".equals(this.currObjectName.peek())) {
            if (this.currSpeaker.getAbbreviation() == null) {
                this.currSpeaker.setAbbreviation(text.toString());
            } else {
                this.currSpeaker.setAbbreviation(this.currSpeaker.getAbbreviation() + text);
            }
        } else if ("event".equals(this.currObjectName.peek())) {
            if (this.currEvent.getValue() == null) {
                this.currEvent.setValue(text.toString());
            } else {
                this.currEvent.setValue(this.currEvent.getValue() + text);
            }
        } else if ("ud-information".equals(this.currObjectName.peek())) {
            if (this.currUDInfo.getValue() == null) {
                this.currUDInfo.setValue(text.toString());
            } else {
                this.currUDInfo.setValue(this.currUDInfo.getValue() + text);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!"basic-transcription".equals(qName) && !"head".equals(qName)) {
            if ("meta-information".equals(qName)) {
                MetaInformation mInfo = ExmaraldaBasicFactory.eINSTANCE.createMetaInformation();
                this.getBasicTranscription().setMetaInformation(mInfo);
            } else if (!"project-name".equals(qName) && !"transcription-name".equals(qName)) {
                if ("referenced-file".equals(qName)) {
                    String attValue = attributes.getValue("url");
                    if (attValue != null && !attValue.isEmpty()) {
                        File refFile = new File(this.getExmaraldaFile().getParentFile() + "/" + attValue);
                        this.getBasicTranscription().getMetaInformation().setReferencedFile(refFile.toString());
                    }
                } else if (!"comment".equals(qName) && !"transcription-convention".equals(qName)) {
                    if ("speaker".equals(qName)) {
                        Speaker speaker = ExmaraldaBasicFactory.eINSTANCE.createSpeaker();
                        speaker.setId(attributes.getValue("id"));
                        this.currSpeaker = speaker;
                        this.getBasicTranscription().getSpeakertable().add((Object)speaker);
                    } else if ("language".equals(qName) && attributes.getValue("lang") != null) {
                        if ("languages-used".equals(this.currObjectName.peek())) {
                            if (this.currSpeaker != null) {
                                this.currSpeaker.getLanguageUsed().add((Object)attributes.getValue("lang"));
                            }
                        } else if ("l1".equals(this.currObjectName.peek())) {
                            if (this.currSpeaker != null) {
                                this.currSpeaker.getL1().add((Object)attributes.getValue("lang"));
                            }
                        } else if ("l2".equals(this.currObjectName.peek()) && this.currSpeaker != null) {
                            this.currSpeaker.getL2().add((Object)attributes.getValue("lang"));
                        }
                    } else if ("sex".equals(qName)) {
                        String value = attributes.getValue("value");
                        if (value.equalsIgnoreCase("m")) {
                            this.currSpeaker.setSex(SPEAKER_SEX.M);
                        } else if (value.equalsIgnoreCase("f")) {
                            this.currSpeaker.setSex(SPEAKER_SEX.F);
                        } else if (value.equalsIgnoreCase("u")) {
                            this.currSpeaker.setSex(SPEAKER_SEX.U);
                        }
                    } else if (!"basic-body".equals(qName)) {
                        if ("common-timeline".equals(qName)) {
                            CommonTimeLine timeLine = ExmaraldaBasicFactory.eINSTANCE.createCommonTimeLine();
                            this.getBasicTranscription().setCommonTimeLine(timeLine);
                        } else if ("tli".equals(qName)) {
                            TLI tli = ExmaraldaBasicFactory.eINSTANCE.createTLI();
                            tli.setId(attributes.getValue("id"));
                            tli.setTime(attributes.getValue("time"));
                            if (attributes.getValue("type") != null) {
                                if (attributes.getValue("type").equalsIgnoreCase("appl")) {
                                    tli.setType(TIME_TYPE.APPL);
                                } else if (attributes.getValue("type").equalsIgnoreCase("intp")) {
                                    tli.setType(TIME_TYPE.INTP);
                                } else if (attributes.getValue("type").equalsIgnoreCase("othr")) {
                                    tli.setType(TIME_TYPE.OTHR);
                                } else if (attributes.getValue("type").equalsIgnoreCase("unsp")) {
                                    tli.setType(TIME_TYPE.UNSP);
                                } else if (attributes.getValue("type").equalsIgnoreCase("user")) {
                                    tli.setType(TIME_TYPE.USER);
                                }
                            }
                            this.getBasicTranscription().getCommonTimeLine().getTLIs().add((Object)tli);
                        } else if ("tier".equals(qName)) {
                            Tier tier;
                            this.currTier = tier = ExmaraldaBasicFactory.eINSTANCE.createTier();
                            tier.setId(attributes.getValue("id"));
                            for (Speaker speaker : this.getBasicTranscription().getSpeakertable()) {
                                if (!speaker.getId().equalsIgnoreCase(attributes.getValue("speaker"))) continue;
                                tier.setSpeaker(speaker);
                            }
                            tier.setCategory(attributes.getValue("category"));
                            tier.setDisplayName(attributes.getValue("display-name"));
                            if (tier.getCategory() == null) {
                                throw new ExmaraldaException("Cannot read given exmaralda file '" + this.getExmaraldaFile() + "', because there is a <tier> element ('id=\"" + tier.getId() + "\"') without a @category attribute.");
                            }
                            if (attributes.getValue("type").equalsIgnoreCase("t")) {
                                tier.setType(TIER_TYPE.T);
                            } else if (attributes.getValue("type").equalsIgnoreCase("d")) {
                                tier.setType(TIER_TYPE.D);
                            } else if (attributes.getValue("type").equalsIgnoreCase("a")) {
                                tier.setType(TIER_TYPE.A);
                            } else if (attributes.getValue("type").equalsIgnoreCase("l")) {
                                tier.setType(TIER_TYPE.L);
                            } else if (attributes.getValue("type").equalsIgnoreCase("ud")) {
                                tier.setType(TIER_TYPE.U);
                            }
                            this.getBasicTranscription().getTiers().add((Object)tier);
                        } else if ("event".equals(qName)) {
                            Event event;
                            this.currEvent = event = ExmaraldaBasicFactory.eINSTANCE.createEvent();
                            for (TLI tli : this.getBasicTranscription().getCommonTimeLine().getTLIs()) {
                                if (tli.getId().equals(attributes.getValue("start"))) {
                                    event.setStart(tli);
                                }
                                if (tli.getId().equals(attributes.getValue("end"))) {
                                    event.setEnd(tli);
                                }
                                if (event.getStart() == null || event.getEnd() == null) continue;
                                break;
                            }
                            if (attributes.getValue("medium") != null) {
                                if (attributes.getValue("medium").equalsIgnoreCase("aud")) {
                                    event.setMedium(EVENT_MEDIUM.AUD);
                                } else if (attributes.getValue("medium").equalsIgnoreCase("vid")) {
                                    event.setMedium(EVENT_MEDIUM.VID);
                                } else if (attributes.getValue("medium").equalsIgnoreCase("img")) {
                                    event.setMedium(EVENT_MEDIUM.IMG);
                                } else if (attributes.getValue("medium").equalsIgnoreCase("txt")) {
                                    event.setMedium(EVENT_MEDIUM.TXT);
                                } else if (attributes.getValue("medium").equalsIgnoreCase("oth")) {
                                    event.setMedium(EVENT_MEDIUM.OTH);
                                } else {
                                    event.setMedium(null);
                                }
                            } else {
                                event.setMedium(null);
                            }
                            String url = attributes.getValue("url");
                            if (url != null && !url.isEmpty()) {
                                try {
                                    new URL(url);
                                    event.setUrl(url);
                                }
                                catch (MalformedURLException e) {
                                    throw new SAXException("Cannot set the url, because it is not a valid url: " + attributes.getValue("url") + ".", e);
                                }
                            }
                            if (this.currTier == null) {
                                throw new SAXException("File is not valid, there is an event not in a tier.");
                            }
                            this.currTier.getEvents().add((Object)event);
                        } else if ("ud-information".equals(qName)) {
                            UDInformation udInfo = ExmaraldaBasicFactory.eINSTANCE.createUDInformation();
                            udInfo.setAttributeName(attributes.getValue("attribute-name"));
                            this.currUDInfo = udInfo;
                            if ("ud-meta-information".equals(this.currObjectName.peek())) {
                                this.getBasicTranscription().getMetaInformation().getUdMetaInformations().add((Object)udInfo);
                            } else if ("ud-speaker-information".equals(this.currObjectName.peek())) {
                                this.currSpeaker.getUdSpeakerInformations().add((Object)udInfo);
                            } else if ("ud-tier-information".equals(this.currObjectName.peek())) {
                                this.currTier.getUdTierInformations().add((Object)udInfo);
                            } else if ("event".equals(this.currObjectName.peek())) {
                                this.currEvent.getUdInformations().add((Object)udInfo);
                            }
                        }
                    }
                }
            }
        }
        this.currObjectName.push(qName);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!this.currObjectName.peek().equals(qName)) {
            throw new ExmaraldaException("The given file is not wellformed. Expected element is: " + this.currObjectName.peek() + ", but given is: " + qName);
        }
        this.currObjectName.pop();
    }
}

