/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TIME_TYPE implements Enumerator
{
    UNSP(0, "unsp", "unsp"),
    USER(1, "user", "user"),
    OTHR(2, "othr", "othr"),
    INTP(3, "intp", "intp"),
    APPL(4, "appl", "appl");

    public static final int UNSP_VALUE = 0;
    public static final int USER_VALUE = 1;
    public static final int OTHR_VALUE = 2;
    public static final int INTP_VALUE = 3;
    public static final int APPL_VALUE = 4;
    private static final TIME_TYPE[] VALUES_ARRAY;
    public static final List<TIME_TYPE> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TIME_TYPE[]{UNSP, USER, OTHR, INTP, APPL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TIME_TYPE get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TIME_TYPE result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TIME_TYPE getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TIME_TYPE result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TIME_TYPE get(int value) {
        switch (value) {
            case 0: {
                return UNSP;
            }
            case 1: {
                return USER;
            }
            case 2: {
                return OTHR;
            }
            case 3: {
                return INTP;
            }
            case 4: {
                return APPL;
            }
        }
        return null;
    }

    private TIME_TYPE(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

