/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.graphannis;

import com.sun.jna.NativeLong;
import com.sun.jna.ptr.LongByReference;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.corpus_tools.graphannis.GraphUpdate;
import org.corpus_tools.graphannis.LogLevel;
import org.corpus_tools.graphannis.capi.AnnisCountExtra;
import org.corpus_tools.graphannis.capi.AnnisErrorListRef;
import org.corpus_tools.graphannis.capi.CAPI;
import org.corpus_tools.graphannis.capi.CharPointer;
import org.corpus_tools.graphannis.capi.QueryAttributeDescription;
import org.corpus_tools.graphannis.errors.GraphANNISException;
import org.corpus_tools.graphannis.errors.SetLoggerError;
import org.corpus_tools.graphannis.model.AnnoKey;
import org.corpus_tools.graphannis.model.Annotation;
import org.corpus_tools.graphannis.model.Component;
import org.corpus_tools.graphannis.model.ComponentType;
import org.corpus_tools.graphannis.model.FrequencyTableEntry;
import org.corpus_tools.graphannis.model.Graph;
import org.corpus_tools.graphannis.model.NodeDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorpusStorageManager
implements AutoCloseable {
    private final CAPI.AnnisCorpusStorage instance;
    private final Logger log = LoggerFactory.getLogger(CorpusStorageManager.class);

    public CorpusStorageManager(String dbDir) throws GraphANNISException {
        this(dbDir, null, LogLevel.Off, false);
    }

    public CorpusStorageManager(String dbDir, String logfile, LogLevel level, boolean useParallel) throws GraphANNISException {
        File dbDirFile = new File(dbDir);
        if (dbDirFile.mkdirs()) {
            this.log.info("Created directory {} for CorpusStorageManager", (Object)dbDir);
        }
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.annis_init_logging(logfile, level.getRaw(), err);
        try {
            err.checkErrors();
        }
        catch (SetLoggerError ex) {
            this.log.warn("Could not initialize graphANNIS logger", (Throwable)ex);
        }
        err = new AnnisErrorListRef();
        this.instance = CAPI.annis_cs_with_auto_cache_size(dbDir, useParallel, err);
        err.checkErrors();
    }

    public CorpusStorageManager(String dbDir, String logfile, LogLevel level, boolean useParallel, long maxCacheSize) throws GraphANNISException {
        File dbDirFile = new File(dbDir);
        if (dbDirFile.mkdirs()) {
            this.log.info("Created directory {} for CorpusStorageManager", (Object)dbDir);
        }
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.annis_init_logging(logfile, level.getRaw(), err);
        try {
            err.checkErrors();
        }
        catch (SetLoggerError ex) {
            this.log.warn("Could not initialize graphANNIS logger", (Throwable)ex);
        }
        err = new AnnisErrorListRef();
        this.instance = CAPI.annis_cs_with_max_cache_size(dbDir, maxCacheSize, useParallel, err);
        err.checkErrors();
    }

    public String[] list() throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisVec_AnnisCString orig = CAPI.annis_cs_list(this.instance, err);
        err.checkErrors();
        String[] copy = new String[CAPI.annis_vec_str_size(orig).intValue()];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = CAPI.annis_vec_str_get(orig, new NativeLong((long)i));
        }
        orig.dispose();
        return copy;
    }

    public List<Annotation> listNodeAnnotations(String corpusName, boolean listValues, boolean onlyMostFrequentValues) throws GraphANNISException {
        this.checkNotClosed();
        LinkedList<Annotation> result = new LinkedList<Annotation>();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisMatrix_AnnisCString orig = CAPI.annis_cs_list_node_annotations(this.instance, corpusName, listValues, onlyMostFrequentValues, err);
        err.checkErrors();
        int nrows = CAPI.annis_matrix_str_nrows(orig).intValue();
        int ncols = CAPI.annis_matrix_str_ncols(orig).intValue();
        if (ncols >= (listValues ? 3 : 2)) {
            for (int i = 0; i < nrows; ++i) {
                Annotation anno = new Annotation();
                AnnoKey key = new AnnoKey();
                String ns = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(0L));
                String name = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(1L));
                if (!"".equals(ns)) {
                    key.setNs(ns);
                }
                key.setName(name);
                anno.setKey(key);
                if (listValues) {
                    String val = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(2L));
                    anno.setValue(val);
                }
                result.add(anno);
            }
        }
        orig.dispose();
        return result;
    }

    public List<Annotation> listEdgeAnnotations(String corpusName, ComponentType componentType, String componentName, String componentLayer, boolean listValues, boolean onlyMostFrequentValues) throws GraphANNISException {
        this.checkNotClosed();
        LinkedList<Annotation> result = new LinkedList<Annotation>();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisMatrix_AnnisCString orig = CAPI.annis_cs_list_edge_annotations(this.instance, corpusName, componentType.toInt(), componentName, componentLayer, listValues, onlyMostFrequentValues, err);
        err.checkErrors();
        int nrows = CAPI.annis_matrix_str_nrows(orig).intValue();
        int ncols = CAPI.annis_matrix_str_ncols(orig).intValue();
        if (ncols >= (listValues ? 3 : 2)) {
            for (int i = 0; i < nrows; ++i) {
                Annotation anno = new Annotation();
                AnnoKey key = new AnnoKey();
                String ns = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(0L));
                String name = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(1L));
                if (!"".equals(ns)) {
                    key.setNs(ns);
                }
                key.setName(name);
                anno.setKey(key);
                if (listValues) {
                    String val = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(2L));
                    anno.setValue(val);
                }
                result.add(anno);
            }
        }
        orig.dispose();
        return result;
    }

    public List<Component> getAllComponentsByType(String corpusName, ComponentType componentType) throws GraphANNISException {
        this.checkNotClosed();
        LinkedList<Component> result = new LinkedList<Component>();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisVec_AnnisComponent orig = CAPI.annis_cs_list_components_by_type(this.instance, corpusName, componentType.toInt(), err);
        err.checkErrors();
        for (int i = 0; i < CAPI.annis_vec_component_size(orig).intValue(); ++i) {
            CAPI.AnnisComponentConst cOrig = CAPI.annis_vec_component_get(orig, new NativeLong((long)i));
            Component c = new Component();
            c.setType(componentType);
            CharPointer cname = CAPI.annis_component_name(cOrig);
            c.setName(cname == null ? "" : cname.toString());
            CharPointer clayer = CAPI.annis_component_layer(cOrig);
            c.setLayer(clayer == null ? "" : clayer.toString());
            result.add(c);
        }
        return result;
    }

    public boolean validateQuery(Iterable<String> corpusNames, String query, QueryLanguage queryLanguage) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisVec_AnnisCString c_corpusNames = CAPI.annis_vec_str_new();
        for (String cn : corpusNames) {
            CAPI.annis_vec_str_push(c_corpusNames, cn);
        }
        boolean result = CAPI.annis_cs_validate_query(this.instance, c_corpusNames, query, queryLanguage.capiVal, err);
        c_corpusNames.dispose();
        err.checkErrors();
        return result;
    }

    public List<NodeDesc> getNodeDescriptions(String query, QueryLanguage queryLanguage) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        QueryAttributeDescription desc = CAPI.annis_cs_node_descriptions(this.instance, query, queryLanguage.capiVal, err);
        err.checkErrors();
        return desc.getList();
    }

    public long count(Iterable<String> corpusNames, String query, QueryLanguage queryLanguage) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisVec_AnnisCString c_corpusNames = CAPI.annis_vec_str_new();
        for (String cn : corpusNames) {
            CAPI.annis_vec_str_push(c_corpusNames, cn);
        }
        long result = CAPI.annis_cs_count(this.instance, c_corpusNames, query, queryLanguage.capiVal, err);
        c_corpusNames.dispose();
        err.checkErrors();
        return result;
    }

    public CountResult countExtra(Iterable<String> corpusNames, String query, QueryLanguage queryLanguage) throws GraphANNISException {
        this.checkNotClosed();
        CountResult result = new CountResult();
        result.documentCount = 0L;
        result.matchCount = 0L;
        CAPI.AnnisVec_AnnisCString c_corpusNames = CAPI.annis_vec_str_new();
        for (String cn : corpusNames) {
            CAPI.annis_vec_str_push(c_corpusNames, cn);
        }
        AnnisErrorListRef err = new AnnisErrorListRef();
        AnnisCountExtra.ByValue resultForCorpus = CAPI.annis_cs_count_extra(this.instance, c_corpusNames, query, queryLanguage.capiVal, err);
        c_corpusNames.dispose();
        err.checkErrors();
        result.matchCount += resultForCorpus.matchCount;
        result.documentCount += resultForCorpus.documentCount;
        return result;
    }

    public String[] find(Iterable<String> corpusNames, String query, QueryLanguage queryLanguage, long offset, Optional<Long> limit) throws GraphANNISException {
        return this.find(corpusNames, query, queryLanguage, offset, limit, ResultOrder.Normal);
    }

    public String[] find(Iterable<String> corpusNames, String query, QueryLanguage queryLanguage, long offset, Optional<Long> limit, ResultOrder order) throws GraphANNISException {
        this.checkNotClosed();
        ArrayList<String> result = new ArrayList<String>();
        CAPI.AnnisVec_AnnisCString c_corpusNames = CAPI.annis_vec_str_new();
        for (String cn : corpusNames) {
            CAPI.annis_vec_str_push(c_corpusNames, cn);
        }
        AnnisErrorListRef err = new AnnisErrorListRef();
        LongByReference limit_ref = limit.isPresent() ? new LongByReference(limit.get().longValue()) : null;
        CAPI.AnnisVec_AnnisCString vec = CAPI.annis_cs_find(this.instance, c_corpusNames, query, queryLanguage.capiVal, offset, limit_ref, order.capiVal, err);
        c_corpusNames.dispose();
        err.checkErrors();
        int vecSize = CAPI.annis_vec_str_size(vec).intValue();
        for (int i = 0; i < vecSize; ++i) {
            result.add(CAPI.annis_vec_str_get(vec, new NativeLong((long)i)));
        }
        vec.dispose();
        return result.toArray(new String[0]);
    }

    public Graph subgraph(String corpusName, List<String> nodeIDs, long ctxLeft, long ctxRight, Optional<String> segmentation) throws GraphANNISException {
        this.checkNotClosed();
        CAPI.AnnisVec_AnnisCString c_node_ids = CAPI.annis_vec_str_new();
        for (String id : nodeIDs) {
            CAPI.annis_vec_str_push(c_node_ids, id);
        }
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisGraph graph = CAPI.annis_cs_subgraph(this.instance, corpusName, c_node_ids, new NativeLong(ctxLeft), new NativeLong(ctxRight), segmentation.orElse(null), err);
        err.checkErrors();
        c_node_ids.dispose();
        return new Graph(graph);
    }

    public Graph subcorpusGraph(String corpusName, List<String> documentIDs) throws GraphANNISException {
        this.checkNotClosed();
        CAPI.AnnisVec_AnnisCString c_document_ids = CAPI.annis_vec_str_new();
        for (String id : documentIDs) {
            CAPI.annis_vec_str_push(c_document_ids, id);
        }
        Graph result = null;
        if (this.instance != null) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            CAPI.AnnisGraph graph = CAPI.annis_cs_subcorpus_graph(this.instance, corpusName, c_document_ids, err);
            err.checkErrors();
            c_document_ids.dispose();
            result = new Graph(graph);
        }
        return result;
    }

    public Graph corpusGraph(String corpusName) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisGraph graph = CAPI.annis_cs_corpus_graph(this.instance, corpusName, err);
        err.checkErrors();
        return new Graph(graph);
    }

    public Graph corpusGraphForQuery(String corpusName, String query, QueryLanguage queryLanguage) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisGraph graph = CAPI.annis_cs_subgraph_for_query_with_ctype(this.instance, corpusName, query, queryLanguage.capiVal, ComponentType.PartOf.toInt(), err);
        err.checkErrors();
        return new Graph(graph);
    }

    public Graph subGraphForQuery(String corpusName, String query, QueryLanguage queryLanguage) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisGraph graph = CAPI.annis_cs_subgraph_for_query(this.instance, corpusName, query, queryLanguage.capiVal, err);
        err.checkErrors();
        return new Graph(graph);
    }

    public List<FrequencyTableEntry<String>> frequency(Iterable<String> corpusNames, String query, QueryLanguage queryLanguage, String frequencyQueryDefinition) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisVec_AnnisCString c_corpusNames = CAPI.annis_vec_str_new();
        for (String cn : corpusNames) {
            CAPI.annis_vec_str_push(c_corpusNames, cn);
        }
        CAPI.AnnisFrequencyTable_AnnisCString orig = CAPI.annis_cs_frequency(this.instance, c_corpusNames, query, queryLanguage.capiVal, frequencyQueryDefinition, err);
        c_corpusNames.dispose();
        err.checkErrors();
        if (orig != null) {
            ArrayList<FrequencyTableEntry<String>> result = new ArrayList<FrequencyTableEntry<String>>();
            int nrows = CAPI.annis_freqtable_str_nrows(orig).intValue();
            int ncols = CAPI.annis_freqtable_str_ncols(orig).intValue();
            for (int i = 0; i < nrows; ++i) {
                NativeLong count = CAPI.annis_freqtable_str_count(orig, new NativeLong((long)i));
                String[] tuple = new String[ncols];
                for (int c = 0; c < ncols; ++c) {
                    tuple[c] = CAPI.annis_freqtable_str_get(orig, new NativeLong((long)i), new NativeLong((long)c));
                }
                result.add(new FrequencyTableEntry<String>(tuple, count.longValue()));
            }
            return result;
        }
        return null;
    }

    public void importFromFileSystem(String path, ImportFormat format, String corpusName, boolean diskBased) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.annis_cs_import_from_fs(this.instance, path, format.capiVal, corpusName, diskBased, err);
        err.checkErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToFileSystem(String[] corpora, String path, ExportFormat format) throws GraphANNISException {
        this.checkNotClosed();
        CAPI.AnnisVec_AnnisCString c_corpusNames = CAPI.annis_vec_str_new();
        for (String cn : corpora) {
            CAPI.annis_vec_str_push(c_corpusNames, cn);
        }
        try {
            AnnisErrorListRef err = new AnnisErrorListRef();
            CAPI.annis_cs_export_to_fs(this.instance, c_corpusNames, path, format.capiVal, err);
            err.checkErrors();
        }
        finally {
            c_corpusNames.dispose();
        }
    }

    public boolean deleteCorpus(String corpusName) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        boolean result = CAPI.annis_cs_delete(this.instance, corpusName, err);
        err.checkErrors();
        return result;
    }

    public void unloadCorpus(String corpusName) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.annis_cs_unload(this.instance, corpusName, err);
        err.checkErrors();
    }

    public void applyUpdate(String corpusName, GraphUpdate update) throws GraphANNISException {
        this.checkNotClosed();
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.annis_cs_apply_update(this.instance, corpusName, update.getInstance(), err);
        err.checkErrors();
    }

    private void checkNotClosed() throws GraphANNISException {
        if (this.instance.isClosed()) {
            throw new GraphANNISException("Corpus storage has been closed already");
        }
    }

    @Override
    public void close() throws Exception {
        this.instance.dispose();
    }

    public static enum ExportFormat {
        GrapML(0),
        GraphMLZip(1),
        GraphMLDirectory(2);

        protected final int capiVal;

        private ExportFormat(int capiVal) {
            this.capiVal = capiVal;
        }
    }

    public static enum ImportFormat {
        RelANNIS(0),
        GraphML(1);

        protected final int capiVal;

        private ImportFormat(int capiVal) {
            this.capiVal = capiVal;
        }
    }

    public static enum ResultOrder {
        Normal(0),
        Inverted(1),
        Randomized(2),
        NotSorted(3);

        protected final int capiVal;

        private ResultOrder(int capiVal) {
            this.capiVal = capiVal;
        }
    }

    public static enum QueryLanguage {
        AQL(0),
        AQLQuirksV3(1);

        protected final int capiVal;

        private QueryLanguage(int capiVal) {
            this.capiVal = capiVal;
        }
    }

    public static class CountResult {
        public long matchCount;
        public long documentCount;
    }
}

