/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.testFramework.helpers;

import java.util.Set;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.corpus_tools.pepper.common.ModuleFitness;
import org.corpus_tools.pepper.core.ModuleFitnessChecker;
import org.corpus_tools.pepper.testFramework.PepperTestUtil;
import org.corpus_tools.pepper.testFramework.helpers.PepperModuleTestHelper;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.junit.Test;

public abstract class PepperModuleTest
extends PepperModuleTestHelper {
    @Test
    public void checkThatFixtureIsSet() {
        ((AbstractObjectAssert)Assertions.assertThat((Object)this.getFixture()).as("Please inject your module implementation with setFixture(PepperModule). ", new Object[0])).isNotNull();
    }

    @Test
    public void checkThatCorpusGraphIsSettable() {
        this.whenFixtureIsNullThenFail();
        SCorpusGraph corpGraph = SaltFactory.createSCorpusGraph();
        this.getFixture().setCorpusGraph(corpGraph);
        ((AbstractObjectAssert)Assertions.assertThat((Object)this.getFixture().getCorpusGraph()).as("When setting and getting the corpus graph, both should be same. ", new Object[0])).isEqualTo((Object)corpGraph);
    }

    private void whenFixtureIsNullThenFail() {
        if (this.getFixture() == null) {
            Assertions.fail((String)"Cannot run tests when no fixture is set. Please call setFixture(PepperModule) before running test. ");
        }
    }

    @Test
    public void checkThatModuleHasName() {
        this.whenFixtureIsNullThenFail();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.getFixture().getName()).as("A module's name must not be empty. ", new Object[0])).isNotEmpty();
    }

    @Test
    public void checkThatResourcePathIsSet() {
        this.whenFixtureIsNullThenFail();
        this.getFixture().setResources(this.resourceURI);
        String msg = "Cannot run test, because resources arent set. Please call setResourcesURI(URI resourceURI) before start testing. ";
        ((AbstractObjectAssert)Assertions.assertThat((Object)this.resourceURI).as("Cannot run test, because resources arent set. Please call setResourcesURI(URI resourceURI) before start testing. ", new Object[0])).isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)this.getFixture().getResources()).as("Cannot run test, because resources arent set. Please call setResourcesURI(URI resourceURI) before start testing. ", new Object[0])).isEqualTo((Object)this.resourceURI);
    }

    @Test
    public void checkThatWhenSimulatingFitnessCheckModulePassesSelfTest() {
        this.whenFixtureIsNullThenFail();
        if (this.getFixture().getSelfTestDesc() == null) {
            return;
        }
        ModuleFitness fitness = this.runSelfTest();
        this.checkThatWhenSimulatingFitnessCheckModulePassesSelfTest(fitness);
    }

    protected ModuleFitness runSelfTest() {
        return new ModuleFitnessChecker(PepperTestUtil.createDefaultPepper()).selfTest(this.fixture);
    }

    protected abstract void checkThatWhenSimulatingFitnessCheckModulePassesSelfTest(ModuleFitness var1);

    protected String diffsBetweenActualAndExpected() {
        Set diffs = SaltUtil.compare(SaltUtil.loadSaltProject((URI)this.fixture.getSelfTestDesc().getExpectedCorpusPath()).getCorpusGraphs().get(0)).with(this.fixture.getSaltProject().getCorpusGraphs().get(0)).andFindDiffs();
        if (!diffs.isEmpty()) {
            return "There are differences between actual and expected Salt model: " + diffs;
        }
        return diffs.toString();
    }
}

