/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.testFramework.helpers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.corpus_tools.pepper.exceptions.PepperTestException;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.testFramework.PepperTestUtil;
import org.corpus_tools.pepper.util.FileComparator;
import org.corpus_tools.salt.SaltFactory;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PepperModuleTestHelper {
    protected static final Logger logger = LoggerFactory.getLogger((String)"Pepper");
    protected URI resourceURI = null;
    protected PepperModule fixture = null;
    public static String TMP_TEST_DIR = PepperTestUtil.TMP_TEST_DIR;

    public PepperModuleTestHelper() {
        this.initialize();
    }

    protected void setFixture(PepperModule fixture) {
        this.fixture = fixture;
        if (this.resourceURI != null) {
            this.getFixture().setResources(this.resourceURI);
        }
        this.getFixture().setSaltProject(SaltFactory.createSaltProject());
        this.getFixture().getSaltProject().addCorpusGraph(SaltFactory.createSCorpusGraph());
    }

    protected PepperModule getFixture() {
        return this.fixture;
    }

    public void initialize() {
        this.setResourcesURI(URI.createFileURI((String)"src/main/resources"));
    }

    public URI getTempURI(String testDirectory) {
        return URI.createFileURI((String)PepperModuleTestHelper.getTempPath_static(testDirectory).getAbsolutePath());
    }

    public File getTempPath(String testDirectory) {
        return PepperModuleTestHelper.getTempPath_static(testDirectory);
    }

    public static File getTempPath_static(String testDirectory) {
        return PepperTestUtil.getTempPath_static(testDirectory);
    }

    public static String getTestResources() {
        return PepperTestUtil.getTestResources();
    }

    public static String getSrcResources() {
        return PepperTestUtil.getSrcResources();
    }

    public void start() {
        ArrayList<PepperModule> fixtures = new ArrayList<PepperModule>();
        fixtures.add(this.getFixture());
        PepperTestUtil.start(fixtures);
    }

    public void setResourcesURI(URI resourceURI) {
        if (resourceURI == null) {
            throw new PepperTestException("A resource uri must be set.");
        }
        File resourceDir = new File(resourceURI.toFileString());
        if (!resourceDir.exists() && !resourceDir.mkdirs()) {
            logger.warn("Cannot create folder {}. ", (Object)resourceDir);
        }
        this.resourceURI = resourceURI;
        if (this.getFixture() != null) {
            this.getFixture().setResources(resourceURI);
        }
    }

    public boolean compareFiles(URI uri1, URI uri2) throws IOException {
        return this.compareFiles(new File(uri1.toFileString()), new File(uri2.toFileString()));
    }

    public boolean compareFiles(File file1, File file2) throws IOException {
        FileComparator comparator = new FileComparator();
        return comparator.compareFiles(file1, file2);
    }
}

