/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.testFramework;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.corpus_tools.pepper.common.CorpusDesc;
import org.corpus_tools.pepper.common.FormatDesc;
import org.corpus_tools.pepper.common.MEMORY_POLICY;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.common.Pepper;
import org.corpus_tools.pepper.common.PepperConfiguration;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.PepperUtil;
import org.corpus_tools.pepper.core.PepperImpl;
import org.corpus_tools.pepper.core.PepperJobImpl;
import org.corpus_tools.pepper.core.Step;
import org.corpus_tools.pepper.modules.DocumentController;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.coreModules.DoNothingExporter;
import org.corpus_tools.pepper.modules.coreModules.DoNothingImporter;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleTestException;
import org.corpus_tools.pepper.testFramework.helpers.PepperModuleTest;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.eclipse.emf.common.util.URI;

public class PepperTestUtil {
    public static String TMP_TEST_DIR = "pepper-test";

    public static File getTempPath_static(String testDirectory) {
        if (testDirectory == null || testDirectory.isEmpty()) {
            throw new PepperModuleTestException("Cannot return a temporary directory, since the given last part is empty.");
        }
        File retVal = null;
        retVal = PepperUtil.getTempTestFile(TMP_TEST_DIR + "/" + testDirectory);
        return retVal;
    }

    public static String getSrcResources() {
        return "src/main/resources/";
    }

    public static String getTestResources() {
        return "src/test/resources/";
    }

    private static Step createAlibiStep(boolean createAlibiImporter) {
        URI dummyResourceURI = URI.createFileURI((String)new File(System.getProperty("java.io.tmpdir")).getAbsolutePath());
        File tmpFolder = PepperModuleTest.getTempPath_static("pepperModuleTest");
        Step step = null;
        CorpusDesc corpusDesc = new CorpusDesc();
        corpusDesc.setCorpusPath(URI.createFileURI((String)tmpFolder.getAbsolutePath()));
        FormatDesc formatDesc = new FormatDesc();
        formatDesc.setFormatName("doNothing");
        formatDesc.setFormatVersion("0.0");
        corpusDesc.setFormatDesc(formatDesc);
        if (createAlibiImporter) {
            step = new Step("doNothing_import_step");
            DoNothingImporter importer = new DoNothingImporter();
            importer.setResources(dummyResourceURI);
            importer.setCorpusDesc(corpusDesc);
            step.setPepperModule(importer);
            step.setModuleType(MODULE_TYPE.IMPORTER);
        } else {
            step = new Step("doNothing_export_step");
            DoNothingExporter exporter = new DoNothingExporter();
            exporter.setCorpusDesc(corpusDesc);
            exporter.setResources(dummyResourceURI);
            step.setPepperModule(exporter);
            step.setModuleType(MODULE_TYPE.EXPORTER);
        }
        step.setCorpusDesc(corpusDesc);
        step.setName("DoNothingImporter");
        return step;
    }

    public static Pepper createDefaultPepper() {
        PepperImpl pepper = new PepperImpl();
        PepperConfiguration conf = new PepperConfiguration();
        conf.setProperty("pepper.memPolicy", MEMORY_POLICY.MODERATE.toString());
        return pepper;
    }

    public static void start(Collection<? extends PepperModule> fixtures) {
        PepperTestUtil.start(PepperTestUtil.createDefaultPepper(), fixtures);
    }

    @SafeVarargs
    public static <T extends PepperModule> void runPepperForTest(T ... fixtures) {
        PepperTestUtil.start(PepperTestUtil.createDefaultPepper(), Arrays.asList(fixtures));
    }

    public static PepperJob prepareFixturesAndCreateJob(Pepper pepper, Collection<? extends PepperModule> fixtures) {
        PepperJob job;
        if (fixtures == null) {
            throw new PepperModuleTestException("Cannot start Pepper modules, because the list of fixtures is not set.");
        }
        ArrayList<PepperImporter> importers = new ArrayList<PepperImporter>();
        ArrayList<PepperExporter> exporters = new ArrayList<PepperExporter>();
        SaltProject saltProject = null;
        boolean hasOnlyOneFixture = true;
        for (PepperModule pepperModule : fixtures) {
            if (hasOnlyOneFixture) {
                saltProject = pepperModule.getSaltProject();
            } else if (saltProject != pepperModule.getSaltProject()) {
                throw new PepperModuleTestException("Cannot run test because the SaltProject objects are not equal for all Pepper modules. ");
            }
            hasOnlyOneFixture = false;
            if (pepperModule.getResources() == null) {
                pepperModule.setResources(URI.createFileURI((String)"src/main/resources"));
            }
            if (pepperModule instanceof PepperImporter) {
                importers.add((PepperImporter)pepperModule);
                continue;
            }
            if (!(pepperModule instanceof PepperExporter)) continue;
            exporters.add((PepperExporter)pepperModule);
        }
        if (saltProject == null) {
            saltProject = SaltFactory.createSaltProject();
            for (PepperModule pepperModule : fixtures) {
                pepperModule.setSaltProject(saltProject);
            }
        }
        if (!((job = pepper.getJob(pepper.createJob())) instanceof PepperJobImpl)) {
            throw new PepperModuleTestException("Cannot start Pepper module test, because '" + PepperJob.class + "' is not of type '" + PepperJobImpl.class + "'. ");
        }
        ((PepperJobImpl)job).setSaltProject(saltProject);
        PepperTestUtil.createStepForFixtures(fixtures, job);
        if (importers.isEmpty() || importers.size() != saltProject.getCorpusGraphs().size()) {
            for (SCorpusGraph cGraph : saltProject.getCorpusGraphs()) {
                boolean isAssociated = false;
                for (PepperModule pepperModule : fixtures) {
                    if (pepperModule.getCorpusGraph() != cGraph) continue;
                    isAssociated = true;
                    break;
                }
                if (isAssociated) continue;
                Step alibiStep = PepperTestUtil.createAlibiStep(true);
                ((PepperJobImpl)job).addStep(alibiStep);
            }
        }
        if (exporters.isEmpty()) {
            Step step = PepperTestUtil.createAlibiStep(false);
            ((PepperJobImpl)job).addStep(step);
        }
        return job;
    }

    public static void start(Pepper pepper, Collection<? extends PepperModule> fixtures) {
        PepperJob job = PepperTestUtil.prepareFixturesAndCreateJob(pepper, fixtures);
        job.convert();
        for (DocumentController controller : ((PepperJobImpl)job).getDocumentControllers()) {
            controller.awake();
        }
    }

    private static void createStepForFixtures(Collection<? extends PepperModule> fixtures, PepperJob job) {
        for (PepperModule pepperModule : fixtures) {
            Step fixtureStep = new Step("fixture_step");
            fixtureStep.setModuleType(pepperModule.getModuleType());
            fixtureStep.setName(pepperModule.getName());
            fixtureStep.setVersion(pepperModule.getVersion());
            if (pepperModule instanceof PepperImporter) {
                fixtureStep.setCorpusDesc(((PepperImporter)pepperModule).getCorpusDesc());
            } else if (pepperModule instanceof PepperExporter) {
                fixtureStep.setCorpusDesc(((PepperExporter)pepperModule).getCorpusDesc());
            }
            fixtureStep.setPepperModule(pepperModule);
            ((PepperJobImpl)job).addStep(fixtureStep);
        }
    }
}

