/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.StepDesc;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.modules.exceptions.PepperModulePropertyException;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class PepperParamsReader
extends DefaultHandler2 {
    public static final String NS_XMI = "http://www.omg.org/XMI";
    public static final String PREFIX_XMI = "xmi";
    public static final String NS_PEPPERPARAMS = "de.hu_berlin.german.korpling.saltnpepper.pepper.pepperParams";
    public static final String PREFIX_PEPPERPARAMS = "pepperParams";
    public static final String ELEMENT_PEPPERPARAMS = "PepperParams";
    public static final String ELEMENT_PEPPER_JOB_PARAMS = "pepperJobParams";
    public static final String ELEMENT_IMPORTER_PARAMS = "importerParams";
    public static final String ELEMENT_MODULE_PARAMS = "moduleParams";
    public static final String ELEMENT_EXPORTER_PARAMS = "exporterParams";
    public static final String ATT_ID = "id";
    public static final String ATT_MODULE_NAME = "moduleName";
    public static final String ATT_FORMAT_NAME = "formatName";
    public static final String ATT_FORMAT_VERSION = "formatVersion";
    public static final String ATT_SOURCE_PATH = "sourcePath";
    public static final String ATT_DEST_PATH = "destinationPath";
    public static final String ATT_SPECIAL_PARAMS = "specialParams";
    private PepperJob job = null;
    private URI location = null;

    public PepperJob getJob() {
        return this.job;
    }

    public void setJob(PepperJob job) {
        this.job = job;
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        File pathFile;
        StepDesc stepDesc = null;
        if (ELEMENT_IMPORTER_PARAMS.equals(qName)) {
            stepDesc = new StepDesc();
            stepDesc.setModuleType(MODULE_TYPE.IMPORTER);
            if (attributes.getValue(ATT_MODULE_NAME) != null) {
                stepDesc.setName(attributes.getValue(ATT_MODULE_NAME));
            }
            if (attributes.getValue(ATT_FORMAT_NAME) != null) {
                stepDesc.getCorpusDesc().getFormatDesc().setFormatName(attributes.getValue(ATT_FORMAT_NAME));
                if (attributes.getValue(ATT_FORMAT_VERSION) != null) {
                    stepDesc.getCorpusDesc().getFormatDesc().setFormatVersion(attributes.getValue(ATT_FORMAT_VERSION));
                }
            }
            if (attributes.getValue(ATT_SOURCE_PATH) != null && (pathFile = this.resolveFile(attributes.getValue(ATT_SOURCE_PATH))) != null) {
                URI path = URI.createFileURI((String)pathFile.getAbsolutePath());
                stepDesc.getCorpusDesc().setCorpusPath(path);
            }
        } else if (ELEMENT_MODULE_PARAMS.equals(qName)) {
            stepDesc = new StepDesc();
            stepDesc.setModuleType(MODULE_TYPE.MANIPULATOR);
            if (attributes.getValue(ATT_MODULE_NAME) != null) {
                stepDesc.setName(attributes.getValue(ATT_MODULE_NAME));
            }
        } else if (ELEMENT_EXPORTER_PARAMS.equals(qName)) {
            stepDesc = new StepDesc();
            stepDesc.setModuleType(MODULE_TYPE.EXPORTER);
            if (attributes.getValue(ATT_MODULE_NAME) != null) {
                stepDesc.setName(attributes.getValue(ATT_MODULE_NAME));
            }
            if (attributes.getValue(ATT_FORMAT_NAME) != null) {
                stepDesc.getCorpusDesc().getFormatDesc().setFormatName(attributes.getValue(ATT_FORMAT_NAME));
                if (attributes.getValue(ATT_FORMAT_VERSION) != null) {
                    stepDesc.getCorpusDesc().getFormatDesc().setFormatVersion(attributes.getValue(ATT_FORMAT_VERSION));
                }
            }
            if (attributes.getValue(ATT_DEST_PATH) != null && (pathFile = this.resolveFile(attributes.getValue(ATT_DEST_PATH))) != null) {
                String pathStr = pathFile.getAbsolutePath();
                URI path = URI.createFileURI((String)pathStr);
                stepDesc.getCorpusDesc().setCorpusPath(path);
            }
        }
        if (stepDesc != null) {
            if (attributes.getValue(ATT_SPECIAL_PARAMS) != null) {
                File propFile = this.resolveFile(attributes.getValue(ATT_SPECIAL_PARAMS));
                Properties props = new Properties();
                try (FileInputStream str = new FileInputStream(propFile);){
                    props.load(str);
                }
                catch (FileNotFoundException e) {
                    throw new PepperModulePropertyException("Cannot load property file.", e);
                }
                catch (IOException e) {
                    throw new PepperModulePropertyException("Cannot load property file.", e);
                }
                stepDesc.setProps(props);
            }
            this.getJob().addStepDesc(stepDesc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File resolveFile(String fileStr) {
        File retFile = null;
        if (fileStr == null) return retFile;
        if (fileStr.isEmpty()) return retFile;
        fileStr = fileStr.replace("file:", "");
        fileStr = fileStr.replace("///", "/");
        File file = new File(fileStr = fileStr.replace("//", "/"));
        if (file == null) return retFile;
        if (file.isAbsolute()) return new File(fileStr);
        if (this.getLocation() == null) throw new PepperFWException("An error reading pepper-params file occured, there was an relative uri '" + fileStr + "', but the base path to resolve it (via setLocation()) was not set. ");
        File location = new File(this.getLocation().toFileString());
        if (!location.isDirectory()) {
            location = location.getParentFile();
        }
        file = new File(fileStr.replace("./", ""));
        return new File(location.getAbsolutePath() + "/" + file);
    }
}

