/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules.coreModules;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.impl.PepperExporterImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="TextExporterComponent", factory="PepperExporterComponentFactory")
public class TextExporter
extends PepperExporterImpl
implements PepperExporter {
    public static final String MODULE_NAME = "TextExporter";
    public static final String FORMAT_NAME = "txt";
    public static final String FORMAT_VERSION = "1.0";

    public TextExporter() {
        super(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This is a PepperExporter which extracts and exports the primary text of a Salt model and stores it into a text file. ");
        this.addSupportedFormat(FORMAT_NAME, FORMAT_VERSION, null);
        this.setExportMode(PepperExporter.EXPORT_MODE.DOCUMENTS_IN_FILES);
        this.setDocumentEnding(FORMAT_NAME);
    }

    @Override
    public SelfTestDesc getSelfTestDesc() {
        return new SelfTestDesc(this.getResources().appendSegment("modules").appendSegment("selfTests").appendSegment("txtExporter").appendSegment("in"), this.getResources().appendSegment("modules").appendSegment("selfTests").appendSegment("txtExporter").appendSegment("expected"));
    }

    @Override
    public PepperMapper createPepperMapper(Identifier sElementId) {
        PepperMapperImpl mapper = new PepperMapperImpl(){

            @Override
            public DOCUMENT_STATUS mapSDocument() {
                if (this.getDocument() != null && this.getResourceURI() != null) {
                    for (STextualDS text : this.getDocument().getDocumentGraph().getTextualDSs()) {
                        File outFile = null;
                        String uriStr = this.getResourceURI().toFileString();
                        if (uriStr == null) {
                            uriStr = this.getResourceURI().toString();
                        }
                        if (this.getDocument().getDocumentGraph().getTextualDSs().size() > 1) {
                            String extension = "." + this.getResourceURI().fileExtension();
                            int pos = uriStr.lastIndexOf(extension);
                            uriStr = uriStr.substring(0, pos) + "_" + text.getPath().fragment() + extension;
                        }
                        outFile = new File(uriStr);
                        PrintWriter out = null;
                        try {
                            out = new PrintWriter(outFile);
                        }
                        catch (FileNotFoundException e) {
                            throw new PepperModuleException(this, "Cannot write primary text '" + text.getIdentifier() + "' to file '" + outFile.getAbsolutePath() + "'. ", (Throwable)e);
                        }
                        if (out == null) continue;
                        out.print(text.getText());
                        out.flush();
                        out.close();
                    }
                }
                return DOCUMENT_STATUS.COMPLETED;
            }
        };
        mapper.setResourceURI(this.getIdentifier2ResourceTable().get(sElementId));
        return mapper;
    }
}

