/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules.coreModules;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="TextImporterComponent", factory="PepperImporterComponentFactory")
public class TextImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String MODULE_NAME = "TextImporter";
    public static final String FORMAT_NAME = "txt";
    public static final String FORMAT_VERSION = "0.0";

    public TextImporter() {
        super(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This importer imports a simple text document like .txt etc. . Even other documents can be imported as simple text. ");
        this.addSupportedFormat(FORMAT_NAME, FORMAT_VERSION, null);
        this.getDocumentEndings().add(FORMAT_NAME);
    }

    @Override
    public Double isImportable(URI corpusPath) {
        return 1.0;
    }

    @Override
    public SelfTestDesc getSelfTestDesc() {
        return new SelfTestDesc(this.getResources().appendSegment("modules").appendSegment("selfTests").appendSegment("txtImporter").appendSegment("in").appendSegment("txtCorpus"), this.getResources().appendSegment("modules").appendSegment("selfTests").appendSegment("txtImporter").appendSegment("expected"));
    }

    @Override
    public PepperMapper createPepperMapper(Identifier sElementId) {
        TextMapper mapper = new TextMapper();
        mapper.setResourceURI(this.getIdentifier2ResourceTable().get(sElementId));
        return mapper;
    }

    public static class TextMapper
    extends PepperMapperImpl {
        @Override
        public DOCUMENT_STATUS mapSDocument() {
            if (this.getResourceURI() == null) {
                throw new PepperModuleException(this, "Cannot map txt-file, because the given resurce uri is empty.");
            }
            if (this.getDocument().getDocumentGraph() == null) {
                this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
            }
            StringBuilder sb = new StringBuilder();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(this.getResourceURI().toFileString()));
                String line = br.readLine();
                boolean isFirstLine = true;
                while (line != null) {
                    if (!isFirstLine) {
                        sb.append(System.getProperty("line.separator").toString());
                    }
                    sb.append(line);
                    isFirstLine = false;
                    line = br.readLine();
                }
            }
            catch (FileNotFoundException e) {
                throw new PepperModuleException(this, "Cannot read file '" + this.getResourceURI() + "', because of nested exception: ", (Throwable)e);
            }
            catch (IOException e) {
                throw new PepperModuleException(this, "Cannot read file '" + this.getResourceURI() + "', because of nested exception: ", (Throwable)e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new PepperModuleException(this, "Cannot close file '" + this.getResourceURI() + "', because of nested exception: ", (Throwable)e);
                    }
                }
            }
            this.getDocument().getDocumentGraph().createTextualDS(sb.toString());
            return DOCUMENT_STATUS.COMPLETED;
        }
    }
}

